/*
 * Decompiled with CFR 0.152.
 */
package com.javaquery.util.time;

import com.javaquery.util.time.DateTimeFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public final class LocalDates {
    private LocalDates() {
    }

    public static LocalDate addInLocalDate(LocalDate date, int type, int amount) {
        if (date != null) {
            switch (type) {
                case 5: {
                    return date.plusDays(amount);
                }
                case 2: {
                    return date.plusMonths(amount);
                }
                case 1: {
                    return date.plusYears(amount);
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
        return null;
    }

    public static LocalDateTime addInLocalDateTime(LocalDateTime dateTime, int type, int amount) {
        if (dateTime != null) {
            switch (type) {
                case 5: {
                    return dateTime.plusDays(amount);
                }
                case 2: {
                    return dateTime.plusMonths(amount);
                }
                case 1: {
                    return dateTime.plusYears(amount);
                }
                case 3: {
                    return dateTime.plusWeeks(amount);
                }
                case 10: 
                case 11: {
                    return dateTime.plusHours(amount);
                }
                case 12: {
                    return dateTime.plusMinutes(amount);
                }
                case 13: {
                    return dateTime.plusSeconds(amount);
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
        return null;
    }

    public static LocalDate addInCurrentLocalDate(int type, int amount) {
        return LocalDates.addInLocalDate(LocalDate.now(), type, amount);
    }

    public static LocalDateTime addInCurrentLocalDateTime(int type, int amount) {
        return LocalDates.addInLocalDateTime(LocalDateTime.now(), type, amount);
    }

    public static LocalDate parseLocalDate(String date, DateTimeFormat dateTimeFormat, ZoneId zoneId) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateTimeFormat.getValue());
            try {
                ZonedDateTime zonedDateTime = ZonedDateTime.parse(date, formatter.withZone(zoneId));
                return zonedDateTime.toLocalDate();
            }
            catch (Exception e) {
                return LocalDate.parse(date, formatter);
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static LocalDate parseLocalDate(String date, DateTimeFormat dateTimeFormat) {
        return LocalDates.parseLocalDate(date, dateTimeFormat, ZoneId.systemDefault());
    }

    public static LocalDateTime parseLocalDateTime(String date, DateTimeFormat dateTimeFormat, ZoneId zoneId) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateTimeFormat.getValue());
            try {
                ZonedDateTime zonedDateTime = ZonedDateTime.parse(date, formatter.withZone(zoneId));
                return zonedDateTime.toLocalDateTime();
            }
            catch (Exception e) {
                return LocalDateTime.parse(date, formatter);
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static LocalDateTime parseLocalDateTime(String date, DateTimeFormat dateTimeFormat) {
        return LocalDates.parseLocalDateTime(date, dateTimeFormat, ZoneId.systemDefault());
    }

    public static String formatLocalDate(LocalDate date, DateTimeFormat dateTimeFormat, ZoneId zoneId) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateTimeFormat.getValue());
        ZonedDateTime zonedDateTime = date.atStartOfDay(zoneId);
        return zonedDateTime.format(formatter);
    }

    public static String formatLocalDate(LocalDate date, DateTimeFormat dateTimeFormat) {
        return LocalDates.formatLocalDate(date, dateTimeFormat, ZoneId.systemDefault());
    }

    public static String formatLocalDateTime(LocalDateTime dateTime, DateTimeFormat dateTimeFormat, ZoneId zoneId) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(dateTimeFormat.getValue());
        ZonedDateTime zonedDateTime = dateTime.atZone(zoneId);
        return zonedDateTime.format(formatter);
    }

    public static String formatLocalDateTime(LocalDateTime dateTime, DateTimeFormat dateTimeFormat) {
        return LocalDates.formatLocalDateTime(dateTime, dateTimeFormat, ZoneId.systemDefault());
    }

    public static long toEpochSeconds(LocalDate localDate, ZoneId zoneId) {
        return localDate.atStartOfDay(zoneId).toEpochSecond();
    }

    public static long toEpochSeconds(LocalDate localDate) {
        return LocalDates.toEpochSeconds(localDate, ZoneId.systemDefault());
    }

    public static LocalDate fromEpochSeconds(long epochSeconds, ZoneId zoneId) {
        return LocalDateTime.ofEpochSecond(epochSeconds, 0, zoneId.getRules().getOffset(Instant.ofEpochSecond(epochSeconds))).toLocalDate();
    }

    public static LocalDate fromEpochSeconds(long epochSeconds) {
        return LocalDates.fromEpochSeconds(epochSeconds, ZoneId.systemDefault());
    }

    public static long toEpochSeconds(LocalDateTime localDateTime, ZoneId zoneId) {
        return localDateTime.atZone(zoneId).toEpochSecond();
    }

    public static long toEpochSeconds(LocalDateTime localDateTime) {
        return LocalDates.toEpochSeconds(localDateTime, ZoneId.systemDefault());
    }

    public static LocalDateTime fromEpochSecondsLocalDateTime(long epochSeconds, ZoneId zoneId) {
        return LocalDateTime.ofEpochSecond(epochSeconds, 0, zoneId.getRules().getOffset(Instant.ofEpochSecond(epochSeconds)));
    }

    public static LocalDateTime fromEpochSecondsLocalDateTime(long epochSeconds) {
        return LocalDates.fromEpochSecondsLocalDateTime(epochSeconds, ZoneId.systemDefault());
    }

    public static boolean compare(LocalDate dt1, LocalDate dt2) {
        if (dt1 == null || dt2 == null) {
            return false;
        }
        return dt1.isEqual(dt2);
    }

    public static boolean compareIgnoringMS(LocalDateTime dt1, LocalDateTime dt2) {
        if (dt1 == null || dt2 == null) {
            return false;
        }
        return dt1.withNano(0).isEqual(dt2.withNano(0));
    }

    public static LocalDate getLocalDate(int year, int month, int day) {
        return LocalDate.of(year, month, day);
    }

    public static LocalDateTime getLocalDateTime(int year, int month, int day, int hour, int minute, int second) {
        return LocalDateTime.of(year, month, day, hour, minute, second);
    }

    public static LocalDate currentLocalDate() {
        return LocalDate.now();
    }

    public static LocalDateTime currentLocalDateTime() {
        return LocalDateTime.now();
    }
}

