/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.facebooktestjavaapi.testuser.impl;

import com.jayway.facebooktestjavaapi.testuser.FacebookTestUserAccount;
import com.jayway.facebooktestjavaapi.testuser.impl.HttpClientFacebookTestUserStore;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFacebookTestUserAccount
implements FacebookTestUserAccount {
    private static final Logger log = LoggerFactory.getLogger(HttpClientFacebookTestUserAccount.class);
    private final HttpClientFacebookTestUserStore helper;
    private JSONObject jsonUser;

    public HttpClientFacebookTestUserAccount(HttpClientFacebookTestUserStore helper, JSONObject user) {
        this.helper = helper;
        this.jsonUser = user;
    }

    public void delete() {
        String result = this.helper.delete("/%s", this.id());
        log.debug("Deleted account [{}]: [{}]", (Object)this.id(), (Object)result);
    }

    public void copyToOtherApplication(String applicationId, String accessToken, boolean appInstalled, String permissions) {
        if (permissions == null) {
            permissions = "email,offline_access";
        }
        String result = this.helper.post("/%s/accounts/test-users", this.helper.buildList("installed", Boolean.toString(appInstalled), "permissions", permissions, "owner_access_token", this.helper.accessToken()), this.helper.buildList("access_token", accessToken), applicationId);
        log.debug("Copied account: " + result);
    }

    public void makeFriends(FacebookTestUserAccount friend) {
        String requestResult = this.helper.post("/%s/friends/%s", null, this.helper.buildList("access_token", this.accessToken()), this.id(), friend.id());
        log.debug("Creating friend request: " + requestResult);
        String acceptResult = this.helper.post("/%s/friends/%s", null, this.helper.buildList("access_token", friend.accessToken()), friend.id(), this.id());
        log.debug("Accepting friend request: " + acceptResult);
    }

    public String getFriends() {
        return this.get("/%s/friends", this.id());
    }

    public String getProfileFeed() {
        return this.get("/%s/feed", this.id());
    }

    public String getNewsFeed() {
        return this.get("/%s/home", this.id());
    }

    public String getLikes() {
        return this.get("/%s/likes", this.id());
    }

    public String getMovies() {
        return this.get("/%s/movies", this.id());
    }

    public String getMusic() {
        return this.get("/%s/music", this.id());
    }

    public String getBooks() {
        return this.get("/%s/books", this.id());
    }

    public String getNotes() {
        return this.get("/%s/notes", this.id());
    }

    public String getPhotoTags() {
        return this.get("/%s/photos", this.id());
    }

    public String getPhotoAlbums() {
        return this.get("/%s/albums", this.id());
    }

    public String getVideoTags() {
        return this.get("/%s/videos", this.id());
    }

    public String getVideoUploads() {
        return this.get("/%s/videos/uploaded", this.id());
    }

    public String getEvents() {
        return this.get("/%s/events", this.id());
    }

    public String getGroups() {
        return this.get("/%s/groups", this.id());
    }

    public String getCheckins() {
        return this.get("/%s/checkins", this.id());
    }

    public String getUserDetails() {
        return this.get("%s", this.id());
    }

    public String id() {
        return this.jsonUser.get((Object)"id").toString();
    }

    public String accessToken() {
        return this.jsonUser.get((Object)"access_token").toString();
    }

    public String loginUrl() {
        return this.jsonUser.get((Object)"login_url").toString();
    }

    public String json() {
        return this.jsonUser.toJSONString();
    }

    private String get(String resource, Object ... pathParams) {
        return this.helper.get(resource, this.helper.buildList("access_token", this.accessToken()), pathParams);
    }
}

