/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.facebooktestjavaapi.testuser.impl;

import com.jayway.facebooktestjavaapi.testuser.FacebookTestUserAccount;
import com.jayway.facebooktestjavaapi.testuser.FacebookTestUserStore;
import com.jayway.facebooktestjavaapi.testuser.impl.HttpClientFacebookTestUserAccount;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientFacebookTestUserStore
implements FacebookTestUserStore {
    private static final Logger log = LoggerFactory.getLogger(HttpClientFacebookTestUserStore.class);
    private static final String FACEBOOK_HOST = "graph.facebook.com";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String ENCODING = "UTF-8";
    private String appAccessToken;
    private JSONParser jsonParser;
    private final String applicationId;
    private final String applicationSecret;
    private final HttpClient client = new DefaultHttpClient();

    public HttpClientFacebookTestUserStore(String applicationId, String applicationSecret) {
        this.applicationId = applicationId;
        this.applicationSecret = applicationSecret;
        this.jsonParser = new JSONParser();
    }

    private void init() {
        if (this.appAccessToken == null) {
            this.appAccessToken = this.getAccessToken(this.applicationId, this.applicationSecret);
        }
    }

    private String getAccessToken(String applicationId, String applicationSecret) {
        String prefix;
        String result = this.get("/oauth/access_token", this.buildList("grant_type", "client_credentials", "client_id", applicationId, "client_secret", applicationSecret), new Object[0]);
        if (!result.startsWith(prefix = "access_token=")) {
            throw new IllegalArgumentException("Could not get access token for provided authentication");
        }
        return result.substring(prefix.length());
    }

    @Override
    public FacebookTestUserAccount createTestUser(boolean appInstalled, String permissions) {
        this.init();
        if (permissions == null) {
            permissions = "email,offline_access";
        }
        String jsonResponse = this.post("/%s/accounts/test-users", this.buildList("installed", Boolean.toString(appInstalled), "permissions", permissions), null, this.applicationId);
        log.debug(jsonResponse);
        JSONObject user = this.parseJsonObject(jsonResponse);
        FacebookTestUserAccount facebookAccount = this.buildFacebookAccount(user);
        log.debug(String.format("* Created account on Facebook with id [%s], access_token [%s], login_url: [%s] ", facebookAccount.id(), facebookAccount.accessToken(), facebookAccount.loginUrl()));
        return facebookAccount;
    }

    @Override
    public List<FacebookTestUserAccount> getAllTestUsers() {
        this.init();
        String jsonResponse = this.get("/%s/accounts/test-users", this.applicationId);
        JSONObject accounts = this.parseJsonObject(jsonResponse);
        LinkedList<FacebookTestUserAccount> result = new LinkedList<FacebookTestUserAccount>();
        JSONArray data = (JSONArray)accounts.get((Object)"data");
        for (int i = 0; i < data.size(); ++i) {
            JSONObject jsonUser = (JSONObject)data.get(i);
            result.add(this.buildFacebookAccount(jsonUser));
        }
        log.debug("* Found [{}] accounts on Facebook ", (Object)result.size());
        return result;
    }

    @Override
    public void deleteAllTestUsers() {
        List<FacebookTestUserAccount> accounts = this.getAllTestUsers();
        for (FacebookTestUserAccount account : accounts) {
            account.delete();
        }
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public String getAccessToken() {
        return this.appAccessToken;
    }

    public boolean isInitialized() {
        return this.appAccessToken != null;
    }

    protected String get(String resource) throws URISyntaxException {
        return this.get(resource, new ArrayList<NameValuePair>(), new Object[0]);
    }

    protected String get(String resource, Object ... pathParams) {
        return this.get(resource, null, pathParams);
    }

    protected String get(String resource, List<NameValuePair> queryParams, Object ... pathParams) {
        if (queryParams == null) {
            queryParams = new ArrayList<NameValuePair>();
        }
        if (this.appAccessToken != null && !this.containsName(queryParams, ACCESS_TOKEN)) {
            queryParams.add((NameValuePair)new BasicNameValuePair(ACCESS_TOKEN, this.appAccessToken));
        }
        HttpGet httpMethod = null;
        try {
            httpMethod = this.buildGetResource(resource, queryParams, pathParams);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return this.getRequestResponse((HttpRequestBase)httpMethod);
    }

    protected String post(String resource, List<NameValuePair> queryParams, List<NameValuePair> formParams, Object ... pathParams) {
        if (queryParams == null) {
            queryParams = new ArrayList<NameValuePair>();
        }
        if (formParams == null) {
            formParams = new ArrayList<NameValuePair>();
        }
        if (this.appAccessToken != null && !this.containsName(formParams, ACCESS_TOKEN)) {
            formParams.add((NameValuePair)new BasicNameValuePair(ACCESS_TOKEN, this.appAccessToken));
        }
        HttpPost httpMethod = null;
        try {
            httpMethod = this.buildPostResource(resource, queryParams, formParams, pathParams);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.getRequestResponse((HttpRequestBase)httpMethod);
    }

    protected String delete(String resource, Object ... pathParams) {
        return this.delete(resource, null, pathParams);
    }

    protected String delete(String resource, List<NameValuePair> queryParams, Object ... pathParams) {
        if (queryParams == null) {
            queryParams = new ArrayList<NameValuePair>();
        }
        if (this.appAccessToken != null && !this.containsName(queryParams, ACCESS_TOKEN)) {
            queryParams.add((NameValuePair)new BasicNameValuePair(ACCESS_TOKEN, this.appAccessToken));
        }
        HttpDelete httpMethod = null;
        try {
            httpMethod = this.buildDeleteResource(resource, queryParams, pathParams);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return this.getRequestResponse((HttpRequestBase)httpMethod);
    }

    private boolean containsName(List<NameValuePair> queryParams, String name) {
        for (NameValuePair queryParam : queryParams) {
            if (!queryParam.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private String getRequestResponse(HttpRequestBase webResource) {
        try {
            HttpResponse response = this.client.execute((HttpUriRequest)webResource);
            HttpEntity entity = response.getEntity();
            return EntityUtils.toString((HttpEntity)entity);
        }
        catch (Exception e) {
            this.logError(e);
            throw new RuntimeException(e);
        }
    }

    private void logError(Exception e) {
        log.error("Error from Facebook: " + e.getMessage());
    }

    private FacebookTestUserAccount buildFacebookAccount(JSONObject user) {
        return new HttpClientFacebookTestUserAccount(this, user);
    }

    private JSONObject parseJsonObject(String json) {
        try {
            return (JSONObject)this.jsonParser.parse(json);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse JSON: " + json);
        }
    }

    private HttpGet buildGetResource(String resource, List<NameValuePair> queryParams, Object ... pathParams) throws URISyntaxException {
        URI uri = this.getUri(resource, queryParams, pathParams);
        return new HttpGet(uri);
    }

    private HttpPost buildPostResource(String resource, List<NameValuePair> queryParams, List<NameValuePair> formParams, Object ... pathParams) throws UnsupportedEncodingException, URISyntaxException {
        URI uri = this.getUri(resource, queryParams, pathParams);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formParams, ENCODING);
        HttpPost post = new HttpPost(uri);
        post.setEntity((HttpEntity)entity);
        return post;
    }

    private HttpDelete buildDeleteResource(String resource, List<NameValuePair> queryParams, Object ... pathParams) throws URISyntaxException {
        URI uri = this.getUri(resource, queryParams, pathParams);
        HttpDelete delete = new HttpDelete(uri);
        delete.setHeader("Content-length", "0");
        return delete;
    }

    private URI getUri(String resource, List<NameValuePair> queryParams, Object[] pathParams) throws URISyntaxException {
        return URIUtils.createURI((String)"https", (String)FACEBOOK_HOST, (int)-1, (String)String.format(resource, pathParams), (String)URLEncodedUtils.format(queryParams, (String)ENCODING), null);
    }

    protected List<NameValuePair> buildList(String ... queryParams) {
        LinkedList<NameValuePair> result = new LinkedList<NameValuePair>();
        this.putInList(result, queryParams);
        return result;
    }

    private void putInList(List<NameValuePair> result, String[] queryParams) {
        if (queryParams.length % 2 == 1) {
            throw new IllegalArgumentException("There must be an even number of query parameters (key, value)");
        }
        for (int i = 0; i < queryParams.length; i += 2) {
            result.add((NameValuePair)new BasicNameValuePair(queryParams[i], queryParams[i + 1]));
        }
    }

    public String accessToken() {
        return this.appAccessToken;
    }
}

