package com.jdcloud.function;

/**
 * The context object allows you to access useful information available within the alibaba cloud
 * function compute execution environment
 */
public interface Context {

    /**
     * Gets the alibaba cloud function compute request ID associated with the request. <p> This is
     * the same ID returned to the client that called invoke(). This ID is reused for retries on the
     * same request. </p>
     */
    public String getRequestId();



    /**
     * Gets the function related parameters
     */
    public FunctionParam getFunctionParam();

}


