/*
 * Decompiled with CFR 0.152.
 */
package com.kf5.support.model.builder;

import com.kf5.support.model.ItemType;
import com.kf5.support.model.Ticket;
import com.kf5.support.model.builder.EntityBuilder;
import org.kf5.support.fastjson.JSONArray;
import org.kf5.support.fastjson.JSONException;
import org.kf5.support.fastjson.JSONObject;

public class KF5EntityBuilder {
    public static Object buildEntityByType(ItemType type, JSONObject object) throws JSONException {
        Ticket obj = null;
        switch (type) {
            case TICKET: {
                obj = EntityBuilder.buildTicket(object);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type '" + (Object)((Object)type) + "' is not supported yet");
            }
        }
        return obj;
    }

    public static String safeGet(JSONObject object, String field) throws JSONException {
        if (object.containsKey(field)) {
            return object.getString(field);
        }
        return null;
    }

    public static JSONObject safeObject(JSONObject object, String field) throws JSONException {
        if (object.containsKey(field)) {
            try {
                return object.getJSONObject(field);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static JSONObject getJsonObject(JSONObject object, String fledsString) throws JSONException {
        if (object.containsKey(fledsString)) {
            return object.getJSONObject(fledsString);
        }
        return null;
    }

    public static JSONObject safeObject(String result) {
        try {
            return JSONObject.parseObject(result);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    public static JSONArray safeArray(JSONObject object, String field) throws JSONException {
        if (object.containsKey(field)) {
            return object.getJSONArray(field);
        }
        return null;
    }

    protected static Float safeFloat(JSONObject object, String field) throws JSONException {
        JSONObject jsonObject = JSONObject.parseObject(object.toJSONString());
        if (jsonObject.containsKey(field)) {
            try {
                return Float.valueOf(Float.parseFloat(jsonObject.getString(field)));
            }
            catch (NumberFormatException e) {
                return Float.valueOf(0.0f);
            }
        }
        return Float.valueOf(0.0f);
    }

    public static Integer safeInt(JSONObject object, String field) throws JSONException {
        if (object != null && object.containsKey(field)) {
            try {
                return Integer.parseInt(object.getString(field));
            }
            catch (NumberFormatException e) {
                return -100;
            }
        }
        return -100;
    }

    protected static Long safeLong(JSONObject object, String field) throws JSONException {
        if (object.containsKey(field)) {
            try {
                return Long.parseLong(object.getString(field));
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
        return 0L;
    }

    public static Boolean safeBoolean(JSONObject object, String field) throws JSONException {
        if (object.containsKey(field)) {
            return Boolean.parseBoolean(object.getString(field));
        }
        return Boolean.FALSE;
    }
}

