/*
 * Decompiled with CFR 0.152.
 */
package com.kf5.support.util;

import com.kf5.support.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class AuthorizationUtil {
    public static Random RAND = new Random();
    private static final Base64 BASE64 = new Base64();
    private static final String HMAC_SHA1 = "HmacSHA1";
    private static final String DEFAULT_SIGNATURE_METHOD = "HMAC-SHA1";
    private static String characterEncoding = "UTF-8";

    public static String generateAuthorizationHeader(String consumerKey, String consumerSecret, String signatureMethod, long timestamp, String nonce, float version, String oauthToken, String oauthTokenSecret, String verifier, String url, Map<String, Object> parameters, String requestType) throws URISyntaxException, IOException, GeneralSecurityException {
        if (consumerKey == null) {
            throw new IllegalArgumentException("consumerKey is null or empty!");
        }
        if (consumerSecret == null) {
            throw new IllegalArgumentException("consumerSecret is null or empty!");
        }
        if (null == nonce) {
            throw new IllegalArgumentException("nonce is null!");
        }
        if (url == null) {
            throw new IllegalArgumentException("url is null or empty!");
        }
        if (requestType == null) {
            throw new IllegalArgumentException("requestType is null or empty!");
        }
        if (signatureMethod == null) {
            signatureMethod = DEFAULT_SIGNATURE_METHOD;
        }
        LinkedHashMap<String, String> oauthHeaderParams = new LinkedHashMap<String, String>();
        oauthHeaderParams.put("oauth_consumer_key", consumerKey);
        oauthHeaderParams.put("oauth_nonce", nonce);
        oauthHeaderParams.put("oauth_signature_method", signatureMethod);
        oauthHeaderParams.put("oauth_timestamp", String.valueOf(timestamp));
        oauthHeaderParams.put("oauth_version", String.valueOf(version));
        if (oauthToken != null) {
            if (oauthTokenSecret == null) {
                throw new IllegalArgumentException("oauthTokenSecret is null or empty!");
            }
            oauthHeaderParams.put("oauth_token", oauthToken);
        }
        if (verifier != null) {
            oauthHeaderParams.put("oauth_verifier", verifier);
        }
        HashMap<String, Object> signatureBaseParams = new HashMap<String, Object>(oauthHeaderParams);
        if (null != parameters && !parameters.isEmpty()) {
            signatureBaseParams.putAll(parameters);
        }
        AuthorizationUtil.parseGetParameters(url, signatureBaseParams);
        String oauthBaseString = AuthorizationUtil.getBaseString(requestType, url, signatureBaseParams);
        String signature = AuthorizationUtil.base64Encode(AuthorizationUtil.computeSignature(consumerSecret, oauthTokenSecret, oauthBaseString));
        oauthHeaderParams.put("oauth_signature", signature);
        String authorization = "OAuth " + AuthorizationUtil.encodeParameters(oauthHeaderParams, ",", true);
        return authorization;
    }

    private static void parseGetParameters(String url, Map<String, Object> signatureBaseParams) {
        int queryStart = url.indexOf("?");
        if (-1 != queryStart) {
            String[] queryStrs = url.substring(queryStart + 1).split("&");
            try {
                for (String query : queryStrs) {
                    String[] split = query.split("=");
                    if (split.length == 2) {
                        signatureBaseParams.put(URLDecoder.decode(split[0], "UTF-8"), URLDecoder.decode(split[1], "UTF-8"));
                        continue;
                    }
                    signatureBaseParams.put(URLDecoder.decode(split[0], "UTF-8"), "");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    private static String getBaseString(String requestType, String url, Map<String, Object> parameters) throws URISyntaxException, IOException {
        return AuthorizationUtil.percentEncode(requestType.toUpperCase()) + '&' + AuthorizationUtil.percentEncode(AuthorizationUtil.normalizeUrl(url)) + '&' + AuthorizationUtil.percentEncode(AuthorizationUtil.normalizeParameters(parameters));
    }

    private static String normalizeUrl(String url) throws URISyntaxException {
        String path;
        int index;
        boolean dropPort;
        URI uri = new URI(url);
        String scheme = uri.getScheme().toLowerCase();
        String authority = uri.getAuthority().toLowerCase();
        boolean bl = dropPort = scheme.equals("http") && uri.getPort() == 80 || scheme.equals("https") && uri.getPort() == 443;
        if (dropPort && (index = authority.lastIndexOf(":")) >= 0) {
            authority = authority.substring(0, index);
        }
        if ((path = uri.getRawPath()) == null || path.length() <= 0) {
            path = "/";
        }
        return scheme + "://" + authority + path;
    }

    private static List<Map.Entry<String, Object>> getParameters(Collection<ComparableParameter> parameters) {
        if (parameters == null) {
            return null;
        }
        ArrayList<Map.Entry<String, Object>> list = new ArrayList<Map.Entry<String, Object>>(parameters.size());
        for (ComparableParameter parameter : parameters) {
            list.add(parameter.value);
        }
        return list;
    }

    private static String normalizeParameters(Map<String, Object> parameters) throws IOException {
        if (null == parameters || parameters.isEmpty()) {
            return "";
        }
        ArrayList<ComparableParameter> p = new ArrayList<ComparableParameter>(parameters.size());
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            if ("oauth_signature".equals(parameter.getKey())) continue;
            p.add(new ComparableParameter(parameter));
        }
        Collections.sort(p);
        return AuthorizationUtil.formEncode(AuthorizationUtil.getParameters(p));
    }

    public static String percentEncode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException wow) {
            throw new RuntimeException(wow.getMessage(), wow);
        }
    }

    public static String decodeCharacters(byte[] from) {
        if (characterEncoding != null) {
            try {
                return new String(from, characterEncoding);
            }
            catch (UnsupportedEncodingException e) {
                System.err.println(e + "");
            }
        }
        return new String(from);
    }

    public static String formEncode(Iterable<? extends Map.Entry<String, Object>> parameters) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        AuthorizationUtil.formEncode(parameters, b);
        return AuthorizationUtil.decodeCharacters(b.toByteArray());
    }

    public static void formEncode(Iterable<? extends Map.Entry<String, Object>> parameters, OutputStream into) throws IOException {
        if (parameters != null) {
            boolean first = true;
            for (Map.Entry<String, Object> entry : parameters) {
                if (first) {
                    first = false;
                } else {
                    into.write(38);
                }
                into.write(AuthorizationUtil.encodeCharacters(AuthorizationUtil.percentEncode(AuthorizationUtil.toString(entry.getKey()))));
                into.write(61);
                into.write(AuthorizationUtil.encodeCharacters(AuthorizationUtil.percentEncode(AuthorizationUtil.toString(entry.getValue()))));
            }
        }
    }

    public static byte[] encodeCharacters(String from) {
        if (characterEncoding != null) {
            try {
                return from.getBytes(characterEncoding);
            }
            catch (UnsupportedEncodingException e) {
                System.err.println(e + "");
            }
        }
        return from.getBytes();
    }

    private static final String toString(Object from) {
        return from == null ? null : from.toString();
    }

    private static byte[] computeSignature(String consumerSecret, String tokenSecret, String baseString) throws GeneralSecurityException, UnsupportedEncodingException {
        String keyString = AuthorizationUtil.percentEncode(consumerSecret) + '&' + AuthorizationUtil.percentEncode(tokenSecret);
        byte[] keyBytes = keyString.getBytes("UTF-8");
        SecretKeySpec key = new SecretKeySpec(keyBytes, HMAC_SHA1);
        Mac mac = Mac.getInstance(HMAC_SHA1);
        mac.init(key);
        byte[] text = baseString.getBytes("UTF-8");
        return mac.doFinal(text);
    }

    private static String base64Encode(byte[] b) {
        byte[] b2 = BASE64.encode(b);
        try {
            return new String(b2, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e + "");
            return new String(b2);
        }
    }

    private static String encodeParameters(Map<String, String> signatureBaseParams, String splitter, boolean quot) {
        StringBuffer buf = new StringBuffer();
        for (String key : signatureBaseParams.keySet()) {
            if (buf.length() != 0) {
                if (quot) {
                    buf.append("\"");
                }
                buf.append(splitter);
            }
            buf.append(AuthorizationUtil.percentEncode(key)).append("=");
            if (quot) {
                buf.append("\"");
            }
            buf.append(AuthorizationUtil.percentEncode(signatureBaseParams.get(key)));
        }
        if (buf.length() != 0 && quot) {
            buf.append("\"");
        }
        return buf.toString();
    }

    private static class ComparableParameter
    implements Comparable<ComparableParameter> {
        final Map.Entry<String, Object> value;
        private final String key;

        ComparableParameter(Map.Entry<String, Object> value) {
            this.value = value;
            String n = ComparableParameter.toString(value.getKey());
            String v = ComparableParameter.toString(value.getValue());
            this.key = AuthorizationUtil.percentEncode(n) + ' ' + AuthorizationUtil.percentEncode(v);
        }

        private static String toString(Object from) {
            return from == null ? null : from.toString();
        }

        @Override
        public int compareTo(ComparableParameter that) {
            return this.key.compareTo(that.key);
        }

        public String toString() {
            return this.key;
        }
    }
}

