/*
 * Decompiled with CFR 0.152.
 */
package org.kf5.support.fastjson.serializer;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.kf5.support.fastjson.JSONArray;
import org.kf5.support.fastjson.parser.DefaultJSONParser;
import org.kf5.support.fastjson.parser.deserializer.ObjectDeserializer;
import org.kf5.support.fastjson.serializer.JSONSerializer;
import org.kf5.support.fastjson.serializer.ObjectSerializer;
import org.kf5.support.fastjson.serializer.SerializeWriter;
import org.kf5.support.fastjson.serializer.SerializerFeature;

public class AtomicIntegerArrayCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final AtomicIntegerArrayCodec instance = new AtomicIntegerArrayCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            if (out.isEnabled(SerializerFeature.WriteNullListAsEmpty)) {
                out.write("[]");
            } else {
                out.writeNull();
            }
            return;
        }
        AtomicIntegerArray array = (AtomicIntegerArray)object;
        int len = array.length();
        out.append('[');
        for (int i = 0; i < len; ++i) {
            int val = array.get(i);
            if (i != 0) {
                out.write(',');
            }
            out.writeInt(val);
        }
        out.append(']');
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        if (parser.getLexer().token() == 8) {
            parser.getLexer().nextToken(16);
            return null;
        }
        JSONArray array = new JSONArray();
        parser.parseArray(array);
        AtomicIntegerArray atomicArray = new AtomicIntegerArray(array.size());
        for (int i = 0; i < array.size(); ++i) {
            atomicArray.set(i, array.getInteger(i));
        }
        return (T)atomicArray;
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }
}

