/*
 * Decompiled with CFR 0.152.
 */
package org.kf5.support.fastjson.serializer;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.UUID;
import org.kf5.support.fastjson.parser.DefaultJSONParser;
import org.kf5.support.fastjson.parser.deserializer.ObjectDeserializer;
import org.kf5.support.fastjson.serializer.JSONSerializer;
import org.kf5.support.fastjson.serializer.ObjectSerializer;

public class UUIDCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final UUIDCodec instance = new UUIDCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        if (object == null) {
            serializer.writeNull();
            return;
        }
        UUID uid = (UUID)object;
        serializer.write(uid.toString());
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        String name = (String)parser.parse();
        if (name == null) {
            return null;
        }
        return (T)UUID.fromString(name);
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

