/*
 * Decompiled with CFR 0.152.
 */
package com.kf5.support.controller;

import com.kf5.support.controller.BaseCustomIMSupport;
import com.kf5.support.internet.KF5Interface;
import com.kf5.support.model.IMAgentInfo;
import com.kf5.support.model.KF5Entity;
import com.kf5.support.model.MessageStatus;
import com.kf5.support.model.builder.KF5EntityBuilder;
import java.io.File;
import org.kf5.support.fastjson.JSONObject;

public class KF5CustomIMSupport
extends BaseCustomIMSupport {
    private static final String URL = KF5Interface.getIMAgentList();
    private static final String ATTACHMENT = KF5Interface.uploadCustomIMAttachment();

    public KF5CustomIMSupport(String domian, String appid, String appkey, String method) {
        super(domian, appid, appkey, method);
    }

    public KF5Entity<IMAgentInfo> getIMAgentInfo() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("action", (Object)"get_agent_states");
        return this.buildIMAgentInfo(this.sendPostRequest(URL, jsonObject.toJSONString()));
    }

    public boolean createIMChat(String jsonString) {
        return this.post(jsonString);
    }

    public boolean sendTextMessage(String jsonString) {
        return this.post(jsonString);
    }

    public String uploadAttachment(File file) {
        return this.uploadAttachment(ATTACHMENT, file);
    }

    public boolean sendImageMessage(String jsonString) {
        return this.post(jsonString);
    }

    public boolean updateUserInfo(String jsonString) {
        return this.post(jsonString);
    }

    public boolean closeChat(String jsonString) {
        return this.post(jsonString);
    }

    private boolean post(String jsonString) {
        MessageStatus messageStatus = this.sendPostRequest(URL, jsonString);
        if (this.getResultCode(messageStatus) == 0) {
            return KF5EntityBuilder.safeBoolean(this.getResultObj(messageStatus), "success");
        }
        return false;
    }
}

