/*
 * Decompiled with CFR 0.152.
 */
package com.kf5.support.controller;

import com.kf5.support.controller.BaseSupport;
import com.kf5.support.internet.HttpRequest;
import com.kf5.support.internet.KF5Interface;
import com.kf5.support.model.AICategory;
import com.kf5.support.model.AIQuestionCategory;
import com.kf5.support.model.AITag;
import com.kf5.support.model.AgentConversationStatistics;
import com.kf5.support.model.AgentLog;
import com.kf5.support.model.AgentStatistics;
import com.kf5.support.model.AgentStatusTimeStatistics;
import com.kf5.support.model.AgentVoiceCallInbound;
import com.kf5.support.model.AgentVoiceCallOutbound;
import com.kf5.support.model.AgentVoiceCallSubsectionInbound;
import com.kf5.support.model.AgentVoiceCallSubsectionOutbound;
import com.kf5.support.model.AgentVoicePerformance;
import com.kf5.support.model.AgentVoiceStateTime;
import com.kf5.support.model.AgentVoiceStatus;
import com.kf5.support.model.AgentWorkStatusStatistics;
import com.kf5.support.model.Attachment;
import com.kf5.support.model.Automation;
import com.kf5.support.model.Category;
import com.kf5.support.model.Chat;
import com.kf5.support.model.ChatInfo;
import com.kf5.support.model.ChatSourceStatistics;
import com.kf5.support.model.Comment;
import com.kf5.support.model.Forum;
import com.kf5.support.model.Group;
import com.kf5.support.model.KF5Entity;
import com.kf5.support.model.KF5ExportTicketEntity;
import com.kf5.support.model.KF5PaginationEntity;
import com.kf5.support.model.MessageStatus;
import com.kf5.support.model.MonitorAgent;
import com.kf5.support.model.Organization;
import com.kf5.support.model.Post;
import com.kf5.support.model.PostComment;
import com.kf5.support.model.Question;
import com.kf5.support.model.QuestionComment;
import com.kf5.support.model.QueueVisitorInfo;
import com.kf5.support.model.Requester;
import com.kf5.support.model.SystemLog;
import com.kf5.support.model.Ticket;
import com.kf5.support.model.TicketField;
import com.kf5.support.model.Topic;
import com.kf5.support.model.Trigger;
import com.kf5.support.model.User;
import com.kf5.support.model.UserField;
import com.kf5.support.model.View;
import com.kf5.support.model.ViewCount;
import com.kf5.support.model.VoiceAccount;
import com.kf5.support.model.VoiceAgentLoginState;
import com.kf5.support.model.VoiceCall;
import com.kf5.support.model.VoiceCallUnAnswered;
import com.kf5.support.model.VoiceQueueCall;
import com.kf5.support.model.builder.EntityBuilder;
import com.kf5.support.model.builder.KF5EntityBuilder;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.kf5.support.fastjson.JSONArray;
import org.kf5.support.fastjson.JSONException;
import org.kf5.support.fastjson.JSONObject;

public class KF5Support
extends BaseSupport {
    public KF5Entity<List<Ticket>> getAgentOrderList() {
        return this.getAgentOrderListWithQuery("");
    }

    public KF5Entity<List<Ticket>> getAgentOrderListWithQuery(String query) {
        return this.getAgentOrderListWithURl(KF5Interface.getOrderList(this.getDomain(), query));
    }

    public KF5Entity<List<Ticket>> getAgentOrderListWithURl(String url) {
        return this.buildTicketList(this.sendGetRequest(url));
    }

    public KF5Entity<List<Ticket>> getAgentOrderListWithID(String assignee_id) {
        return this.getAgentOrderListWithID(assignee_id, "");
    }

    public KF5Entity<List<Ticket>> getAgentOrderListWithID(String assignee_id, String query) {
        this.checkHasId(assignee_id);
        return this.getAgentOrderListByURL(KF5Interface.getOrderListWithID(this.getDomain(), assignee_id, query));
    }

    public KF5Entity<List<Ticket>> getAgentOrderListByURL(String url) {
        return this.buildTicketList(this.sendGetRequest(url));
    }

    public KF5Entity<Ticket> getAgentTicketDetail(String order_id) {
        this.checkHasId(order_id);
        return this.buildTicket(this.sendGetRequest(KF5Interface.getOrderDetailByAgent(this.getDomain(), order_id)));
    }

    public KF5Entity<List<Ticket>> getAgentManyTickets(String ids) {
        this.checkHasId(ids);
        return this.buildTicketList(this.sendGetRequest(KF5Interface.getAgentManyOrder(this.getDomain(), ids)));
    }

    public KF5Entity<Ticket> createAgentOrder(String jsonString) {
        KF5Entity<Ticket> kf5Entity = new KF5Entity<Ticket>();
        try {
            MessageStatus messageStatus = this.sendPostRequest(KF5Interface.createOrder(this.getDomain()), JSONObject.parse(jsonString).toString());
            this.buildTicket(messageStatus, kf5Entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5Entity<Ticket> updateAgentOrder(String order_id, String jsonString) {
        this.checkHasId(order_id);
        KF5Entity<Ticket> kf5Entity = new KF5Entity<Ticket>();
        try {
            MessageStatus messageStatus = this.sendPutRequest(KF5Interface.updateOrder(this.getDomain(), order_id), JSONObject.parse(jsonString).toString());
            this.buildTicket(messageStatus, kf5Entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5Entity<String> updateManyAgentOrder(String ids, String jsonString) {
        this.checkHasId(ids);
        KF5Entity<String> kf5Entity = new KF5Entity<String>();
        try {
            MessageStatus messageStatus = this.sendPutRequest(KF5Interface.updateManyOrders(this.getDomain()) + ids, JSONObject.parse(jsonString).toString());
            this.buildResultWithString(messageStatus, kf5Entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5Entity<String> deleteAgentOrder(String id) {
        this.checkHasId(id);
        return this.buildResultWithString(this.sendDeleteRequest(KF5Interface.deleteOrder(this.getDomain(), id)));
    }

    public KF5Entity<String> deleteManyAgentOrders(String ids) {
        this.checkHasId(ids);
        return this.buildResultWithString(this.sendDeleteRequest(KF5Interface.deleteManyOrders(this.getDomain()) + ids));
    }

    public KF5Entity<List<User>> getAgentOrderCollaborators(String order_id) {
        this.checkHasId(order_id);
        return this.buildUserList(this.sendGetRequest(KF5Interface.getAgentOrderCollaborators(this.getDomain(), order_id)));
    }

    public KF5Entity<List<Ticket>> getAgentOrderIncidentList(String order_id) {
        this.checkHasId(order_id);
        return this.buildTicketList(this.sendGetRequest(KF5Interface.getAgentOrderIncidentList(this.getDomain(), order_id)));
    }

    public KF5Entity<List<Ticket>> getAgentOrderProblemList() {
        return this.buildTicketList(this.sendGetRequest(KF5Interface.getProblemOrderList(this.getDomain())));
    }

    public KF5PaginationEntity<List<Requester>> getRequesterOrderList() {
        return this.getRequesterOrderListWithQuery("");
    }

    public KF5PaginationEntity<List<Requester>> getRequesterOrderListWithQuery(String query) {
        return this.getRequesterOrderListWithURL(KF5Interface.getRequesterOrderList(this.getDomain(), query));
    }

    public KF5PaginationEntity<List<Requester>> getRequesterOrderListWithURL(String url) {
        return this.buildPaginationRequesterList(this.sendGetRequest(url));
    }

    public KF5PaginationEntity<List<Requester>> getRequesterOrderListStatusOpen() {
        return this.getRequesterOrderListStatusOpenWithQuery("");
    }

    public KF5PaginationEntity<List<Requester>> getRequesterOrderListStatusOpenWithQuery(String query) {
        return this.getRequesterOrderListStatusOpenWithURL(KF5Interface.getRequesterOrderListStatusOpen(this.getDomain(), query));
    }

    public KF5PaginationEntity<List<Requester>> getRequesterOrderListStatusOpenWithURL(String url) {
        return this.buildPaginationRequesterList(this.sendGetRequest(url));
    }

    public KF5PaginationEntity<List<Requester>> getRequesterOrderListStatusSolved() {
        return this.getRequesterOrderListStatusSolvedWithQuery("");
    }

    public KF5PaginationEntity<List<Requester>> getRequesterOrderListStatusSolvedWithQuery(String query) {
        return this.getRequesterOrderListStatusSolvedWithURL(KF5Interface.getRequesterOrderListStatusSolved(this.getDomain(), query));
    }

    public KF5PaginationEntity<List<Requester>> getRequesterOrderListStatusSolvedWithURL(String url) {
        return this.buildPaginationRequesterList(this.sendGetRequest(url));
    }

    public KF5PaginationEntity<List<Ticket>> getRequesterOrderListByID(String user_id) {
        return this.getRequesterOrderListByID(user_id, "");
    }

    public KF5PaginationEntity<List<Ticket>> getRequesterOrderListByID(String user_id, String query) {
        this.checkHasId(user_id);
        return this.getRequesterOrderListByURL(KF5Interface.getRequesterOrderListByID(this.getDomain(), user_id, query));
    }

    public KF5PaginationEntity<List<Ticket>> getRequesterOrderListByURL(String url) {
        return this.buildPaginationTicketList(this.sendGetRequest(url));
    }

    public KF5PaginationEntity<List<Requester>> getOrganizationOrderList(String organization_id) {
        return this.getOrganizationOrderList(organization_id, "");
    }

    public KF5PaginationEntity<List<Requester>> getOrganizationOrderList(String organization_id, String query) {
        this.checkHasId(organization_id);
        return this.getOrganizationOrderListByURL(KF5Interface.getOrganizationOrderList(this.getDomain(), organization_id, query));
    }

    public KF5PaginationEntity<List<Requester>> getOrganizationOrderListByURL(String url) {
        return this.buildPaginationRequesterList(this.sendGetRequest(url));
    }

    public KF5PaginationEntity<List<Requester>> searchOrderByEndUser(String keys) {
        return this.searchOrderByEndUser(keys, 0, 0);
    }

    public KF5PaginationEntity<List<Requester>> searchOrderByEndUser(String keys, int page, int per_page) {
        this.checkNotNull(keys);
        return this.searchOrderByEndUserWithURL(KF5Interface.searchOrder(this.getDomain(), keys, page, per_page));
    }

    public KF5PaginationEntity<List<Requester>> searchOrderByEndUserWithURL(String url) {
        return this.buildPaginationRequesterList(this.sendGetRequest(url));
    }

    public KF5Entity<Requester> getOrderDetailByEndUser(String order_id) {
        this.checkHasId(order_id);
        return this.buildRequester(this.sendGetRequest(KF5Interface.getOrderDetailByRequester(this.getDomain(), order_id)));
    }

    public KF5Entity<Requester> createOrderByEndUser(String jsonString) {
        KF5Entity<Requester> kf5Entity = new KF5Entity<Requester>();
        try {
            MessageStatus messageStatus = this.sendPostRequest(KF5Interface.createOrderByRequester(this.getDomain()), JSONObject.parse(jsonString).toString());
            this.buildRequester(kf5Entity, messageStatus);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5Entity<Requester> replyOrderByEndUser(String order_id, String jsonString) {
        this.checkHasId(order_id);
        KF5Entity<Requester> kf5Entity = new KF5Entity<Requester>();
        try {
            MessageStatus messageStatus = this.sendPutRequest(KF5Interface.replyOrderByEndUser(this.getDomain(), order_id), JSONObject.parse(jsonString).toString());
            this.buildRequester(kf5Entity, messageStatus);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5PaginationEntity<List<Comment>> getCommentListByEndUser(String order_id) {
        return this.getCommentListByEndUser(order_id, "");
    }

    public KF5PaginationEntity<List<Comment>> getCommentListByEndUser(String order_id, String query) {
        this.checkHasId(order_id);
        return this.getCommentListByEndUserWithURL(KF5Interface.getCommentListByEndUser(this.getDomain(), order_id, query));
    }

    public KF5PaginationEntity<List<Comment>> getCommentListByEndUserWithURL(String url) {
        return this.buildPaginationListComment(this.sendGetRequest(url));
    }

    public KF5Entity<Comment> getOrderCommentWithID(String order_id, String id) {
        this.checkHasId(order_id, id);
        return this.buildComment(this.sendGetRequest(KF5Interface.getOrderCommentWithID(this.getDomain(), order_id, id)));
    }

    public KF5PaginationEntity<List<Comment>> getOrderCommentList(String order_id) {
        return this.getOrderCommentList(order_id, "");
    }

    public KF5PaginationEntity<List<Comment>> getOrderCommentList(String order_id, String query) {
        this.checkHasId(order_id);
        return this.getOrderCommentListByURL(KF5Interface.getOrderCommentList(this.getDomain(), order_id, query));
    }

    public KF5PaginationEntity<List<Comment>> getOrderCommentListByURL(String url) {
        return this.buildPaginationListComment(this.sendGetRequest(url));
    }

    public KF5PaginationEntity<List<TicketField>> getTicketFieldList() {
        return this.getTicketFieldListWithQuery("");
    }

    public KF5PaginationEntity<List<TicketField>> getTicketFieldListWithQuery(String query) {
        return this.getTicketFieldListWithURL(KF5Interface.getTicketFieldList(this.getDomain(), query));
    }

    public KF5PaginationEntity<List<TicketField>> getTicketFieldListWithURL(String url) {
        return this.buildPaginationTicketFieldList(this.sendGetRequest(url));
    }

    public KF5PaginationEntity<List<TicketField>> getTicketFieldListActive() {
        return this.getTicketFieldListActiveWithQuery("");
    }

    public KF5PaginationEntity<List<TicketField>> getTicketFieldListActiveWithQuery(String query) {
        return this.getTicketFieldListActiveWithURL(KF5Interface.getTicketFieldListActive(this.getDomain(), query));
    }

    public KF5PaginationEntity<List<TicketField>> getTicketFieldListActiveWithURL(String url) {
        return this.buildPaginationTicketFieldList(this.sendGetRequest(url));
    }

    public KF5Entity<TicketField> getTicketFieldByID(String ticket_field_id) {
        this.checkHasId(ticket_field_id);
        return this.buildTicketField(this.sendGetRequest(KF5Interface.getTicketFieldByID(this.getDomain(), ticket_field_id)));
    }

    public KF5Entity<String> deleteTicketFieldByID(String ticket_field_id) {
        this.checkHasId(ticket_field_id);
        return this.buildResultWithString(this.sendDeleteRequest(KF5Interface.deleteTicketFieldByID(this.getDomain(), ticket_field_id)));
    }

    public KF5PaginationEntity<List<View>> getOrderTypeList() {
        return this.getOrderTypeListWithQuery("");
    }

    public KF5PaginationEntity<List<View>> getOrderTypeListWithQuery(String query) {
        return this.getOrderTypeListWithURL(KF5Interface.getOrderTypeList(this.getDomain(), query));
    }

    public KF5PaginationEntity<List<View>> getOrderTypeListWithURL(String url) {
        return this.buildPaginationOrderTypeList(this.sendGetRequest(url));
    }

    public KF5PaginationEntity<List<View>> getOrderTypeListActive() {
        return this.getOrderTypeListActiveWithQuery("");
    }

    public KF5PaginationEntity<List<View>> getOrderTypeListActiveWithQuery(String query) {
        return this.getOrderTypeListActiveWithURL(KF5Interface.getOrderTypeListActive(this.getDomain(), query));
    }

    public KF5PaginationEntity<List<View>> getOrderTypeListActiveWithURL(String url) {
        return this.buildPaginationOrderTypeList(this.sendGetRequest(url));
    }

    public KF5Entity<View> getOrderTypeByID(String type_id) {
        this.checkHasId(type_id);
        return this.buildOrderType(this.sendGetRequest(KF5Interface.getOrderTypeListByID(this.getDomain(), type_id)));
    }

    public KF5PaginationEntity<List<Ticket>> getTicketListByTypeID(String type_id) {
        return this.getTicketListByTypeID(type_id, "");
    }

    public KF5PaginationEntity<List<Ticket>> getTicketListByTypeID(String type_id, String query) {
        this.checkHasId(type_id);
        return this.getTicketListByTypeIDWithURL(KF5Interface.getTicketListByTypeID(this.getDomain(), type_id, query));
    }

    public KF5PaginationEntity<List<Ticket>> getTicketListByTypeIDWithURL(String url) {
        return this.buildPaginationTicketList(this.sendGetRequest(url));
    }

    public KF5Entity<ViewCount> getTicketCountByTypeID(String type_id) {
        this.checkHasId(type_id);
        return this.buildViewCount(this.sendGetRequest(KF5Interface.getTicketCountByTypeID(this.getDomain(), type_id)));
    }

    public KF5Entity<List<ViewCount>> getManyTicketCountByTypeIds(String ids) {
        this.checkHasId(ids);
        return this.buildListViewCount(this.sendGetRequest(KF5Interface.getManyTicketCountByTypeIds(this.getDomain()) + ids));
    }

    public KF5PaginationEntity<List<User>> getUserList() {
        return this.getUserListWithQuery("");
    }

    public KF5PaginationEntity<List<User>> getUserListWithQuery(String query) {
        return this.getUserListWithURL(KF5Interface.getUserList(this.getDomain(), query));
    }

    public KF5PaginationEntity<List<User>> getUserListWithURL(String url) {
        return this.buildPaginationUserList(this.sendGetRequest(url));
    }

    public KF5Entity<User> getUserInfo(String user_id) {
        this.checkHasId(user_id);
        return this.buildUser(this.sendGetRequest(KF5Interface.getUserInfo(this.getDomain(), user_id)));
    }

    public KF5Entity<User> getMyInfo() {
        return this.buildUser(this.sendGetRequest(KF5Interface.getMyInfo(this.getDomain())));
    }

    public KF5PaginationEntity<List<User>> getManyUsersInfo(String user_ids) {
        this.checkHasId(user_ids);
        return this.buildPaginationUserList(this.sendGetRequest(KF5Interface.getManyUsersInfo(this.getDomain()) + user_ids));
    }

    public KF5Entity<User> createUserInfo(String jsonString) {
        KF5Entity<User> kf5Entity = new KF5Entity<User>();
        try {
            MessageStatus messageStatus = this.sendPostRequest(KF5Interface.createUserInfo(this.getDomain()), JSONObject.parse(jsonString).toString());
            this.buildUser(kf5Entity, messageStatus);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5Entity<User> mergeUser(String user_id, String jsonString) {
        this.checkHasId(user_id);
        KF5Entity<User> kf5Entity = new KF5Entity<User>();
        try {
            MessageStatus messageStatus = this.sendPutRequest(KF5Interface.mergeUser(this.getDomain(), user_id), JSONObject.parse(jsonString).toString());
            this.buildUser(kf5Entity, messageStatus);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5Entity<User> updateUserInfo(String user_id, String jsonString) {
        this.checkHasId(user_id);
        KF5Entity<User> kf5Entity = new KF5Entity<User>();
        try {
            MessageStatus messageStatus = this.sendPutRequest(KF5Interface.updateUserInfo(this.getDomain(), user_id), JSONObject.parse(jsonString).toString());
            this.buildUser(kf5Entity, messageStatus);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5Entity<String> deleteUser(String user_id) {
        this.checkHasId(user_id);
        return this.buildResultWithString(this.sendDeleteRequest(KF5Interface.deleteUser(this.getDomain(), user_id)));
    }

    public KF5PaginationEntity<List<User>> searchUser(String key) {
        return this.searchUser(key, 0, 0);
    }

    public KF5PaginationEntity<List<User>> searchUser(String key, int page, int per_page) {
        this.checkNotNull(key);
        return this.searchUserByURL(KF5Interface.searchUser(this.getDomain(), key, page, per_page));
    }

    public KF5PaginationEntity<List<User>> searchUserByURL(String url) {
        return this.buildPaginationUserList(this.sendGetRequest(url));
    }

    public KF5PaginationEntity<List<UserField>> getUserFieldList() {
        return this.getUserFieldListWithQuery("");
    }

    public KF5PaginationEntity<List<UserField>> getUserFieldListWithQuery(String query) {
        return this.getUserFieldListWithURL(KF5Interface.getUserFieldList(this.getDomain(), query));
    }

    public KF5PaginationEntity<List<UserField>> getUserFieldListWithURL(String url) {
        return this.buildPaginationUserFieldList(this.sendGetRequest(url));
    }

    public KF5PaginationEntity<List<UserField>> getUserFieldActiveList() {
        return this.getUserFieldActiveListWithQuery("");
    }

    public KF5PaginationEntity<List<UserField>> getUserFieldActiveListWithQuery(String query) {
        return this.getUserFieldActiveListWithURL(KF5Interface.getUserFieldActiveList(this.getDomain(), query));
    }

    public KF5PaginationEntity<List<UserField>> getUserFieldActiveListWithURL(String url) {
        return this.getUserFieldListWithURL(url);
    }

    public KF5Entity<UserField> getUserFieldListByID(String user_field_id) {
        return this.getUserFieldByID(user_field_id);
    }

    public KF5Entity<UserField> getUserFieldByID(String user_field_id) {
        this.checkHasId(user_field_id);
        return this.buildUserField(this.sendGetRequest(KF5Interface.getUserFieldListByID(this.getDomain(), user_field_id)));
    }

    public KF5Entity<String> deleteUserField(String user_field_id) {
        this.checkHasId(user_field_id);
        return this.buildResultWithString(this.sendDeleteRequest(KF5Interface.deleteUserField(this.getDomain(), user_field_id)));
    }

    public KF5Entity<List<Group>> getGroupList() {
        return this.getGroupListWithQuery("");
    }

    public KF5Entity<List<Group>> getGroupListWithQuery(String query) {
        return this.getGroupListWithURL(KF5Interface.getGroupList(this.getDomain(), query));
    }

    public KF5Entity<List<Group>> getGroupListWithURL(String url) {
        return this.buildGroupList(this.sendGetRequest(url));
    }

    public KF5Entity<Group> getGroupListByID(String group_id) {
        return this.getGroupByID(group_id);
    }

    public KF5Entity<Group> getGroupByID(String group_id) {
        this.checkHasId(group_id);
        return this.buildGroup(this.sendGetRequest(KF5Interface.getGroupListByID(this.getDomain(), group_id)));
    }

    public KF5Entity<Group> createGroup(String jsonString) {
        KF5Entity<Group> kf5Entity = new KF5Entity<Group>();
        try {
            MessageStatus messageStatus = this.sendPostRequest(KF5Interface.createGroup(this.getDomain()), JSONObject.parse(jsonString).toString());
            this.buildGroup(messageStatus, kf5Entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5Entity<Group> updateGroup(String group_id, String jsonString) {
        this.checkHasId(group_id);
        return this.buildGroup(this.sendPutRequest(KF5Interface.updateGroup(this.getDomain(), group_id), JSONObject.parse(jsonString).toString()));
    }

    public KF5Entity<String> deleteGroup(String group_id) {
        this.checkHasId(group_id);
        return this.buildResultWithString(this.sendDeleteRequest(KF5Interface.deleteGroup(this.getDomain(), group_id)));
    }

    public KF5PaginationEntity<List<Organization>> getOrganizationList() {
        return this.getOrganizationListWithQuery("");
    }

    public KF5PaginationEntity<List<Organization>> getOrganizationListWithQuery(String query) {
        return this.getOrganizationListWithURL(KF5Interface.getOrganizationList(this.getDomain(), query));
    }

    public KF5PaginationEntity<List<Organization>> getOrganizationListWithURL(String url) {
        return this.buildPaginationOrganizationList(this.sendGetRequest(url));
    }

    public KF5Entity<Organization> getOrganizationByID(String organization_id) {
        this.checkHasId(organization_id);
        return this.buildOrganization(this.sendGetRequest(KF5Interface.getOrganizationByID(this.getDomain(), organization_id)));
    }

    public KF5Entity<Organization> createOrganization(String jsonString) {
        return this.buildOrganization(this.sendPostRequest(KF5Interface.createOrganization(this.getDomain()), JSONObject.parse(jsonString).toString()));
    }

    public KF5Entity<Organization> updateOrganization(String organization_id, String jsonString) {
        this.checkHasId(organization_id);
        KF5Entity<Organization> kf5Entity = new KF5Entity<Organization>();
        try {
            MessageStatus messageStatus = this.sendPutRequest(KF5Interface.updateOrganization(this.getDomain(), organization_id), JSONObject.parse(jsonString).toString());
            this.buildOrganization(messageStatus, kf5Entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5Entity<String> deleteOrganization(String organization_id) {
        this.checkHasId(organization_id);
        return this.buildResultWithString(this.sendDeleteRequest(KF5Interface.deleteOrganization(this.getDomain(), organization_id)));
    }

    public KF5PaginationEntity<List<Topic>> getTopicList() {
        return this.getTopicListWithQuery("");
    }

    public KF5PaginationEntity<List<Topic>> getTopicListWithQuery(String query) {
        return this.getTopicListWithURL(KF5Interface.getTopicList(this.getDomain(), query));
    }

    public KF5PaginationEntity<List<Topic>> getTopicListWithURL(String url) {
        return this.buildPaginationTopicList(this.sendGetRequest(url));
    }

    public KF5Entity<Topic> getTopicByID(String topic_id) {
        this.checkHasId(topic_id);
        return this.buildTopic(this.sendGetRequest(KF5Interface.getTopicByID(this.getDomain(), topic_id)));
    }

    public KF5Entity<Topic> createTopic(String jsonString) {
        KF5Entity<Topic> kf5Entity = new KF5Entity<Topic>();
        try {
            MessageStatus messageStatus = this.sendPostRequest(KF5Interface.createTopic(this.getDomain()), JSONObject.parse(jsonString).toString());
            this.buildTopic(messageStatus, kf5Entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5Entity<Topic> updateTopic(String topic_id, String jsonString) {
        this.checkHasId(topic_id);
        KF5Entity<Topic> kf5Entity = new KF5Entity<Topic>();
        try {
            MessageStatus messageStatus = this.sendPutRequest(KF5Interface.updateTopic(this.getDomain(), topic_id), JSONObject.parse(jsonString).toString());
            this.buildTopic(messageStatus, kf5Entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5Entity<String> deleteTopic(String topic_id) {
        this.checkHasId(topic_id);
        return this.buildResultWithString(this.sendDeleteRequest(KF5Interface.deleteTopic(this.getDomain(), topic_id)));
    }

    public KF5PaginationEntity<List<Question>> getQuestionList() {
        return this.getQuestionListWithQuery("");
    }

    public KF5PaginationEntity<List<Question>> getQuestionListWithQuery(String query) {
        return this.getQuestionListWithURL(KF5Interface.getQuestionList(this.getDomain(), query));
    }

    public KF5PaginationEntity<List<Question>> getQuestionListWithURL(String url) {
        return this.buildPaginationQuestionList(this.sendGetRequest(url));
    }

    public KF5Entity<Question> getQuestionByID(String question_id) {
        this.checkHasId(question_id);
        return this.buildQuestion(this.sendGetRequest(KF5Interface.getQuestionByID(this.getDomain(), question_id)));
    }

    public KF5Entity<Question> createQuestion(String jsonString) {
        KF5Entity<Question> kf5Entity = new KF5Entity<Question>();
        try {
            MessageStatus messageStatus = this.sendPostRequest(KF5Interface.createQuestion(this.getDomain()), JSONObject.parse(jsonString).toString());
            this.buildQuestion(messageStatus, kf5Entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5Entity<Question> updateQuestion(String question_id, String jsonString) {
        this.checkHasId(question_id);
        KF5Entity<Question> kf5Entity = new KF5Entity<Question>();
        try {
            MessageStatus messageStatus = this.sendPutRequest(KF5Interface.updateQuestion(this.getDomain(), question_id), JSONObject.parse(jsonString).toString());
            this.buildQuestion(messageStatus, kf5Entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5Entity<String> deleteQuestion(String question_id) {
        this.checkHasId(question_id);
        return this.buildResultWithString(this.sendDeleteRequest(KF5Interface.deleteQuestion(this.getDomain(), question_id)));
    }

    public KF5PaginationEntity<List<QuestionComment>> getQuestionCommentList(String question_id) {
        return this.getQuestionCommentList(question_id, "");
    }

    public KF5PaginationEntity<List<QuestionComment>> getQuestionCommentList(String question_id, String query) {
        this.checkHasId(question_id);
        return this.getQuestionCommentListByURL(KF5Interface.getQuestionCommentList(this.getDomain(), question_id, query));
    }

    public KF5PaginationEntity<List<QuestionComment>> getQuestionCommentListByURL(String url) {
        return this.buildPaginationQuestionCommentList(this.sendGetRequest(url));
    }

    public KF5Entity<QuestionComment> getQuestionCommentByID(String question_id, String comment_id) {
        this.checkHasId(question_id, comment_id);
        MessageStatus messageStatus = this.sendGetRequest(KF5Interface.getQuestionCommentByID(this.getDomain(), question_id, comment_id));
        return this.buildQuestionComment(messageStatus);
    }

    public KF5PaginationEntity<List<QuestionComment>> replyQuestion(String question_id, String jsonString) {
        this.checkHasId(question_id);
        KF5PaginationEntity<List<QuestionComment>> kf5Entity = new KF5PaginationEntity<List<QuestionComment>>();
        try {
            MessageStatus messageStatus = this.sendPutRequest(KF5Interface.replyQuestion(this.getDomain(), question_id), JSONObject.parse(jsonString).toString());
            this.buildPaginationQuestionCommentList(messageStatus, kf5Entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5PaginationEntity<List<Category>> getCategoriesList() {
        return this.getCategoriesListWithQuery("");
    }

    public KF5PaginationEntity<List<Category>> getCategoriesListWithQuery(String query) {
        return this.getCategoriesListWithURL(KF5Interface.getCategoriesList(this.getDomain(), query));
    }

    public KF5PaginationEntity<List<Category>> getCategoriesListWithURL(String url) {
        return this.buildPaginationCategoriesList(this.sendGetRequest(url));
    }

    public KF5Entity<Category> getCategoryByID(String category_id) {
        this.checkHasId(category_id);
        return this.buildCategory(this.sendGetRequest(KF5Interface.getCategoryByID(this.getDomain(), category_id)));
    }

    public KF5Entity<Category> createCategory(String jsonString) {
        KF5Entity<Category> kf5Entity = new KF5Entity<Category>();
        try {
            MessageStatus messageStatus = this.sendPostRequest(KF5Interface.createCategory(this.getDomain()), JSONObject.parse(jsonString).toString());
            this.buildCategory(messageStatus, kf5Entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5Entity<Category> updateCategory(String category_id, String jsonString) {
        this.checkHasId(category_id);
        KF5Entity<Category> kf5Entity = new KF5Entity<Category>();
        try {
            MessageStatus messageStatus = this.sendPutRequest(KF5Interface.updateCategory(this.getDomain(), category_id), JSONObject.parse(jsonString).toString());
            this.buildCategory(messageStatus, kf5Entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5Entity<String> deleteCategory(String category_id) {
        this.checkHasId(category_id);
        return this.buildResultWithString(this.sendDeleteRequest(KF5Interface.deleteCategory(this.getDomain(), category_id)));
    }

    public KF5PaginationEntity<List<Forum>> getForumList() {
        return this.getForumListWithQuery("");
    }

    public KF5PaginationEntity<List<Forum>> getForumListWithQuery(String query) {
        return this.getForumListWithURL(KF5Interface.getForumList(this.getDomain(), query));
    }

    public KF5PaginationEntity<List<Forum>> getForumListWithURL(String url) {
        return this.buildPaginationForumList(this.sendGetRequest(url));
    }

    public KF5Entity<Forum> getForumByID(String forum_id) {
        this.checkHasId(forum_id);
        return this.buildForum(this.sendGetRequest(KF5Interface.getForumByID(this.getDomain(), forum_id)));
    }

    public KF5Entity<Forum> createForum(String jsonString) {
        KF5Entity<Forum> kf5Entity = new KF5Entity<Forum>();
        try {
            MessageStatus messageStatus = this.sendPostRequest(KF5Interface.createForum(this.getDomain()), JSONObject.parse(jsonString).toString());
            this.buildForum(messageStatus, kf5Entity);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5Entity<Forum> updateForum(String forum_id, String jsonString) {
        this.checkHasId(forum_id);
        KF5Entity<Forum> kf5Entity = new KF5Entity<Forum>();
        try {
            MessageStatus messageStatus = this.sendPutRequest(KF5Interface.updateForum(this.getDomain(), forum_id), JSONObject.parse(jsonString).toString());
            this.buildForum(messageStatus, kf5Entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5Entity<String> deleteForum(String forum_id) {
        this.checkHasId(forum_id);
        return this.buildResultWithString(this.sendDeleteRequest(KF5Interface.deleteForum(this.getDomain(), forum_id)));
    }

    public KF5PaginationEntity<List<Post>> getPostList() {
        return this.getPostListWithQuery("");
    }

    public KF5PaginationEntity<List<Post>> getPostListWithQuery(String query) {
        return this.getPostListWithURL(KF5Interface.getPostList(this.getDomain(), query));
    }

    public KF5PaginationEntity<List<Post>> getPostListWithURL(String url) {
        return this.buildPaginationPostList(this.sendGetRequest(url));
    }

    public KF5Entity<Post> getPostByID(String post_id) {
        this.checkHasId(post_id);
        return this.buildPost(this.sendGetRequest(KF5Interface.getPostDetail(this.getDomain(), post_id)));
    }

    public KF5Entity<List<Post>> getManyPosts(String posts_ids) {
        this.checkHasId(posts_ids);
        return this.buildListPost(this.sendGetRequest(KF5Interface.getManyPosts(this.getDomain(), posts_ids)));
    }

    public KF5PaginationEntity<List<Post>> searchPost(String key_word) {
        return this.searchPost(key_word, 0, 0);
    }

    public KF5PaginationEntity<List<Post>> searchPost(String key_word, int page, int per_page) {
        this.checkNotNull(key_word);
        return this.searchPostByURL(KF5Interface.searchPost(this.getDomain(), key_word, page, per_page));
    }

    public KF5PaginationEntity<List<Post>> searchPost(Map<String, String> query) {
        return this.searchPostByURL(KF5Interface.searchPost(this.getDomain(), query));
    }

    public KF5PaginationEntity<List<Post>> searchPostByURL(String url) {
        return this.buildPaginationPostList(this.sendGetRequest(url));
    }

    public KF5Entity<Post> createPost(String jsonString) {
        KF5Entity<Post> kf5Entity = new KF5Entity<Post>();
        try {
            MessageStatus messageStatus = this.sendPostRequest(KF5Interface.createPost(this.getDomain()), JSONObject.parse(jsonString).toString());
            this.buildPost(messageStatus, kf5Entity);
        }
        catch (JSONException e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5Entity<Post> updatePost(String post_id, String jsonString) {
        this.checkHasId(post_id);
        return this.buildPost(this.sendPutRequest(KF5Interface.updatePost(this.getDomain(), post_id), JSONObject.parse(jsonString).toString()));
    }

    public KF5Entity<String> deletePost(String post_id) {
        this.checkHasId(post_id);
        return this.buildResultWithString(this.sendDeleteRequest(KF5Interface.deletePost(this.getDomain(), post_id)));
    }

    public KF5PaginationEntity<List<PostComment>> getPostCommentList(String post_id) {
        return this.getPostCommentList(post_id, "");
    }

    public KF5PaginationEntity<List<PostComment>> getPostCommentList(String post_id, String query) {
        this.checkHasId(post_id);
        return this.getPostCommentListByURL(KF5Interface.getPostCommentList(this.getDomain(), post_id, query));
    }

    public KF5PaginationEntity<List<PostComment>> getPostCommentListByURL(String url) {
        return this.buildPaginationPostCommentList(this.sendGetRequest(url));
    }

    public KF5Entity<PostComment> getPostCommentByID(String post_id, String id) {
        this.checkHasId(post_id, id);
        return this.buildPostComment(this.sendGetRequest(KF5Interface.getPostCommentByID(this.getDomain(), post_id, id)));
    }

    public KF5Entity<PostComment> postReply(String post_id, String jsonString) {
        this.checkHasId(post_id);
        return this.buildPostComment(this.sendPostRequest(KF5Interface.postReply(this.getDomain(), post_id), JSONObject.parse(jsonString).toString()));
    }

    public KF5Entity<Attachment> uploadAttachment(String path) {
        KF5Entity<Attachment> kf5Entity = new KF5Entity<Attachment>();
        try {
            File file = new File(path);
            String result = HttpRequest.uploadAttachment(KF5Interface.uploadAttachment(this.getDomain(), file.getName()), file, this.baseToken);
            JSONObject jsonObject = KF5EntityBuilder.safeObject(result);
            JSONObject object = KF5EntityBuilder.safeObject(jsonObject, "attachment");
            kf5Entity.setResultCode(0);
            kf5Entity.setData(EntityBuilder.buildAttachment(object));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5Entity<Attachment> viewAttachment(String attachment_id) {
        this.checkHasId(attachment_id);
        MessageStatus messageStatus = this.sendGetRequest(KF5Interface.viewAttachment(this.getDomain(), attachment_id));
        return this.buildAttachment(messageStatus);
    }

    public KF5Entity<String> deleteAttachment(String attachment_id) {
        this.checkHasId(attachment_id);
        MessageStatus messageStatus = this.sendDeleteRequest(KF5Interface.deleteAttachment(this.getDomain(), attachment_id));
        return this.buildResultWithString(messageStatus);
    }

    public KF5Entity<Ticket> importOrder(String jsonString) {
        KF5Entity<Ticket> kf5Entity = new KF5Entity<Ticket>();
        try {
            MessageStatus messageStatus = this.sendPostRequest(KF5Interface.importOrder(this.getDomain()), JSONObject.parse(jsonString).toString());
            this.buildTicket(messageStatus, kf5Entity);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dealErrorData(kf5Entity, e.getMessage());
        }
        return kf5Entity;
    }

    public KF5ExportTicketEntity<List<Ticket>> orderExport(String param) {
        KF5ExportTicketEntity<List<Ticket>> kf5Entity = new KF5ExportTicketEntity<List<Ticket>>();
        MessageStatus messageStatus = this.sendGetRequest(KF5Interface.orderExport(this.getDomain(), param));
        JSONObject jsonObject = messageStatus.getJsonObject();
        kf5Entity.setResultCode(messageStatus.getStatus());
        if (messageStatus.getStatus() == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(jsonObject, "tickets");
            kf5Entity.setData(EntityBuilder.buildTicketList(jsonArray));
            this.setPagesAndCount(kf5Entity, jsonObject);
            kf5Entity.setStartTime(KF5EntityBuilder.safeInt(jsonObject, "start_time"));
            kf5Entity.setEndTime(KF5EntityBuilder.safeInt(jsonObject, "end_time"));
        } else {
            kf5Entity.setMessage(jsonObject.toString());
        }
        return kf5Entity;
    }

    public KF5PaginationEntity<List<Chat>> getChatListWithQueryParams(String query) {
        return this.buildPaginationChatList(this.sendGetRequest(KF5Interface.getChatList(this.getDomain(), query)));
    }

    public KF5PaginationEntity<List<Chat>> getChatListWithURL(String url) {
        return this.buildPaginationChatList(this.sendGetRequest(url));
    }

    public KF5Entity<Chat> getChatDetailByChatId(int chat_id) {
        return this.buildChat(this.sendGetRequest(KF5Interface.getChatDetailByID(this.getDomain(), chat_id)));
    }

    public KF5PaginationEntity<List<AICategory>> getAiQuestionList(String query) {
        return this.buildPaginationListAICategory(this.sendGetRequest(KF5Interface.getAIQuestionList(this.getDomain(), query)));
    }

    public KF5PaginationEntity<List<AICategory>> createAIQuestion(String jsonString) {
        return this.buildPaginationListAICategory(this.sendPostRequest(KF5Interface.createAIQuestion(this.getDomain()), jsonString));
    }

    public KF5Entity<AICategory> updateQuestionByID(int id, String jsonString) {
        return this.buildAICategory(this.sendPutRequest(KF5Interface.updateQuestionByID(this.getDomain(), id), jsonString));
    }

    public void deleteQuestionById(String params) {
        this.sendDeleteRequest(KF5Interface.deleteQuestionById(this.getDomain()), params);
    }

    public KF5PaginationEntity<List<AIQuestionCategory>> getQuestionCategoriesList(String query) {
        return this.buildPaginationAIQuestionCategoryList(this.sendGetRequest(KF5Interface.getQuestionCategoriesList(this.getDomain(), query)));
    }

    public KF5PaginationEntity<List<AIQuestionCategory>> createQuestionCategories(String params) {
        return this.buildPaginationAIQuestionCategoryList(this.sendPostRequest(KF5Interface.createQuestionCategories(this.getDomain()), params));
    }

    public KF5Entity<AIQuestionCategory> updateQuestionCategories(int id, String params) {
        return this.buildAIQuestionCategory(this.sendPutRequest(KF5Interface.updateQuestionCategories(this.getDomain(), id), params));
    }

    public void deleteQuestionCategories(String params) {
        this.sendDeleteRequest(KF5Interface.deleteQuestionCategories(this.getDomain()), params);
    }

    public KF5PaginationEntity<List<Ticket>> searchTickets(Map<String, String> params) {
        return this.buildPaginationTicketList(this.sendGetRequest(KF5Interface.searchTickets(this.getDomain(), params)));
    }

    public KF5Entity<List<Trigger>> getTraggerList() {
        return this.buildTriggerList(this.sendGetRequest(KF5Interface.getTriggerList(this.getDomain())));
    }

    public KF5Entity<Trigger> getTriggerById(int id) {
        return this.getTriggerByUrl(KF5Interface.getTriggerById(this.getDomain(), id));
    }

    public KF5Entity<Trigger> getTriggerByUrl(String url) {
        return this.buildTrigger(this.sendGetRequest(url));
    }

    public KF5Entity<List<Trigger>> getActiveTriggerList() {
        return this.buildTriggerList(this.sendGetRequest(KF5Interface.getActiveTriggerList(this.getDomain())));
    }

    public KF5Entity<List<Automation>> getAutomationList() {
        return this.buildAutomationList(this.sendGetRequest(KF5Interface.getAutomationList(this.getDomain())));
    }

    public KF5Entity<Automation> getAutomationById(int id) {
        return this.getAutomationByUrl(KF5Interface.getAutomationById(this.getDomain(), id));
    }

    public KF5Entity<Automation> getAutomationByUrl(String url) {
        return this.buildAutomation(this.sendGetRequest(url));
    }

    public KF5Entity<List<Automation>> getActiveAutomationList() {
        return this.buildAutomationList(this.sendGetRequest(KF5Interface.getActiveAutomationList(this.getDomain())));
    }

    public KF5PaginationEntity<List<Chat>> getHistoryChatList(Map<String, String> params) {
        return this.buildPaginationChatList(this.sendGetRequest(KF5Interface.getHistoryChatList(this.getDomain(), params)));
    }

    public KF5PaginationEntity<List<Chat>> getHistoryChatByUrl(String url) {
        return this.buildPaginationChatList(this.sendGetRequest(url));
    }

    public KF5Entity<Chat> getHistoryChatById(int chat_id) {
        return this.buildChat(this.sendGetRequest(KF5Interface.getHistroyChatById(this.getDomain(), chat_id)));
    }

    public KF5Entity<List<AgentLog>> getAgentLoginLogList(Map<String, String> params) {
        return this.buildAgentLogList(this.sendGetRequest(KF5Interface.getAgentLoginLogList(this.getDomain(), params)));
    }

    public KF5Entity<List<AITag>> getAITagList(Map<String, String> params) {
        return this.buildAITagList(this.sendGetRequest(KF5Interface.getAITagList(this.getDomain(), params)));
    }

    public KF5Entity<List<AITag>> createAITag(String jsonString) {
        return this.buildAITagList(this.sendPostRequest(KF5Interface.createAITag(this.getDomain()), jsonString));
    }

    public void updateAITag(int tagId, String jsonString) {
        this.sendPutRequest(KF5Interface.updateAITag(this.getDomain(), tagId), jsonString);
    }

    public void deleteAITag(int tagId) {
        this.sendDeleteRequest(KF5Interface.deleteAITag(this.getDomain(), tagId));
    }

    public KF5Entity<MonitorAgent> getMonitorAgentList(Map<String, String> map) {
        return this.buildMonitorAgent(this.sendGetRequest(KF5Interface.getMonitorAgentList(this.getDomain(), map)));
    }

    public KF5Entity<List<ChatInfo>> getMonitorChatList() {
        return this.buildChatInfoList(this.sendGetRequest(KF5Interface.getMonitorChatList(this.getDomain())));
    }

    public KF5Entity<List<QueueVisitorInfo>> getMonitorVisitorQueueList() {
        return this.buildQueueVisitorInfoList(this.sendGetRequest(KF5Interface.getMonitorVisitorQueueList(this.getDomain())));
    }

    public KF5Entity<AgentWorkStatusStatistics> getAgentWorkStatusStatistics(Map<String, String> map) {
        return this.buildAgentWorkStatusStatistics(this.sendGetRequest(KF5Interface.getAgentWorkStatusList(this.getDomain(), map)));
    }

    public KF5Entity<AgentConversationStatistics> getAgentConverstationStatistics(Map<String, String> map) {
        return this.buildAgentConversationStatistics(this.sendGetRequest(KF5Interface.getAgentConversation(this.getDomain(), map)));
    }

    public KF5Entity<AgentStatusTimeStatistics> getAgentStatusTimeStatistics(Map<String, String> map) {
        return this.buildAgentStatusTimeStatistics(this.sendGetRequest(KF5Interface.getAgentStatusTime(this.getDomain(), map)));
    }

    public KF5Entity<ChatSourceStatistics> getChatSourceStatistics(Map<String, String> map) {
        return this.buildChatSourceStatistics(this.sendGetRequest(KF5Interface.getChatSource(this.getDomain(), map)));
    }

    public KF5Entity<AgentStatistics> updateAgentStatus(Map<String, String> map) {
        return this.buildAgentStatistics(this.sendGetRequest(KF5Interface.updateAgentStatu(this.getDomain(), map)));
    }

    public KF5PaginationEntity<List<VoiceCall>> getVoiceCallList(Map<String, String> map) {
        return this.buildVoiceCallList(this.sendGetRequest(KF5Interface.getVoiceCallList(this.getDomain(), map)));
    }

    public KF5PaginationEntity<List<VoiceCall>> getVoiceCallListByUrl(String url) {
        return this.buildVoiceCallList(this.sendGetRequest(url));
    }

    public KF5Entity<VoiceCall> getVoiceCallById(int call_id) {
        return this.buildVoiceCall(this.sendGetRequest(KF5Interface.getVoiceCallById(this.getDomain(), call_id)));
    }

    public KF5PaginationEntity<List<VoiceAccount>> getVoiceAccountList(Map<String, String> map) {
        return this.buildVoiceAccountList(this.sendGetRequest(KF5Interface.getVoiceAccountList(this.getDomain(), map)));
    }

    public KF5PaginationEntity<List<VoiceAccount>> getVoiceAccountListByUrl(String url) {
        return this.buildVoiceAccountList(this.sendGetRequest(url));
    }

    public KF5Entity<VoiceAccount> getVoiceAccountById(String id) {
        return this.buildVoiceAccount(this.sendGetRequest(KF5Interface.getVoiceAccountById(this.getDomain(), id)));
    }

    public KF5Entity<VoiceAccount> updateVoiceAccount(String id, String jsonString) {
        return this.buildVoiceAccount(this.sendPutRequest(KF5Interface.updateVoiceAccount(this.getDomain(), id), jsonString));
    }

    public KF5PaginationEntity<List<VoiceAgentLoginState>> getVoiceAgentLoginStateList(Map<String, String> map) {
        return this.buildVoiceAgentLoginStateList(this.sendGetRequest(KF5Interface.getVoiceAgentLoginStateList(this.getDomain(), map)));
    }

    public KF5PaginationEntity<List<VoiceAgentLoginState>> getVoiceAgentLoginStateListByUrl(String url) {
        return this.buildVoiceAgentLoginStateList(this.sendGetRequest(url));
    }

    public KF5PaginationEntity<List<VoiceCallUnAnswered>> getVoiceCallUnAnsweredList(Map<String, String> map) {
        return this.buildVoiceCallUnAnsweredList(this.sendGetRequest(KF5Interface.getVoiceCallUnAnsweredList(this.getDomain(), map)));
    }

    public KF5PaginationEntity<List<VoiceCallUnAnswered>> getVoiceCallUnAnsweredListByUrl(String url) {
        return this.buildVoiceCallUnAnsweredList(this.sendGetRequest(url));
    }

    public KF5Entity<List<AgentVoiceCallOutbound>> getAgentVoiceCallOutboundList(Map<String, String> map) {
        return this.buildAgentVoiceCallOutboundList(this.sendGetRequest(KF5Interface.getAgentVoiceCallOutboundList(this.getDomain(), map)));
    }

    public KF5Entity<List<AgentVoiceCallInbound>> getAgentVoiceCallInboundList(Map<String, String> map) {
        return this.buildAgentVoiceCallInboundList(this.sendGetRequest(KF5Interface.getAgentVoiceCallInboundList(this.getDomain(), map)));
    }

    public KF5Entity<List<AgentVoicePerformance>> getAgentVoicePerformanceList(Map<String, String> map) {
        return this.buildAgentVoicePerformanceList(this.sendGetRequest(KF5Interface.getAgentVoicePerformance(this.getDomain(), map)));
    }

    public KF5Entity<List<AgentVoiceStateTime>> getAgentVoiceStateTimeList(Map<String, String> map) {
        return this.buildAgentVoiceStateTimeList(this.sendGetRequest(KF5Interface.getAgentVoiceStateTime(this.getDomain(), map)));
    }

    public KF5Entity<List<AgentVoiceCallSubsectionInbound>> getAgentVoiceCallSubsectionInboundList(Map<String, String> map) {
        return this.buildAgentVoiceCallSubsectionInboundList(this.sendGetRequest(KF5Interface.getAgentVoiceCallSubsectionInbound(this.getDomain(), map)));
    }

    public KF5Entity<List<AgentVoiceCallSubsectionOutbound>> getAgentVoiceCallSubsectionOutboundList(Map<String, String> map) {
        return this.buildAgentVoiceCallSubsectionOutboundList(this.sendGetRequest(KF5Interface.getAgentVoiceCallSubsectionOutbound(this.getDomain(), map)));
    }

    public KF5Entity<List<VoiceQueueCall>> getVoiceQueueCallList() {
        return this.buildVoiceQueueCallList(this.sendGetRequest(KF5Interface.getVoiceQueueCall(this.getDomain())));
    }

    public KF5Entity<List<AgentVoiceStatus>> getAgentVoiceStatusList() {
        return this.buildAgentVoiceStatusList(this.sendGetRequest(KF5Interface.getVoiceAgentStatus(this.getDomain())));
    }

    public KF5Entity<AgentVoiceStatus> getAgentVoiceStatusById(String id) {
        return this.buildAgentVoiceStatus(this.sendGetRequest(KF5Interface.getAgentVoiceStatusById(this.getDomain(), id)));
    }

    public boolean setAgentVoiceOnline() {
        return this.setAgentVoiceStatus(KF5Interface.setAgentVoiceOnline(this.getDomain()));
    }

    public boolean setAgentVoiceBusy() {
        return this.setAgentVoiceStatus(KF5Interface.setAgentVoiceBusy(this.getDomain()));
    }

    public boolean setAgentVoiceBreak() {
        return this.setAgentVoiceStatus(KF5Interface.setAgentVoiceBreak(this.getDomain()));
    }

    public boolean setAgentVoiceOffline() {
        return this.setAgentVoiceStatus(KF5Interface.setAgentVoiceOffline(this.getDomain()));
    }

    private boolean setAgentVoiceStatus(String url) {
        MessageStatus messageStatus = this.sendPostRequest(url, "");
        if (messageStatus.getStatus() == 0) {
            return KF5EntityBuilder.safeBoolean(messageStatus.getJsonObject(), "success");
        }
        return false;
    }

    public KF5PaginationEntity<List<SystemLog>> getSystemLogList(Map<String, String> map) {
        return this.buildSystemLogList(this.sendGetRequest(KF5Interface.getSystemLog(this.getDomain(), map)));
    }

    public KF5PaginationEntity<List<SystemLog>> getSystemLogListByUrl(String url) {
        return this.buildSystemLogList(this.sendGetRequest(url));
    }

    public void getIMAgentList() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("action", (Object)"get_agent_states");
        this.sendPostRequest(KF5Interface.getIMAgentList(), jsonObject.toJSONString());
    }
}

