/*
 * Decompiled with CFR 0.152.
 */
package com.kf5.support.util;

import java.util.HashMap;
import java.util.Map;

public class Base64Utils {
    private static final Map<Integer, Character> base64CharMap = new HashMap<Integer, Character>();
    private static final String base64CharString = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    public static String encode(String origin) {
        if (origin == null) {
            return null;
        }
        if (origin.length() == 0) {
            return "";
        }
        int length = origin.length();
        String binaryString = "";
        for (int i = 0; i < length; ++i) {
            char ascii = origin.charAt(i);
            String binaryCharString = Integer.toBinaryString(ascii);
            while (binaryCharString.length() < 8) {
                binaryCharString = "0" + binaryCharString;
            }
            binaryString = binaryString + binaryCharString;
        }
        int beginIndex = 0;
        int endIndex = beginIndex + 6;
        String base64BinaryString = "";
        String charString = "";
        while ((base64BinaryString = binaryString.substring(beginIndex, endIndex)).length() > 0) {
            while (base64BinaryString.length() < 6) {
                base64BinaryString = base64BinaryString + "0";
            }
            int index = Integer.parseInt(base64BinaryString, 2);
            char base64Char = base64CharMap.get(index).charValue();
            charString = charString + base64Char;
            beginIndex += 6;
            if ((endIndex += 6) >= binaryString.length()) {
                endIndex = binaryString.length();
            }
            if (endIndex >= beginIndex) continue;
            break;
        }
        if (length % 3 == 2) {
            charString = charString + "=";
        }
        if (length % 3 == 1) {
            charString = charString + "==";
        }
        return charString;
    }

    public static String decode(String encodedString) {
        if (encodedString == null) {
            return null;
        }
        if (encodedString.length() == 0) {
            return "";
        }
        String origin = encodedString.substring(0, encodedString.indexOf("="));
        String equals = encodedString.substring(encodedString.indexOf("="));
        String binaryString = "";
        for (int i = 0; i < origin.length(); ++i) {
            char c = origin.charAt(i);
            int ascii = base64CharString.indexOf(c);
            String binaryCharString = Integer.toBinaryString(ascii);
            while (binaryCharString.length() < 6) {
                binaryCharString = "0" + binaryCharString;
            }
            binaryString = binaryString + binaryCharString;
        }
        if (equals.length() == 1) {
            binaryString = binaryString.substring(0, binaryString.length() - 2);
        }
        if (equals.length() == 2) {
            binaryString = binaryString.substring(0, binaryString.length() - 4);
        }
        String charString = "";
        String resultString = "";
        int beginIndex = 0;
        int endIndex = beginIndex + 8;
        while ((charString = binaryString.substring(beginIndex, endIndex)).length() == 8) {
            int ascii = Integer.parseInt(charString, 2);
            resultString = resultString + (char)ascii;
            beginIndex += 8;
            if ((endIndex += 8) <= binaryString.length()) continue;
            break;
        }
        return resultString;
    }

    static {
        for (int i = 0; i < base64CharString.length(); ++i) {
            char c = base64CharString.charAt(i);
            base64CharMap.put(new Integer(i), new Character(c));
        }
    }
}

