/*
 * Decompiled with CFR 0.152.
 */
package org.kf5.support.fastjson.parser;

import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessControlException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.kf5.support.fastjson.JSONArray;
import org.kf5.support.fastjson.JSONException;
import org.kf5.support.fastjson.JSONObject;
import org.kf5.support.fastjson.annotation.JSONType;
import org.kf5.support.fastjson.asm.ASMException;
import org.kf5.support.fastjson.parser.SymbolTable;
import org.kf5.support.fastjson.parser.deserializer.ASMDeserializerFactory;
import org.kf5.support.fastjson.parser.deserializer.ASMJavaBeanDeserializer;
import org.kf5.support.fastjson.parser.deserializer.ArrayDeserializer;
import org.kf5.support.fastjson.parser.deserializer.ArrayListTypeFieldDeserializer;
import org.kf5.support.fastjson.parser.deserializer.AutowiredObjectDeserializer;
import org.kf5.support.fastjson.parser.deserializer.BooleanFieldDeserializer;
import org.kf5.support.fastjson.parser.deserializer.CharArrayDeserializer;
import org.kf5.support.fastjson.parser.deserializer.ClassDerializer;
import org.kf5.support.fastjson.parser.deserializer.CollectionDeserializer;
import org.kf5.support.fastjson.parser.deserializer.DateDeserializer;
import org.kf5.support.fastjson.parser.deserializer.DateFormatDeserializer;
import org.kf5.support.fastjson.parser.deserializer.DefaultFieldDeserializer;
import org.kf5.support.fastjson.parser.deserializer.EnumDeserializer;
import org.kf5.support.fastjson.parser.deserializer.FieldDeserializer;
import org.kf5.support.fastjson.parser.deserializer.IntegerFieldDeserializer;
import org.kf5.support.fastjson.parser.deserializer.JSONArrayDeserializer;
import org.kf5.support.fastjson.parser.deserializer.JSONObjectDeserializer;
import org.kf5.support.fastjson.parser.deserializer.JavaBeanDeserializer;
import org.kf5.support.fastjson.parser.deserializer.JavaObjectDeserializer;
import org.kf5.support.fastjson.parser.deserializer.Jdk8DateCodec;
import org.kf5.support.fastjson.parser.deserializer.LongFieldDeserializer;
import org.kf5.support.fastjson.parser.deserializer.MapDeserializer;
import org.kf5.support.fastjson.parser.deserializer.NumberDeserializer;
import org.kf5.support.fastjson.parser.deserializer.ObjectDeserializer;
import org.kf5.support.fastjson.parser.deserializer.SqlDateDeserializer;
import org.kf5.support.fastjson.parser.deserializer.StackTraceElementDeserializer;
import org.kf5.support.fastjson.parser.deserializer.StringFieldDeserializer;
import org.kf5.support.fastjson.parser.deserializer.ThrowableDeserializer;
import org.kf5.support.fastjson.parser.deserializer.TimeDeserializer;
import org.kf5.support.fastjson.parser.deserializer.TimestampDeserializer;
import org.kf5.support.fastjson.serializer.AtomicIntegerArrayCodec;
import org.kf5.support.fastjson.serializer.AtomicLongArrayCodec;
import org.kf5.support.fastjson.serializer.BigDecimalCodec;
import org.kf5.support.fastjson.serializer.BigIntegerCodec;
import org.kf5.support.fastjson.serializer.BooleanCodec;
import org.kf5.support.fastjson.serializer.CalendarCodec;
import org.kf5.support.fastjson.serializer.CharacterCodec;
import org.kf5.support.fastjson.serializer.CharsetCodec;
import org.kf5.support.fastjson.serializer.ColorCodec;
import org.kf5.support.fastjson.serializer.CurrencyCodec;
import org.kf5.support.fastjson.serializer.FileCodec;
import org.kf5.support.fastjson.serializer.FloatCodec;
import org.kf5.support.fastjson.serializer.FontCodec;
import org.kf5.support.fastjson.serializer.InetAddressCodec;
import org.kf5.support.fastjson.serializer.InetSocketAddressCodec;
import org.kf5.support.fastjson.serializer.IntegerCodec;
import org.kf5.support.fastjson.serializer.LocaleCodec;
import org.kf5.support.fastjson.serializer.LongCodec;
import org.kf5.support.fastjson.serializer.PatternCodec;
import org.kf5.support.fastjson.serializer.PointCodec;
import org.kf5.support.fastjson.serializer.RectangleCodec;
import org.kf5.support.fastjson.serializer.ReferenceCodec;
import org.kf5.support.fastjson.serializer.StringCodec;
import org.kf5.support.fastjson.serializer.TimeZoneCodec;
import org.kf5.support.fastjson.serializer.URICodec;
import org.kf5.support.fastjson.serializer.URLCodec;
import org.kf5.support.fastjson.serializer.UUIDCodec;
import org.kf5.support.fastjson.util.ASMUtils;
import org.kf5.support.fastjson.util.DeserializeBeanInfo;
import org.kf5.support.fastjson.util.FieldInfo;
import org.kf5.support.fastjson.util.IdentityHashMap;
import org.kf5.support.fastjson.util.ServiceLoader;

public class ParserConfig {
    private final Set<Class<?>> primitiveClasses = new HashSet();
    private static ParserConfig global = new ParserConfig();
    private final IdentityHashMap<Type, ObjectDeserializer> derializers = new IdentityHashMap();
    private boolean asmEnable = !ASMUtils.isAndroid();
    protected final SymbolTable symbolTable = new SymbolTable();
    protected ASMDeserializerFactory asmFactory;

    public static ParserConfig getGlobalInstance() {
        return global;
    }

    public ParserConfig() {
        this(null, null);
    }

    public ParserConfig(ClassLoader parentClassLoader) {
        this(null, parentClassLoader);
    }

    public ParserConfig(ASMDeserializerFactory asmFactory) {
        this(asmFactory, null);
    }

    private ParserConfig(ASMDeserializerFactory asmFactory, ClassLoader parentClassLoader) {
        if (asmFactory == null) {
            try {
                asmFactory = parentClassLoader == null ? ASMDeserializerFactory.getInstance() : new ASMDeserializerFactory(parentClassLoader);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
            }
            catch (AccessControlException accessControlException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        this.asmFactory = asmFactory;
        if (asmFactory == null) {
            this.asmEnable = false;
        }
        this.primitiveClasses.add(Boolean.TYPE);
        this.primitiveClasses.add(Boolean.class);
        this.primitiveClasses.add(Character.TYPE);
        this.primitiveClasses.add(Character.class);
        this.primitiveClasses.add(Byte.TYPE);
        this.primitiveClasses.add(Byte.class);
        this.primitiveClasses.add(Short.TYPE);
        this.primitiveClasses.add(Short.class);
        this.primitiveClasses.add(Integer.TYPE);
        this.primitiveClasses.add(Integer.class);
        this.primitiveClasses.add(Long.TYPE);
        this.primitiveClasses.add(Long.class);
        this.primitiveClasses.add(Float.TYPE);
        this.primitiveClasses.add(Float.class);
        this.primitiveClasses.add(Double.TYPE);
        this.primitiveClasses.add(Double.class);
        this.primitiveClasses.add(BigInteger.class);
        this.primitiveClasses.add(BigDecimal.class);
        this.primitiveClasses.add(String.class);
        this.primitiveClasses.add(Date.class);
        this.primitiveClasses.add(java.sql.Date.class);
        this.primitiveClasses.add(Time.class);
        this.primitiveClasses.add(Timestamp.class);
        this.derializers.put((Type)((Object)SimpleDateFormat.class), DateFormatDeserializer.instance);
        this.derializers.put((Type)((Object)Timestamp.class), TimestampDeserializer.instance);
        this.derializers.put((Type)((Object)java.sql.Date.class), SqlDateDeserializer.instance);
        this.derializers.put((Type)((Object)Time.class), TimeDeserializer.instance);
        this.derializers.put((Type)((Object)Date.class), DateDeserializer.instance);
        this.derializers.put((Type)((Object)Calendar.class), CalendarCodec.instance);
        this.derializers.put((Type)((Object)JSONObject.class), JSONObjectDeserializer.instance);
        this.derializers.put((Type)((Object)JSONArray.class), JSONArrayDeserializer.instance);
        this.derializers.put((Type)((Object)Map.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)HashMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)LinkedHashMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)TreeMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)ConcurrentMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)ConcurrentHashMap.class), MapDeserializer.instance);
        this.derializers.put((Type)((Object)Collection.class), CollectionDeserializer.instance);
        this.derializers.put((Type)((Object)List.class), CollectionDeserializer.instance);
        this.derializers.put((Type)((Object)ArrayList.class), CollectionDeserializer.instance);
        this.derializers.put((Type)((Object)Object.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)String.class), StringCodec.instance);
        this.derializers.put((Type)((Object)StringBuffer.class), StringCodec.instance);
        this.derializers.put((Type)((Object)StringBuilder.class), StringCodec.instance);
        this.derializers.put(Character.TYPE, CharacterCodec.instance);
        this.derializers.put((Type)((Object)Character.class), CharacterCodec.instance);
        this.derializers.put(Byte.TYPE, NumberDeserializer.instance);
        this.derializers.put((Type)((Object)Byte.class), NumberDeserializer.instance);
        this.derializers.put(Short.TYPE, NumberDeserializer.instance);
        this.derializers.put((Type)((Object)Short.class), NumberDeserializer.instance);
        this.derializers.put(Integer.TYPE, IntegerCodec.instance);
        this.derializers.put((Type)((Object)Integer.class), IntegerCodec.instance);
        this.derializers.put(Long.TYPE, LongCodec.instance);
        this.derializers.put((Type)((Object)Long.class), LongCodec.instance);
        this.derializers.put((Type)((Object)BigInteger.class), BigIntegerCodec.instance);
        this.derializers.put((Type)((Object)BigDecimal.class), BigDecimalCodec.instance);
        this.derializers.put(Float.TYPE, FloatCodec.instance);
        this.derializers.put((Type)((Object)Float.class), FloatCodec.instance);
        this.derializers.put(Double.TYPE, NumberDeserializer.instance);
        this.derializers.put((Type)((Object)Double.class), NumberDeserializer.instance);
        this.derializers.put(Boolean.TYPE, BooleanCodec.instance);
        this.derializers.put((Type)((Object)Boolean.class), BooleanCodec.instance);
        this.derializers.put((Type)((Object)Class.class), ClassDerializer.instance);
        this.derializers.put((Type)((Object)char[].class), CharArrayDeserializer.instance);
        this.derializers.put((Type)((Object)AtomicBoolean.class), BooleanCodec.instance);
        this.derializers.put((Type)((Object)AtomicInteger.class), IntegerCodec.instance);
        this.derializers.put((Type)((Object)AtomicLong.class), LongCodec.instance);
        this.derializers.put((Type)((Object)AtomicReference.class), ReferenceCodec.instance);
        this.derializers.put((Type)((Object)WeakReference.class), ReferenceCodec.instance);
        this.derializers.put((Type)((Object)SoftReference.class), ReferenceCodec.instance);
        this.derializers.put((Type)((Object)UUID.class), UUIDCodec.instance);
        this.derializers.put((Type)((Object)TimeZone.class), TimeZoneCodec.instance);
        this.derializers.put((Type)((Object)Locale.class), LocaleCodec.instance);
        this.derializers.put((Type)((Object)Currency.class), CurrencyCodec.instance);
        this.derializers.put((Type)((Object)InetAddress.class), InetAddressCodec.instance);
        this.derializers.put((Type)((Object)Inet4Address.class), InetAddressCodec.instance);
        this.derializers.put((Type)((Object)Inet6Address.class), InetAddressCodec.instance);
        this.derializers.put((Type)((Object)InetSocketAddress.class), InetSocketAddressCodec.instance);
        this.derializers.put((Type)((Object)File.class), FileCodec.instance);
        this.derializers.put((Type)((Object)URI.class), URICodec.instance);
        this.derializers.put((Type)((Object)URL.class), URLCodec.instance);
        this.derializers.put((Type)((Object)Pattern.class), PatternCodec.instance);
        this.derializers.put((Type)((Object)Charset.class), CharsetCodec.instance);
        this.derializers.put((Type)((Object)Number.class), NumberDeserializer.instance);
        this.derializers.put((Type)((Object)AtomicIntegerArray.class), AtomicIntegerArrayCodec.instance);
        this.derializers.put((Type)((Object)AtomicLongArray.class), AtomicLongArrayCodec.instance);
        this.derializers.put((Type)((Object)StackTraceElement.class), StackTraceElementDeserializer.instance);
        this.derializers.put((Type)((Object)Serializable.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)Cloneable.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)Comparable.class), JavaObjectDeserializer.instance);
        this.derializers.put((Type)((Object)Closeable.class), JavaObjectDeserializer.instance);
        try {
            this.derializers.put(Class.forName("java.awt.Point"), PointCodec.instance);
            this.derializers.put(Class.forName("java.awt.Font"), FontCodec.instance);
            this.derializers.put(Class.forName("java.awt.Rectangle"), RectangleCodec.instance);
            this.derializers.put(Class.forName("java.awt.Color"), ColorCodec.instance);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.derializers.put(Class.forName("java.time.LocalDateTime"), Jdk8DateCodec.instance);
            this.derializers.put(Class.forName("java.time.LocalDate"), Jdk8DateCodec.instance);
            this.derializers.put(Class.forName("java.time.LocalTime"), Jdk8DateCodec.instance);
            this.derializers.put(Class.forName("java.time.ZonedDateTime"), Jdk8DateCodec.instance);
            this.derializers.put(Class.forName("java.time.OffsetDateTime"), Jdk8DateCodec.instance);
            this.derializers.put(Class.forName("java.time.OffsetTime"), Jdk8DateCodec.instance);
            this.derializers.put(Class.forName("java.time.ZoneOffset"), Jdk8DateCodec.instance);
            this.derializers.put(Class.forName("java.time.ZoneRegion"), Jdk8DateCodec.instance);
            this.derializers.put(Class.forName("java.time.ZoneId"), Jdk8DateCodec.instance);
            this.derializers.put(Class.forName("java.time.Period"), Jdk8DateCodec.instance);
            this.derializers.put(Class.forName("java.time.Duration"), Jdk8DateCodec.instance);
            this.derializers.put(Class.forName("java.time.Instant"), Jdk8DateCodec.instance);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isAsmEnable() {
        return this.asmEnable;
    }

    public void setAsmEnable(boolean asmEnable) {
        this.asmEnable = asmEnable;
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public IdentityHashMap<Type, ObjectDeserializer> getDerializers() {
        return this.derializers;
    }

    public ObjectDeserializer getDeserializer(Type type) {
        ObjectDeserializer derializer = this.derializers.get(type);
        if (derializer != null) {
            return derializer;
        }
        if (type instanceof Class) {
            return this.getDeserializer((Class)type, type);
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            if (rawType instanceof Class) {
                return this.getDeserializer((Class)rawType, type);
            }
            return this.getDeserializer(rawType);
        }
        return JavaObjectDeserializer.instance;
    }

    public ObjectDeserializer getDeserializer(Class<?> clazz, Type type) {
        Class<?> mappingTo;
        ObjectDeserializer derializer = this.derializers.get(type);
        if (derializer != null) {
            return derializer;
        }
        if (type == null) {
            type = clazz;
        }
        if ((derializer = this.derializers.get(type)) != null) {
            return derializer;
        }
        JSONType annotation = clazz.getAnnotation(JSONType.class);
        if (annotation != null && (mappingTo = annotation.mappingTo()) != Void.class) {
            return this.getDeserializer(mappingTo, mappingTo);
        }
        if (type instanceof WildcardType || type instanceof TypeVariable || type instanceof ParameterizedType) {
            derializer = this.derializers.get(clazz);
        }
        if (derializer != null) {
            return derializer;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            for (AutowiredObjectDeserializer autowired : ServiceLoader.load(AutowiredObjectDeserializer.class, classLoader)) {
                for (Type forType : autowired.getAutowiredFor()) {
                    this.derializers.put(forType, autowired);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if ((derializer = this.derializers.get(type)) != null) {
            return derializer;
        }
        derializer = clazz.isEnum() ? new EnumDeserializer(clazz) : (clazz.isArray() ? ArrayDeserializer.instance : (clazz == Set.class || clazz == HashSet.class || clazz == Collection.class || clazz == List.class || clazz == ArrayList.class ? CollectionDeserializer.instance : (Collection.class.isAssignableFrom(clazz) ? CollectionDeserializer.instance : (Map.class.isAssignableFrom(clazz) ? MapDeserializer.instance : (Throwable.class.isAssignableFrom(clazz) ? new ThrowableDeserializer(this, clazz) : this.createJavaBeanDeserializer(clazz, type))))));
        this.putDeserializer(type, derializer);
        return derializer;
    }

    public ObjectDeserializer createJavaBeanDeserializer(Class<?> clazz, Type type) {
        boolean asmEnable = this.asmEnable;
        if (asmEnable) {
            Class<?> superClass = clazz;
            do {
                if (Modifier.isPublic(superClass.getModifiers())) continue;
                asmEnable = false;
                break;
            } while ((superClass = superClass.getSuperclass()) != Object.class && superClass != null);
        }
        if (clazz.getTypeParameters().length != 0) {
            asmEnable = false;
        }
        if (asmEnable && this.asmFactory != null && this.asmFactory.isExternalClass(clazz)) {
            asmEnable = false;
        }
        if (asmEnable) {
            asmEnable = ASMUtils.checkName(clazz.getName());
        }
        if (asmEnable) {
            Constructor<?> defaultConstructor;
            DeserializeBeanInfo beanInfo;
            if (clazz.isInterface()) {
                asmEnable = false;
            }
            if ((beanInfo = DeserializeBeanInfo.computeSetters(clazz, type)).getFieldList().size() > 200) {
                asmEnable = false;
            }
            if ((defaultConstructor = beanInfo.getDefaultConstructor()) == null && !clazz.isInterface()) {
                asmEnable = false;
            }
            for (FieldInfo fieldInfo : beanInfo.getFieldList()) {
                if (fieldInfo.isGetOnly()) {
                    asmEnable = false;
                    break;
                }
                Class<?> fieldClass = fieldInfo.getFieldClass();
                if (!Modifier.isPublic(fieldClass.getModifiers())) {
                    asmEnable = false;
                    break;
                }
                if (fieldClass.isMemberClass() && !Modifier.isStatic(fieldClass.getModifiers())) {
                    asmEnable = false;
                }
                if (ASMUtils.checkName(fieldInfo.getMember().getName())) continue;
                asmEnable = false;
            }
        }
        if (asmEnable && clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
            asmEnable = false;
        }
        if (!asmEnable) {
            return new JavaBeanDeserializer(this, clazz, type);
        }
        try {
            return this.asmFactory.createJavaBeanDeserializer(this, clazz, type);
        }
        catch (NoSuchMethodException ex) {
            return new JavaBeanDeserializer(this, clazz, type);
        }
        catch (ASMException asmError) {
            return new JavaBeanDeserializer(this, clazz, type);
        }
        catch (Exception e) {
            throw new JSONException("create asm deserializer error, " + clazz.getName(), e);
        }
    }

    public FieldDeserializer createFieldDeserializer(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) {
        boolean asmEnable = this.asmEnable;
        if (asmEnable) {
            Class<?> superClass = clazz;
            do {
                if (Modifier.isPublic(superClass.getModifiers())) continue;
                asmEnable = false;
                break;
            } while ((superClass = superClass.getSuperclass()) != Object.class && superClass != null);
        }
        if (fieldInfo.getFieldClass() == Class.class) {
            asmEnable = false;
        }
        if (asmEnable && this.asmFactory != null && this.asmFactory.isExternalClass(clazz)) {
            asmEnable = false;
        }
        if (!asmEnable) {
            return this.createFieldDeserializerWithoutASM(mapping, clazz, fieldInfo);
        }
        try {
            return this.asmFactory.createFieldDeserializer(mapping, clazz, fieldInfo);
        }
        catch (Throwable throwable) {
            return this.createFieldDeserializerWithoutASM(mapping, clazz, fieldInfo);
        }
    }

    public FieldDeserializer createFieldDeserializerWithoutASM(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) {
        Class<?> fieldClass = fieldInfo.getFieldClass();
        if (fieldClass == Boolean.TYPE || fieldClass == Boolean.class) {
            return new BooleanFieldDeserializer(mapping, clazz, fieldInfo);
        }
        if (fieldClass == Integer.TYPE || fieldClass == Integer.class) {
            return new IntegerFieldDeserializer(mapping, clazz, fieldInfo);
        }
        if (fieldClass == Long.TYPE || fieldClass == Long.class) {
            return new LongFieldDeserializer(mapping, clazz, fieldInfo);
        }
        if (fieldClass == String.class) {
            return new StringFieldDeserializer(mapping, clazz, fieldInfo);
        }
        if (fieldClass == List.class || fieldClass == ArrayList.class) {
            return new ArrayListTypeFieldDeserializer(mapping, clazz, fieldInfo);
        }
        return new DefaultFieldDeserializer(mapping, clazz, fieldInfo);
    }

    public void putDeserializer(Type type, ObjectDeserializer deserializer) {
        this.derializers.put(type, deserializer);
    }

    public ObjectDeserializer getDeserializer(FieldInfo fieldInfo) {
        return this.getDeserializer(fieldInfo.getFieldClass(), fieldInfo.getFieldType());
    }

    public boolean isPrimitive(Class<?> clazz) {
        return this.primitiveClasses.contains(clazz);
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Field field = ParserConfig.getField0(clazz, fieldName);
        if (field == null) {
            field = ParserConfig.getField0(clazz, "_" + fieldName);
        }
        if (field == null) {
            field = ParserConfig.getField0(clazz, "m_" + fieldName);
        }
        return field;
    }

    private static Field getField0(Class<?> clazz, String fieldName) {
        for (Field item : clazz.getDeclaredFields()) {
            if (!fieldName.equals(item.getName())) continue;
            return item;
        }
        if (clazz.getSuperclass() != null && clazz.getSuperclass() != Object.class) {
            return ParserConfig.getField(clazz.getSuperclass(), fieldName);
        }
        return null;
    }

    public Map<String, FieldDeserializer> getFieldDeserializers(Class<?> clazz) {
        ObjectDeserializer deserizer = this.getDeserializer(clazz);
        if (deserizer instanceof JavaBeanDeserializer) {
            return ((JavaBeanDeserializer)deserizer).getFieldDeserializerMap();
        }
        if (deserizer instanceof ASMJavaBeanDeserializer) {
            return ((ASMJavaBeanDeserializer)deserizer).getInnterSerializer().getFieldDeserializerMap();
        }
        return Collections.emptyMap();
    }
}

