/*
 * Decompiled with CFR 0.152.
 */
package org.kf5.support.fastjson.parser.deserializer;

import java.lang.reflect.Type;
import java.util.Map;
import org.kf5.support.fastjson.parser.DefaultJSONParser;
import org.kf5.support.fastjson.parser.JSONLexer;
import org.kf5.support.fastjson.parser.ParserConfig;
import org.kf5.support.fastjson.parser.deserializer.FieldDeserializer;
import org.kf5.support.fastjson.util.FieldInfo;
import org.kf5.support.fastjson.util.TypeUtils;

public class BooleanFieldDeserializer
extends FieldDeserializer {
    public BooleanFieldDeserializer(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) {
        super(clazz, fieldInfo);
    }

    @Override
    public void parseField(DefaultJSONParser parser, Object object, Type objectType, Map<String, Object> fieldValues) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 6) {
            lexer.nextToken(16);
            if (object == null) {
                fieldValues.put(this.fieldInfo.getName(), Boolean.TRUE);
            } else {
                this.setValue(object, true);
            }
            return;
        }
        if (lexer.token() == 2) {
            boolean booleanValue;
            int val = lexer.intValue();
            lexer.nextToken(16);
            boolean bl = booleanValue = val == 1;
            if (object == null) {
                fieldValues.put(this.fieldInfo.getName(), booleanValue);
            } else {
                this.setValue(object, booleanValue);
            }
            return;
        }
        if (lexer.token() == 8) {
            Object value = null;
            lexer.nextToken(16);
            if (this.getFieldClass() == Boolean.TYPE) {
                return;
            }
            if (object != null) {
                this.setValue(object, null);
            }
            return;
        }
        if (lexer.token() == 7) {
            lexer.nextToken(16);
            if (object == null) {
                fieldValues.put(this.fieldInfo.getName(), Boolean.FALSE);
            } else {
                this.setValue(object, false);
            }
            return;
        }
        Object obj = parser.parse();
        Boolean value = TypeUtils.castToBoolean(obj);
        if (value == null && this.getFieldClass() == Boolean.TYPE) {
            return;
        }
        if (object == null) {
            fieldValues.put(this.fieldInfo.getName(), value);
        } else {
            this.setValue(object, value);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 6;
    }
}

