/*
 * Decompiled with CFR 0.152.
 */
package org.kf5.support.fastjson.parser.deserializer;

import java.lang.reflect.Type;
import org.kf5.support.fastjson.JSON;
import org.kf5.support.fastjson.parser.DefaultJSONParser;
import org.kf5.support.fastjson.parser.JSONLexer;
import org.kf5.support.fastjson.parser.deserializer.ObjectDeserializer;

public class CharArrayDeserializer
implements ObjectDeserializer {
    public static final CharArrayDeserializer instance = new CharArrayDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        return CharArrayDeserializer.deserialze(parser);
    }

    public static <T> T deserialze(DefaultJSONParser parser) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 4) {
            String val = lexer.stringVal();
            lexer.nextToken(16);
            return (T)val.toCharArray();
        }
        if (lexer.token() == 2) {
            Number val = lexer.integerValue();
            lexer.nextToken(16);
            return (T)val.toString().toCharArray();
        }
        Object value = parser.parse();
        if (value == null) {
            return null;
        }
        return (T)JSON.toJSONString(value).toCharArray();
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

