/*
 * Decompiled with CFR 0.152.
 */
package org.kf5.support.fastjson.parser.deserializer;

import java.lang.reflect.Type;
import java.util.Map;
import org.kf5.support.fastjson.parser.DefaultJSONParser;
import org.kf5.support.fastjson.parser.JSONLexer;
import org.kf5.support.fastjson.parser.ParserConfig;
import org.kf5.support.fastjson.parser.deserializer.FieldDeserializer;
import org.kf5.support.fastjson.parser.deserializer.ObjectDeserializer;
import org.kf5.support.fastjson.util.FieldInfo;
import org.kf5.support.fastjson.util.TypeUtils;

public class LongFieldDeserializer
extends FieldDeserializer {
    private final ObjectDeserializer fieldValueDeserilizer;

    public LongFieldDeserializer(ParserConfig mapping, Class<?> clazz, FieldInfo fieldInfo) {
        super(clazz, fieldInfo);
        this.fieldValueDeserilizer = mapping.getDeserializer(fieldInfo);
    }

    @Override
    public void parseField(DefaultJSONParser parser, Object object, Type objectType, Map<String, Object> fieldValues) {
        Long value;
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 2) {
            long val = lexer.longValue();
            lexer.nextToken(16);
            if (object == null) {
                fieldValues.put(this.fieldInfo.getName(), val);
            } else {
                this.setValue(object, val);
            }
            return;
        }
        if (lexer.token() == 8) {
            value = null;
            lexer.nextToken(16);
        } else {
            Object obj = parser.parse();
            value = TypeUtils.castToLong(obj);
        }
        if (value == null && this.getFieldClass() == Long.TYPE) {
            return;
        }
        if (object == null) {
            fieldValues.put(this.fieldInfo.getName(), value);
        } else {
            this.setValue(object, value);
        }
    }

    @Override
    public int getFastMatchToken() {
        return this.fieldValueDeserilizer.getFastMatchToken();
    }
}

