/*
 * Decompiled with CFR 0.152.
 */
package org.kf5.support.fastjson.parser.deserializer;

import java.lang.reflect.Type;
import org.kf5.support.fastjson.JSON;
import org.kf5.support.fastjson.JSONException;
import org.kf5.support.fastjson.parser.DefaultJSONParser;
import org.kf5.support.fastjson.parser.Feature;
import org.kf5.support.fastjson.parser.JSONLexer;
import org.kf5.support.fastjson.parser.JSONToken;
import org.kf5.support.fastjson.parser.deserializer.ObjectDeserializer;

public class StackTraceElementDeserializer
implements ObjectDeserializer {
    public static final StackTraceElementDeserializer instance = new StackTraceElementDeserializer();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 8) {
            lexer.nextToken();
            return null;
        }
        if (lexer.token() != 12 && lexer.token() != 16) {
            throw new JSONException("syntax error: " + JSONToken.name(lexer.token()));
        }
        String declaringClass = null;
        String methodName = null;
        String fileName = null;
        int lineNumber = 0;
        while (true) {
            String key;
            if ((key = lexer.scanSymbol(parser.getSymbolTable())) == null) {
                if (lexer.token() == 13) {
                    lexer.nextToken(16);
                    return (T)new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
                }
                if (lexer.token() == 16 && lexer.isEnabled(Feature.AllowArbitraryCommas)) continue;
            }
            lexer.nextTokenWithColon(4);
            if ("className".equals(key)) {
                if (lexer.token() == 8) {
                    declaringClass = null;
                } else {
                    if (lexer.token() != 4) throw new JSONException("syntax error");
                    declaringClass = lexer.stringVal();
                }
            } else if ("methodName".equals(key)) {
                if (lexer.token() == 8) {
                    methodName = null;
                } else {
                    if (lexer.token() != 4) throw new JSONException("syntax error");
                    methodName = lexer.stringVal();
                }
            } else if ("fileName".equals(key)) {
                if (lexer.token() == 8) {
                    fileName = null;
                } else {
                    if (lexer.token() != 4) throw new JSONException("syntax error");
                    fileName = lexer.stringVal();
                }
            } else if ("lineNumber".equals(key)) {
                if (lexer.token() == 8) {
                    lineNumber = 0;
                } else {
                    if (lexer.token() != 2) throw new JSONException("syntax error");
                    lineNumber = lexer.intValue();
                }
            } else if ("nativeMethod".equals(key)) {
                if (lexer.token() == 8) {
                    lexer.nextToken(16);
                } else if (lexer.token() == 6) {
                    lexer.nextToken(16);
                } else {
                    if (lexer.token() != 7) throw new JSONException("syntax error");
                    lexer.nextToken(16);
                }
            } else {
                if (key != JSON.DEFAULT_TYPE_KEY) throw new JSONException("syntax error : " + key);
                if (lexer.token() == 4) {
                    String elementType = lexer.stringVal();
                    if (!elementType.equals("java.lang.StackTraceElement")) {
                        throw new JSONException("syntax error : " + elementType);
                    }
                } else if (lexer.token() != 8) {
                    throw new JSONException("syntax error");
                }
            }
            if (lexer.token() == 13) break;
        }
        lexer.nextToken(16);
        return (T)new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }
}

