/*
 * Decompiled with CFR 0.152.
 */
package org.kf5.support.fastjson.serializer;

import java.io.IOException;
import java.lang.reflect.Type;
import org.kf5.support.fastjson.serializer.JSONSerializer;
import org.kf5.support.fastjson.serializer.ObjectSerializer;
import org.kf5.support.fastjson.serializer.SerialContext;
import org.kf5.support.fastjson.serializer.SerializeWriter;
import org.kf5.support.fastjson.serializer.SerializerFeature;

public class ArraySerializer
implements ObjectSerializer {
    private final Class<?> componentType;
    private final ObjectSerializer compObjectSerializer;

    public ArraySerializer(Class<?> componentType, ObjectSerializer compObjectSerializer) {
        this.componentType = componentType;
        this.compObjectSerializer = compObjectSerializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            if (out.isEnabled(SerializerFeature.WriteNullListAsEmpty)) {
                out.write("[]");
            } else {
                out.writeNull();
            }
            return;
        }
        Object[] array = (Object[])object;
        int size = array.length;
        SerialContext context = serializer.getContext();
        serializer.setContext(context, object, fieldName, 0);
        try {
            out.append('[');
            for (int i = 0; i < size; ++i) {
                Object item;
                if (i != 0) {
                    out.append(',');
                }
                if ((item = array[i]) == null) {
                    out.append("null");
                    continue;
                }
                if (item.getClass() == this.componentType) {
                    this.compObjectSerializer.write(serializer, item, i, null, 0);
                    continue;
                }
                ObjectSerializer itemSerializer = serializer.getObjectWriter(item.getClass());
                itemSerializer.write(serializer, item, i, null, 0);
            }
            out.append(']');
        }
        finally {
            serializer.setContext(context);
        }
    }
}

