/*
 * Decompiled with CFR 0.152.
 */
package org.kf5.support.fastjson.serializer;

import java.io.IOException;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import org.kf5.support.fastjson.JSON;
import org.kf5.support.fastjson.serializer.JSONSerializer;
import org.kf5.support.fastjson.serializer.ObjectSerializer;
import org.kf5.support.fastjson.serializer.SerializeWriter;
import org.kf5.support.fastjson.serializer.SerializerFeature;

public class DateFormatSerializer
implements ObjectSerializer {
    public static final DateFormatSerializer instance = new DateFormatSerializer();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            out.writeNull();
            return;
        }
        String pattern = ((SimpleDateFormat)object).toPattern();
        if (out.isEnabled(SerializerFeature.WriteClassName) && object.getClass() != fieldType) {
            out.write('{');
            out.writeFieldName(JSON.DEFAULT_TYPE_KEY);
            serializer.write(object.getClass().getName());
            out.writeFieldValue(',', "val", pattern);
            out.write('}');
            return;
        }
        out.writeString(pattern);
    }
}

