/*
 * Decompiled with CFR 0.152.
 */
package org.kf5.support.fastjson.serializer;

import java.io.IOException;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.kf5.support.fastjson.JSONException;
import org.kf5.support.fastjson.parser.DefaultJSONParser;
import org.kf5.support.fastjson.parser.deserializer.ObjectDeserializer;
import org.kf5.support.fastjson.serializer.JSONSerializer;
import org.kf5.support.fastjson.serializer.ObjectSerializer;

public class InetAddressCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static InetAddressCodec instance = new InetAddressCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        if (object == null) {
            serializer.writeNull();
            return;
        }
        InetAddress address = (InetAddress)object;
        serializer.write(address.getHostAddress());
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        String host = (String)parser.parse();
        if (host == null) {
            return null;
        }
        if (host.length() == 0) {
            return null;
        }
        try {
            return (T)InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new JSONException("deserialize error", e);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

