/*
 * Decompiled with CFR 0.152.
 */
package org.kf5.support.fastjson.serializer;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Locale;
import org.kf5.support.fastjson.parser.DefaultJSONParser;
import org.kf5.support.fastjson.parser.deserializer.ObjectDeserializer;
import org.kf5.support.fastjson.serializer.JSONSerializer;
import org.kf5.support.fastjson.serializer.ObjectSerializer;

public class LocaleCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final LocaleCodec instance = new LocaleCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        if (object == null) {
            serializer.writeNull();
            return;
        }
        Locale locale = (Locale)object;
        serializer.write(locale.toString());
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        String text = (String)parser.parse();
        if (text == null) {
            return null;
        }
        String[] items = text.split("_");
        if (items.length == 1) {
            return (T)new Locale(items[0]);
        }
        if (items.length == 2) {
            return (T)new Locale(items[0], items[1]);
        }
        return (T)new Locale(items[0], items[1], items[2]);
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

