/*
 * Decompiled with CFR 0.152.
 */
package org.kf5.support.fastjson.serializer;

import java.io.File;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.kf5.support.fastjson.JSON;
import org.kf5.support.fastjson.JSONAware;
import org.kf5.support.fastjson.JSONException;
import org.kf5.support.fastjson.JSONStreamAware;
import org.kf5.support.fastjson.annotation.JSONType;
import org.kf5.support.fastjson.parser.deserializer.Jdk8DateCodec;
import org.kf5.support.fastjson.serializer.ASMSerializerFactory;
import org.kf5.support.fastjson.serializer.AppendableSerializer;
import org.kf5.support.fastjson.serializer.ArraySerializer;
import org.kf5.support.fastjson.serializer.AtomicBooleanSerializer;
import org.kf5.support.fastjson.serializer.AtomicIntegerArrayCodec;
import org.kf5.support.fastjson.serializer.AtomicIntegerSerializer;
import org.kf5.support.fastjson.serializer.AtomicLongArrayCodec;
import org.kf5.support.fastjson.serializer.AtomicLongSerializer;
import org.kf5.support.fastjson.serializer.AutowiredObjectSerializer;
import org.kf5.support.fastjson.serializer.BigDecimalCodec;
import org.kf5.support.fastjson.serializer.BigIntegerCodec;
import org.kf5.support.fastjson.serializer.BooleanArraySerializer;
import org.kf5.support.fastjson.serializer.BooleanCodec;
import org.kf5.support.fastjson.serializer.ByteArraySerializer;
import org.kf5.support.fastjson.serializer.CalendarCodec;
import org.kf5.support.fastjson.serializer.CharArraySerializer;
import org.kf5.support.fastjson.serializer.CharacterCodec;
import org.kf5.support.fastjson.serializer.CharsetCodec;
import org.kf5.support.fastjson.serializer.ClassSerializer;
import org.kf5.support.fastjson.serializer.ClobSeriliazer;
import org.kf5.support.fastjson.serializer.CollectionSerializer;
import org.kf5.support.fastjson.serializer.ColorCodec;
import org.kf5.support.fastjson.serializer.CurrencyCodec;
import org.kf5.support.fastjson.serializer.DateFormatSerializer;
import org.kf5.support.fastjson.serializer.DateSerializer;
import org.kf5.support.fastjson.serializer.DoubleArraySerializer;
import org.kf5.support.fastjson.serializer.DoubleSerializer;
import org.kf5.support.fastjson.serializer.EnumSerializer;
import org.kf5.support.fastjson.serializer.EnumerationSeriliazer;
import org.kf5.support.fastjson.serializer.ExceptionSerializer;
import org.kf5.support.fastjson.serializer.FileCodec;
import org.kf5.support.fastjson.serializer.FloatArraySerializer;
import org.kf5.support.fastjson.serializer.FloatCodec;
import org.kf5.support.fastjson.serializer.FontCodec;
import org.kf5.support.fastjson.serializer.InetAddressCodec;
import org.kf5.support.fastjson.serializer.InetSocketAddressCodec;
import org.kf5.support.fastjson.serializer.IntArraySerializer;
import org.kf5.support.fastjson.serializer.IntegerCodec;
import org.kf5.support.fastjson.serializer.JSONAwareSerializer;
import org.kf5.support.fastjson.serializer.JSONSerializable;
import org.kf5.support.fastjson.serializer.JSONSerializableSerializer;
import org.kf5.support.fastjson.serializer.JSONStreamAwareSerializer;
import org.kf5.support.fastjson.serializer.JavaBeanSerializer;
import org.kf5.support.fastjson.serializer.ListSerializer;
import org.kf5.support.fastjson.serializer.LocaleCodec;
import org.kf5.support.fastjson.serializer.LongArraySerializer;
import org.kf5.support.fastjson.serializer.LongCodec;
import org.kf5.support.fastjson.serializer.MapSerializer;
import org.kf5.support.fastjson.serializer.ObjectArraySerializer;
import org.kf5.support.fastjson.serializer.ObjectSerializer;
import org.kf5.support.fastjson.serializer.PatternCodec;
import org.kf5.support.fastjson.serializer.PointCodec;
import org.kf5.support.fastjson.serializer.RectangleCodec;
import org.kf5.support.fastjson.serializer.ReferenceCodec;
import org.kf5.support.fastjson.serializer.ShortArraySerializer;
import org.kf5.support.fastjson.serializer.StringCodec;
import org.kf5.support.fastjson.serializer.TimeZoneCodec;
import org.kf5.support.fastjson.serializer.URICodec;
import org.kf5.support.fastjson.serializer.URLCodec;
import org.kf5.support.fastjson.serializer.UUIDCodec;
import org.kf5.support.fastjson.util.ASMUtils;
import org.kf5.support.fastjson.util.IdentityHashMap;
import org.kf5.support.fastjson.util.ServiceLoader;

public class SerializeConfig
extends IdentityHashMap<Type, ObjectSerializer> {
    private static final SerializeConfig globalInstance = new SerializeConfig();
    private boolean asm = !ASMUtils.isAndroid();
    private ASMSerializerFactory asmFactory;
    private String typeKey = JSON.DEFAULT_TYPE_KEY;

    public String getTypeKey() {
        return this.typeKey;
    }

    public void setTypeKey(String typeKey) {
        this.typeKey = typeKey;
    }

    public final ObjectSerializer createASMSerializer(Class<?> clazz) throws Exception {
        return this.asmFactory.createJavaBeanSerializer(clazz, null);
    }

    public ObjectSerializer createJavaBeanSerializer(Class<?> clazz) {
        JSONType annotation;
        if (!Modifier.isPublic(clazz.getModifiers())) {
            return new JavaBeanSerializer(clazz);
        }
        boolean asm = this.asm;
        if (asm && this.asmFactory.isExternalClass(clazz) || clazz == Serializable.class || clazz == Object.class) {
            asm = false;
        }
        if ((annotation = clazz.getAnnotation(JSONType.class)) != null && !annotation.asm()) {
            asm = false;
        }
        if (asm && !ASMUtils.checkName(clazz.getName())) {
            asm = false;
        }
        if (asm) {
            try {
                ObjectSerializer asmSerializer = this.createASMSerializer(clazz);
                if (asmSerializer != null) {
                    return asmSerializer;
                }
            }
            catch (ClassCastException asmSerializer) {
            }
            catch (Throwable e) {
                throw new JSONException("create asm serializer error, class " + clazz, e);
            }
        }
        return new JavaBeanSerializer(clazz);
    }

    public boolean isAsmEnable() {
        return this.asm;
    }

    public void setAsmEnable(boolean asmEnable) {
        this.asm = asmEnable;
    }

    public static final SerializeConfig getGlobalInstance() {
        return globalInstance;
    }

    public SerializeConfig() {
        this(1024);
    }

    public SerializeConfig(int tableSize) {
        super(tableSize);
        try {
            this.asmFactory = new ASMSerializerFactory();
        }
        catch (NoClassDefFoundError eror) {
            this.asm = false;
        }
        catch (ExceptionInInitializerError error) {
            this.asm = false;
        }
        this.put(Boolean.class, BooleanCodec.instance);
        this.put(Character.class, CharacterCodec.instance);
        this.put(Byte.class, IntegerCodec.instance);
        this.put(Short.class, IntegerCodec.instance);
        this.put(Integer.class, IntegerCodec.instance);
        this.put(Long.class, LongCodec.instance);
        this.put(Float.class, FloatCodec.instance);
        this.put(Double.class, DoubleSerializer.instance);
        this.put(BigDecimal.class, BigDecimalCodec.instance);
        this.put(BigInteger.class, BigIntegerCodec.instance);
        this.put(String.class, StringCodec.instance);
        this.put(byte[].class, ByteArraySerializer.instance);
        this.put(short[].class, ShortArraySerializer.instance);
        this.put(int[].class, IntArraySerializer.instance);
        this.put(long[].class, LongArraySerializer.instance);
        this.put(float[].class, FloatArraySerializer.instance);
        this.put(double[].class, DoubleArraySerializer.instance);
        this.put(boolean[].class, BooleanArraySerializer.instance);
        this.put(char[].class, CharArraySerializer.instance);
        this.put(Object[].class, ObjectArraySerializer.instance);
        this.put(Class.class, ClassSerializer.instance);
        this.put(SimpleDateFormat.class, DateFormatSerializer.instance);
        this.put(Locale.class, LocaleCodec.instance);
        this.put(Currency.class, CurrencyCodec.instance);
        this.put(TimeZone.class, TimeZoneCodec.instance);
        this.put(UUID.class, UUIDCodec.instance);
        this.put(InetAddress.class, InetAddressCodec.instance);
        this.put(Inet4Address.class, InetAddressCodec.instance);
        this.put(Inet6Address.class, InetAddressCodec.instance);
        this.put(InetSocketAddress.class, InetSocketAddressCodec.instance);
        this.put(File.class, FileCodec.instance);
        this.put(URI.class, URICodec.instance);
        this.put(URL.class, URLCodec.instance);
        this.put(Appendable.class, AppendableSerializer.instance);
        this.put(StringBuffer.class, AppendableSerializer.instance);
        this.put(StringBuilder.class, AppendableSerializer.instance);
        this.put(Pattern.class, PatternCodec.instance);
        this.put(Charset.class, CharsetCodec.instance);
        this.put(AtomicBoolean.class, AtomicBooleanSerializer.instance);
        this.put(AtomicInteger.class, AtomicIntegerSerializer.instance);
        this.put(AtomicLong.class, AtomicLongSerializer.instance);
        this.put(AtomicReference.class, ReferenceCodec.instance);
        this.put(AtomicIntegerArray.class, AtomicIntegerArrayCodec.instance);
        this.put(AtomicLongArray.class, AtomicLongArrayCodec.instance);
        this.put(WeakReference.class, ReferenceCodec.instance);
        this.put(SoftReference.class, ReferenceCodec.instance);
        try {
            this.put(Class.forName("java.awt.Color"), ColorCodec.instance);
            this.put(Class.forName("java.awt.Font"), FontCodec.instance);
            this.put(Class.forName("java.awt.Point"), PointCodec.instance);
            this.put(Class.forName("java.awt.Rectangle"), RectangleCodec.instance);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.put(Class.forName("java.time.LocalDateTime"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.LocalDate"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.LocalTime"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.ZonedDateTime"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.OffsetDateTime"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.OffsetTime"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.ZoneOffset"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.ZoneRegion"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.Period"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.Duration"), Jdk8DateCodec.instance);
            this.put(Class.forName("java.time.Instant"), Jdk8DateCodec.instance);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public ObjectSerializer getObjectWriter(Class<?> clazz) {
        ClassLoader classLoader;
        AutowiredObjectSerializer autowired;
        ObjectSerializer writer = (ObjectSerializer)this.get(clazz);
        if (writer == null) {
            try {
                ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
                for (AutowiredObjectSerializer autowiredObjectSerializer : ServiceLoader.load(AutowiredObjectSerializer.class, classLoader2)) {
                    if (!(autowiredObjectSerializer instanceof AutowiredObjectSerializer)) continue;
                    autowired = autowiredObjectSerializer;
                    for (Type forType : autowired.getAutowiredFor()) {
                        this.put(forType, autowired);
                    }
                }
            }
            catch (ClassCastException classLoader2) {
                // empty catch block
            }
            writer = (ObjectSerializer)this.get(clazz);
        }
        if (writer == null && (classLoader = JSON.class.getClassLoader()) != Thread.currentThread().getContextClassLoader()) {
            try {
                for (AutowiredObjectSerializer autowiredObjectSerializer : ServiceLoader.load(AutowiredObjectSerializer.class, classLoader)) {
                    if (!(autowiredObjectSerializer instanceof AutowiredObjectSerializer)) continue;
                    autowired = autowiredObjectSerializer;
                    for (Type forType : autowired.getAutowiredFor()) {
                        this.put(forType, autowired);
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            writer = (ObjectSerializer)this.get(clazz);
        }
        if (writer == null) {
            if (Map.class.isAssignableFrom(clazz)) {
                this.put(clazz, MapSerializer.instance);
            } else if (List.class.isAssignableFrom(clazz)) {
                this.put(clazz, ListSerializer.instance);
            } else if (Collection.class.isAssignableFrom(clazz)) {
                this.put(clazz, CollectionSerializer.instance);
            } else if (Date.class.isAssignableFrom(clazz)) {
                this.put(clazz, DateSerializer.instance);
            } else if (JSONAware.class.isAssignableFrom(clazz)) {
                this.put(clazz, JSONAwareSerializer.instance);
            } else if (JSONSerializable.class.isAssignableFrom(clazz)) {
                this.put(clazz, JSONSerializableSerializer.instance);
            } else if (JSONStreamAware.class.isAssignableFrom(clazz)) {
                this.put(clazz, JSONStreamAwareSerializer.instance);
            } else if (clazz.isEnum() || clazz.getSuperclass() != null && clazz.getSuperclass().isEnum()) {
                this.put(clazz, EnumSerializer.instance);
            } else if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                ObjectSerializer compObjectSerializer = this.getObjectWriter(componentType);
                this.put(clazz, new ArraySerializer(componentType, compObjectSerializer));
            } else if (Throwable.class.isAssignableFrom(clazz)) {
                this.put(clazz, new ExceptionSerializer(clazz));
            } else if (TimeZone.class.isAssignableFrom(clazz)) {
                this.put(clazz, TimeZoneCodec.instance);
            } else if (Appendable.class.isAssignableFrom(clazz)) {
                this.put(clazz, AppendableSerializer.instance);
            } else if (Charset.class.isAssignableFrom(clazz)) {
                this.put(clazz, CharsetCodec.instance);
            } else if (Enumeration.class.isAssignableFrom(clazz)) {
                this.put(clazz, EnumerationSeriliazer.instance);
            } else if (Calendar.class.isAssignableFrom(clazz)) {
                this.put(clazz, CalendarCodec.instance);
            } else if (Clob.class.isAssignableFrom(clazz)) {
                this.put(clazz, ClobSeriliazer.instance);
            } else {
                boolean isCglibProxy = false;
                boolean isJavassistProxy = false;
                for (Class<?> item : clazz.getInterfaces()) {
                    if (item.getName().equals("net.sf.cglib.proxy.Factory") || item.getName().equals("org.springframework.cglib.proxy.Factory")) {
                        isCglibProxy = true;
                        break;
                    }
                    if (!item.getName().equals("javassist.util.proxy.ProxyObject")) continue;
                    isJavassistProxy = true;
                    break;
                }
                if (isCglibProxy || isJavassistProxy) {
                    Class<?> clazz2 = clazz.getSuperclass();
                    ObjectSerializer superWriter = this.getObjectWriter(clazz2);
                    this.put(clazz, superWriter);
                    return superWriter;
                }
                if (Proxy.isProxyClass(clazz)) {
                    this.put(clazz, this.createJavaBeanSerializer(clazz));
                } else {
                    this.put(clazz, this.createJavaBeanSerializer(clazz));
                }
            }
            writer = (ObjectSerializer)this.get(clazz);
        }
        return writer;
    }
}

