/*
 * Decompiled with CFR 0.152.
 */
package com.kf5.support.controller;

import com.kf5.support.controller.DataSupport;
import com.kf5.support.internet.HttpRequest;
import com.kf5.support.model.IMAgentInfo;
import com.kf5.support.model.KF5Entity;
import com.kf5.support.model.MessageStatus;
import com.kf5.support.model.builder.EntityBuilder;
import com.kf5.support.model.builder.KF5EntityBuilder;
import com.kf5.support.util.AuthorizationUtil;
import com.kf5.support.util.Utils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.UUID;

class BaseCustomIMSupport
extends DataSupport {
    private static final long TIMESTAMP = System.currentTimeMillis() / 1000L;
    private static final String NONCE = UUID.randomUUID().toString();
    private static final String OAUTH_SIGNATURE_METHOD = "HMAC-SHA1";
    private static final float OAUTH_VERSION = 1.0f;
    private String appid;
    private String appkey;
    private String method;
    private String domain;

    BaseCustomIMSupport(String domian, String appid, String appkey, String method) {
        this.appid = (String)Utils.checkNotNull(appid, "appid can't be null");
        this.appkey = (String)Utils.checkNotNull(appkey, "appkey cant't be null");
        this.method = (String)Utils.checkNotNull(method, "method cant't be null");
        this.domain = (String)Utils.checkNotNull(domian, "domain can't be null");
    }

    protected MessageStatus sendPostRequest(String url, String param) {
        return HttpRequest.sendCustomIMPostRequest(url, this.getSecretKey(url), this.domain, param);
    }

    protected String uploadAttachment(String url, File file) {
        try {
            return HttpRequest.uploadCustomIMAttachment(url, file, this.getSecretKey(url), this.domain);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    protected KF5Entity<IMAgentInfo> buildIMAgentInfo(MessageStatus messageStatus) {
        IMAgentInfo imAgentInfo = null;
        if (this.getResultCode(messageStatus) == 0) {
            imAgentInfo = EntityBuilder.buildIMAgentInfo(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "data"));
        }
        return this.dealData(new KF5Entity(), imAgentInfo, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    private String getSecretKey(String url) {
        try {
            return AuthorizationUtil.generateAuthorizationHeader(this.appid, this.appkey, OAUTH_SIGNATURE_METHOD, TIMESTAMP, NONCE, 1.0f, null, null, null, url, null, this.method);
        }
        catch (IOException | URISyntaxException | GeneralSecurityException e) {
            e.printStackTrace();
            return "";
        }
    }
}

