/*
 * Decompiled with CFR 0.152.
 */
package com.kf5.support.controller;

import com.kf5.support.controller.DataSupport;
import com.kf5.support.internet.HttpRequest;
import com.kf5.support.model.AICategory;
import com.kf5.support.model.AIQuestionCategory;
import com.kf5.support.model.AITag;
import com.kf5.support.model.AgentConversationStatistics;
import com.kf5.support.model.AgentLog;
import com.kf5.support.model.AgentStatistics;
import com.kf5.support.model.AgentStatusTimeStatistics;
import com.kf5.support.model.AgentVoiceCallInbound;
import com.kf5.support.model.AgentVoiceCallOutbound;
import com.kf5.support.model.AgentVoiceCallSubsectionInbound;
import com.kf5.support.model.AgentVoiceCallSubsectionOutbound;
import com.kf5.support.model.AgentVoicePerformance;
import com.kf5.support.model.AgentVoiceStateTime;
import com.kf5.support.model.AgentVoiceStatus;
import com.kf5.support.model.AgentWorkStatusStatistics;
import com.kf5.support.model.Attachment;
import com.kf5.support.model.Automation;
import com.kf5.support.model.Category;
import com.kf5.support.model.Chat;
import com.kf5.support.model.ChatInfo;
import com.kf5.support.model.ChatSourceStatistics;
import com.kf5.support.model.Comment;
import com.kf5.support.model.DocumentStats;
import com.kf5.support.model.Forum;
import com.kf5.support.model.Group;
import com.kf5.support.model.KF5Entity;
import com.kf5.support.model.KF5PaginationEntity;
import com.kf5.support.model.MessageStatus;
import com.kf5.support.model.MonitorAgent;
import com.kf5.support.model.Organization;
import com.kf5.support.model.Post;
import com.kf5.support.model.PostComment;
import com.kf5.support.model.PostVote;
import com.kf5.support.model.Question;
import com.kf5.support.model.QuestionComment;
import com.kf5.support.model.QueueVisitorInfo;
import com.kf5.support.model.Requester;
import com.kf5.support.model.SystemLog;
import com.kf5.support.model.Ticket;
import com.kf5.support.model.TicketField;
import com.kf5.support.model.Topic;
import com.kf5.support.model.Trigger;
import com.kf5.support.model.User;
import com.kf5.support.model.UserField;
import com.kf5.support.model.View;
import com.kf5.support.model.ViewCount;
import com.kf5.support.model.VoiceAccount;
import com.kf5.support.model.VoiceAgentLoginState;
import com.kf5.support.model.VoiceCall;
import com.kf5.support.model.VoiceCallUnAnswered;
import com.kf5.support.model.VoiceQueueCall;
import com.kf5.support.model.builder.EntityBuilder;
import com.kf5.support.model.builder.KF5EntityBuilder;
import com.kf5.support.util.Base64Utils;
import java.util.ArrayList;
import java.util.List;
import org.kf5.support.fastjson.JSONArray;
import org.kf5.support.fastjson.JSONObject;

class BaseSupport
extends DataSupport {
    protected static final int RESULT_OK = 0;
    protected static final int RESULT_ERROR = -1;
    private String domain;
    private String username;
    private String password;
    private String token;
    protected String baseToken;

    BaseSupport() {
    }

    public void initWithPassword(String domain, String username, String password) {
        this.domain = domain;
        this.username = username;
        this.password = password;
        String code = this.username + ":" + this.password;
        this.baseToken = Base64Utils.encode(code);
    }

    public void initWithApiToken(String domain, String username, String apiToken) {
        this.domain = domain;
        this.username = username;
        this.token = apiToken;
        String code = this.username + "/token:" + this.token;
        this.baseToken = Base64Utils.encode(code);
    }

    protected void checkHasId(String ... ids) {
        if (ids != null) {
            int size = ids.length;
            for (int i = 0; i < size; ++i) {
                if (ids[i] != null && !ids[i].trim().equals("")) continue;
                throw new IllegalArgumentException("id can not be null");
            }
        } else {
            throw new IllegalArgumentException("id can not be null");
        }
    }

    protected void checkNotNull(String key) {
        if (key == null || key.trim().equals("")) {
            throw new IllegalArgumentException("key can not be null");
        }
    }

    protected MessageStatus sendGetRequest(String url) {
        this.checkBaseToken();
        return HttpRequest.sendGetRequest(url, this.baseToken);
    }

    protected MessageStatus sendPostRequest(String url, String params) {
        this.checkBaseToken();
        return HttpRequest.sendPostRequest(url, this.baseToken, params);
    }

    protected MessageStatus sendPutRequest(String url, String params) {
        this.checkBaseToken();
        return HttpRequest.sendPutRequest(url, this.baseToken, params);
    }

    protected MessageStatus sendDeleteRequest(String url) {
        this.checkBaseToken();
        return HttpRequest.sendDeleteRequest(url, this.baseToken);
    }

    protected MessageStatus sendDeleteRequest(String url, String params) {
        this.checkBaseToken();
        return HttpRequest.sendDeleteRequest(url, this.baseToken, params);
    }

    protected String getDomain() {
        return this.domain;
    }

    private void checkBaseToken() {
        if (this.baseToken == null) {
            throw new IllegalArgumentException("you must call the function named initWithPassword or initWithApiToken to init baseToken");
        }
    }

    protected KF5PaginationEntity<List<Chat>> buildPaginationChatList(MessageStatus messageStatus) {
        ArrayList<Chat> list = new ArrayList<Chat>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "chats");
            list.addAll(EntityBuilder.buildChatList(jsonArray));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<Ticket>> buildTicketList(MessageStatus messageStatus) {
        ArrayList<Ticket> list = new ArrayList<Ticket>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "tickets");
            list.addAll(EntityBuilder.buildTicketList(jsonArray));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<Ticket> buildTicket(MessageStatus messageStatus) {
        KF5Entity<Ticket> kf5Entity = new KF5Entity<Ticket>();
        this.buildTicket(messageStatus, kf5Entity);
        return kf5Entity;
    }

    protected void buildTicket(MessageStatus messageStatus, KF5Entity<Ticket> kf5Entity) {
        Ticket ticket = null;
        if (this.getResultCode(messageStatus) == 0) {
            ticket = EntityBuilder.buildTicket(EntityBuilder.safeObject(this.getResultObj(messageStatus), "ticket"));
        }
        this.dealData(kf5Entity, ticket, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<User>> buildUserList(MessageStatus messageStatus) {
        ArrayList<User> list = new ArrayList<User>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "users");
            list.addAll(EntityBuilder.buildUsers(jsonArray));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<Requester>> buildPaginationRequesterList(MessageStatus messageStatus) {
        ArrayList<Requester> list = new ArrayList<Requester>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "requests");
            list.addAll(EntityBuilder.buildRequesters(jsonArray));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<Requester> buildRequester(MessageStatus messageStatus) {
        KF5Entity<Requester> kf5Entity = new KF5Entity<Requester>();
        this.buildRequester(kf5Entity, messageStatus);
        return kf5Entity;
    }

    protected void buildRequester(KF5Entity<Requester> kf5Entity, MessageStatus messageStatus) {
        Requester requester = null;
        if (this.getResultCode(messageStatus) == 0) {
            requester = EntityBuilder.buildRequester(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "request"));
        }
        this.dealData(kf5Entity, requester, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected <T> void dealErrorData(KF5Entity<T> kf5Entity, String message) {
        kf5Entity.setResultCode(-1);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)-1);
        jsonObject.put("message", (Object)message);
        kf5Entity.setMessage(jsonObject.toString());
    }

    protected KF5PaginationEntity<List<Comment>> buildPaginationListComment(MessageStatus messageStatus) {
        ArrayList<Comment> list = new ArrayList<Comment>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "comments");
            list.addAll(EntityBuilder.buildComments(jsonArray));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<Comment> buildComment(MessageStatus messageStatus) {
        Comment comment = null;
        if (this.getResultCode(messageStatus) == 0) {
            comment = EntityBuilder.buildComment(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "comment"));
        }
        return this.dealData(new KF5Entity(), comment, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<TicketField>> buildPaginationTicketFieldList(MessageStatus messageStatus) {
        ArrayList<TicketField> list = new ArrayList<TicketField>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "ticket_fields");
            list.addAll(EntityBuilder.buildTicketFields(jsonArray));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<TicketField> buildTicketField(MessageStatus messageStatus) {
        TicketField ticketField = null;
        if (this.getResultCode(messageStatus) == 0) {
            ticketField = EntityBuilder.buildTicketField(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "ticket_field"));
        }
        return this.dealData(new KF5Entity(), ticketField, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<View>> buildPaginationOrderTypeList(MessageStatus messageStatus) {
        ArrayList<View> list = new ArrayList<View>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "views");
            list.addAll(EntityBuilder.buildViews(jsonArray));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<View> buildOrderType(MessageStatus messageStatus) {
        View view = null;
        if (this.getResultCode(messageStatus) == 0) {
            view = EntityBuilder.buildView(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "view"));
        }
        return this.dealData(new KF5Entity(), view, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<Ticket>> buildPaginationTicketList(MessageStatus messageStatus) {
        ArrayList<Ticket> list = new ArrayList<Ticket>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "tickets");
            list.addAll(EntityBuilder.buildTicketList(jsonArray));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<ViewCount> buildViewCount(MessageStatus messageStatus) {
        ViewCount viewCount = null;
        if (this.getResultCode(messageStatus) == 0) {
            viewCount = EntityBuilder.buildViewCount(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "view_count"));
        }
        return this.dealData(new KF5Entity(), viewCount, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<ViewCount>> buildListViewCount(MessageStatus messageStatus) {
        ArrayList<ViewCount> list = new ArrayList<ViewCount>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "view_counts");
            list.addAll(EntityBuilder.buildViewCounts(jsonArray));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<User>> buildPaginationUserList(MessageStatus messageStatus) {
        ArrayList<User> list = new ArrayList<User>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "users");
            list.addAll(EntityBuilder.buildUsers(jsonArray));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<User> buildUser(MessageStatus messageStatus) {
        KF5Entity<User> kf5Entity = new KF5Entity<User>();
        this.buildUser(kf5Entity, messageStatus);
        return kf5Entity;
    }

    protected void buildUser(KF5Entity<User> kf5Entity, MessageStatus messageStatus) {
        User user = null;
        if (this.getResultCode(messageStatus) == 0) {
            user = EntityBuilder.buildUser(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "user"));
        }
        this.dealData(kf5Entity, user, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<UserField>> buildPaginationUserFieldList(MessageStatus messageStatus) {
        ArrayList<UserField> list = new ArrayList<UserField>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "user_fields");
            list.addAll(EntityBuilder.buildUserFields(jsonArray));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<UserField> buildUserField(MessageStatus messageStatus) {
        UserField userField = null;
        if (this.getResultCode(messageStatus) == 0) {
            userField = EntityBuilder.buildUserField(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "user_field"));
        }
        return this.dealData(new KF5Entity(), userField, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<Group>> buildGroupList(MessageStatus messageStatus) {
        ArrayList<Group> list = new ArrayList<Group>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "groups");
            list.addAll(EntityBuilder.buildGroups(jsonArray));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<Group> buildGroup(MessageStatus messageStatus) {
        KF5Entity<Group> kf5Entity = new KF5Entity<Group>();
        this.buildGroup(messageStatus, kf5Entity);
        return kf5Entity;
    }

    protected void buildGroup(MessageStatus messageStatus, KF5Entity<Group> kf5Entity) {
        Group group = null;
        if (this.getResultCode(messageStatus) == 0) {
            group = EntityBuilder.buildGroup(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "group"));
        }
        this.dealData(kf5Entity, group, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<Organization>> buildPaginationOrganizationList(MessageStatus messageStatus) {
        ArrayList<Organization> list = new ArrayList<Organization>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "organizations");
            list.addAll(EntityBuilder.buildOrganizations(jsonArray));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<Organization> buildOrganization(MessageStatus messageStatus) {
        KF5Entity<Organization> kf5Entity = new KF5Entity<Organization>();
        this.buildOrganization(messageStatus, kf5Entity);
        return kf5Entity;
    }

    protected void buildOrganization(MessageStatus messageStatus, KF5Entity<Organization> kf5Entity) {
        Organization organization = null;
        if (this.getResultCode(messageStatus) == 0) {
            organization = EntityBuilder.buildOrganization(KF5EntityBuilder.getJsonObject(this.getResultObj(messageStatus), "organization"));
        }
        this.dealData(kf5Entity, organization, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<Topic>> buildPaginationTopicList(MessageStatus messageStatus) {
        ArrayList<Topic> list = new ArrayList<Topic>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "topics");
            list.addAll(EntityBuilder.buildTopics(jsonArray));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<Topic> buildTopic(MessageStatus messageStatus) {
        KF5Entity<Topic> kf5Entity = new KF5Entity<Topic>();
        this.buildTopic(messageStatus, kf5Entity);
        return kf5Entity;
    }

    protected void buildTopic(MessageStatus messageStatus, KF5Entity<Topic> kf5Entity) {
        Topic topic = null;
        if (this.getResultCode(messageStatus) == 0) {
            topic = EntityBuilder.buildTopic(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "topic"));
        }
        this.dealData(kf5Entity, topic, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<Question>> buildPaginationQuestionList(MessageStatus messageStatus) {
        ArrayList<Question> list = new ArrayList<Question>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "questions");
            list.addAll(EntityBuilder.buildQuestions(jsonArray));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<Question> buildQuestion(MessageStatus messageStatus) {
        KF5Entity<Question> kf5Entity = new KF5Entity<Question>();
        this.buildQuestion(messageStatus, kf5Entity);
        return kf5Entity;
    }

    protected void buildQuestion(MessageStatus messageStatus, KF5Entity<Question> kf5Entity) {
        Question question = null;
        if (this.getResultCode(messageStatus) == 0) {
            question = EntityBuilder.buildQuestion(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "question"));
        }
        this.dealData(kf5Entity, question, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<QuestionComment>> buildPaginationQuestionCommentList(MessageStatus messageStatus) {
        KF5PaginationEntity<List<QuestionComment>> kf5Entity = new KF5PaginationEntity<List<QuestionComment>>();
        this.buildPaginationQuestionCommentList(messageStatus, kf5Entity);
        return kf5Entity;
    }

    protected void buildPaginationQuestionCommentList(MessageStatus messageStatus, KF5PaginationEntity<List<QuestionComment>> kf5Entity) {
        ArrayList<QuestionComment> list = new ArrayList<QuestionComment>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "question_comments");
            list.addAll(EntityBuilder.buildQuestionComments(jsonArray));
        }
        this.dealPaginationListData(kf5Entity, list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<QuestionComment> buildQuestionComment(MessageStatus messageStatus) {
        QuestionComment questionComment = null;
        if (this.getResultCode(messageStatus) == 0) {
            questionComment = EntityBuilder.buildQuestionComment(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "question_comment"));
        }
        return this.dealData(new KF5Entity(), questionComment, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<Category>> buildPaginationCategoriesList(MessageStatus messageStatus) {
        ArrayList<Category> list = new ArrayList<Category>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "categories");
            list.addAll(EntityBuilder.buildCategories(jsonArray));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<Category> buildCategory(MessageStatus messageStatus) {
        KF5Entity<Category> kf5Entity = new KF5Entity<Category>();
        this.buildCategory(messageStatus, kf5Entity);
        return kf5Entity;
    }

    protected void buildCategory(MessageStatus messageStatus, KF5Entity<Category> kf5Entity) {
        Category category = null;
        if (this.getResultCode(messageStatus) == 0) {
            category = EntityBuilder.buildCategory(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "category"));
        }
        this.dealData(kf5Entity, category, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<Forum>> buildPaginationForumList(MessageStatus messageStatus) {
        ArrayList<Forum> list = new ArrayList<Forum>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "forums");
            list.addAll(EntityBuilder.buildForums(jsonArray));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<Forum> buildForum(MessageStatus messageStatus) {
        KF5Entity<Forum> kf5Entity = new KF5Entity<Forum>();
        this.buildForum(messageStatus, kf5Entity);
        return kf5Entity;
    }

    protected void buildForum(MessageStatus messageStatus, KF5Entity<Forum> kf5Entity) {
        Forum forum = null;
        if (this.getResultCode(messageStatus) == 0) {
            forum = EntityBuilder.buildForum(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "forum"));
        }
        this.dealData(kf5Entity, forum, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<Post>> buildPaginationPostList(MessageStatus messageStatus) {
        ArrayList<Post> list = new ArrayList<Post>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "posts");
            list.addAll(EntityBuilder.buildPosts(jsonArray));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<Post> buildPost(MessageStatus messageStatus) {
        KF5Entity<Post> kf5Entity = new KF5Entity<Post>();
        this.buildPost(messageStatus, kf5Entity);
        return kf5Entity;
    }

    protected void buildPost(MessageStatus messageStatus, KF5Entity<Post> kf5Entity) {
        Post post = null;
        if (this.getResultCode(messageStatus) == 0) {
            post = EntityBuilder.buildPost(KF5EntityBuilder.getJsonObject(this.getResultObj(messageStatus), "post"));
        }
        this.dealData(kf5Entity, post, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<Post>> buildListPost(MessageStatus messageStatus) {
        ArrayList<Post> list = new ArrayList<Post>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "posts");
            list.addAll(EntityBuilder.buildPosts(jsonArray));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<PostComment>> buildPaginationPostCommentList(MessageStatus messageStatus) {
        ArrayList<PostComment> list = new ArrayList<PostComment>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "post_comments");
            list.addAll(EntityBuilder.buildPostComments(jsonArray));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<PostComment> buildPostComment(MessageStatus messageStatus) {
        PostComment postComment = null;
        if (this.getResultCode(messageStatus) == 0) {
            postComment = EntityBuilder.buildPostComment(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "post_comment"));
        }
        return this.dealData(new KF5Entity(), postComment, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<Attachment> buildAttachment(MessageStatus messageStatus) {
        Attachment attachment = null;
        if (this.getResultCode(messageStatus) == 0) {
            attachment = EntityBuilder.buildAttachment(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "attachment"));
        }
        return this.dealData(new KF5Entity(), attachment, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<String> buildResultWithString(MessageStatus messageStatus) {
        KF5Entity<String> kf5Entity = new KF5Entity<String>();
        this.buildResultWithString(messageStatus, kf5Entity);
        return kf5Entity;
    }

    protected void buildResultWithString(MessageStatus messageStatus, KF5Entity<String> kf5Entity) {
        kf5Entity.setResultCode(messageStatus.getStatus());
        JSONObject jsonObject = messageStatus.getJsonObject();
        if (jsonObject != null) {
            if (messageStatus.getStatus() == 0) {
                kf5Entity.setData(jsonObject.toString());
            } else {
                kf5Entity.setMessage(jsonObject.toString());
            }
        }
    }

    protected KF5Entity<Chat> buildChat(MessageStatus messageStatus) {
        Chat chat = null;
        if (this.getResultCode(messageStatus) == 0) {
            chat = EntityBuilder.buildChat(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "chat"));
        }
        return this.dealData(new KF5Entity(), chat, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<AICategory>> buildPaginationListAICategory(MessageStatus messageStatus) {
        KF5PaginationEntity<List<AICategory>> kf5Entity = new KF5PaginationEntity<List<AICategory>>();
        this.buildPaginationListAICategory(messageStatus, kf5Entity);
        return kf5Entity;
    }

    protected void buildPaginationListAICategory(MessageStatus messageStatus, KF5PaginationEntity<List<AICategory>> kf5Entity) {
        ArrayList<AICategory> list = new ArrayList<AICategory>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "rows");
            list.addAll(EntityBuilder.buildAICategoryList(jsonArray));
        }
        this.dealPaginationListData(kf5Entity, list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<AICategory> buildAICategory(MessageStatus messageStatus) {
        AICategory aiCategory = null;
        if (this.getResultCode(messageStatus) == 0) {
            aiCategory = EntityBuilder.buildAiCategory(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "data"));
        }
        return this.dealData(new KF5Entity(), aiCategory, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<AIQuestionCategory>> buildPaginationAIQuestionCategoryList(MessageStatus messageStatus) {
        ArrayList<AIQuestionCategory> list = new ArrayList<AIQuestionCategory>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "rows");
            list.addAll(EntityBuilder.buildAIQuestionCategoryList(jsonArray));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<AIQuestionCategory> buildAIQuestionCategory(MessageStatus messageStatus) {
        AIQuestionCategory aiQuestionCategory = null;
        if (this.getResultCode(messageStatus) == 0) {
            aiQuestionCategory = EntityBuilder.buildAIQuestionCategory(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "data"));
        }
        return this.dealData(new KF5Entity(), aiQuestionCategory, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<Trigger> buildTrigger(MessageStatus messageStatus) {
        Trigger trigger = null;
        if (this.getResultCode(messageStatus) == 0) {
            trigger = EntityBuilder.buildTrigger(KF5EntityBuilder.getJsonObject(this.getResultObj(messageStatus), "trigger"));
        }
        return this.dealData(new KF5Entity(), trigger, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<Trigger>> buildTriggerList(MessageStatus messageStatus) {
        ArrayList<Trigger> list = new ArrayList<Trigger>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "triggers");
            list.addAll(EntityBuilder.buildTriggerList(jsonArray));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<Automation> buildAutomation(MessageStatus messageStatus) {
        Automation automation = null;
        if (this.getResultCode(messageStatus) == 0) {
            automation = EntityBuilder.buildAutomation(KF5EntityBuilder.getJsonObject(this.getResultObj(messageStatus), "automation"));
        }
        return this.dealData(new KF5Entity(), automation, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<Automation>> buildAutomationList(MessageStatus messageStatus) {
        ArrayList<Automation> list = new ArrayList<Automation>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "automations");
            list.addAll(EntityBuilder.buildAutomationList(jsonArray));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<AgentLog>> buildAgentLogList(MessageStatus messageStatus) {
        ArrayList<AgentLog> agentLogs = new ArrayList<AgentLog>();
        if (this.getResultCode(messageStatus) == 0) {
            agentLogs.addAll(EntityBuilder.buildAgentLogList(KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "logs")));
        }
        return this.dealData(new KF5Entity(), agentLogs, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<AITag>> buildAITagList(MessageStatus messageStatus) {
        ArrayList<AITag> list = new ArrayList<AITag>();
        if (this.getResultCode(messageStatus) == 0) {
            list.addAll(EntityBuilder.buildAITagList(KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "rows")));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<MonitorAgent> buildMonitorAgent(MessageStatus messageStatus) {
        MonitorAgent monitorAgent = null;
        if (this.getResultCode(messageStatus) == 0) {
            monitorAgent = EntityBuilder.buildMonitorAgent(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "stats"));
        }
        return this.dealData(new KF5Entity(), monitorAgent, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<ChatInfo>> buildChatInfoList(MessageStatus messageStatus) {
        ArrayList<ChatInfo> list = new ArrayList<ChatInfo>();
        if (this.getResultCode(messageStatus) == 0) {
            list.addAll(EntityBuilder.buildChatInfoList(KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "chats")));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<QueueVisitorInfo>> buildQueueVisitorInfoList(MessageStatus messageStatus) {
        ArrayList<QueueVisitorInfo> list = new ArrayList<QueueVisitorInfo>();
        if (this.getResultCode(messageStatus) == 0) {
            list.addAll(EntityBuilder.buildQueueVisitorInfoList(KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "visitors")));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<AgentWorkStatusStatistics> buildAgentWorkStatusStatistics(MessageStatus messageStatus) {
        AgentWorkStatusStatistics statistics = null;
        if (this.getResultCode(messageStatus) == 0) {
            statistics = EntityBuilder.buildAgentWorkStatusStatistics(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "stats"));
        }
        return this.dealData(new KF5Entity(), statistics, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<AgentConversationStatistics> buildAgentConversationStatistics(MessageStatus messageStatus) {
        AgentConversationStatistics statistics = null;
        if (this.getResultCode(messageStatus) == 0) {
            statistics = EntityBuilder.buildAgentConversationStatistics(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "stats"));
        }
        return this.dealData(new KF5Entity(), statistics, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<AgentStatusTimeStatistics> buildAgentStatusTimeStatistics(MessageStatus messageStatus) {
        AgentStatusTimeStatistics statistics = null;
        if (this.getResultCode(messageStatus) == 0) {
            statistics = EntityBuilder.buildAgentStatusTimeStatistics(this.getResultObj(messageStatus));
        }
        return this.dealData(new KF5Entity(), statistics, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<ChatSourceStatistics> buildChatSourceStatistics(MessageStatus messageStatus) {
        ChatSourceStatistics statistics = null;
        if (this.getResultCode(messageStatus) == 0) {
            statistics = EntityBuilder.buildChatSourceStatistics(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "stats"));
        }
        return this.dealData(new KF5Entity(), statistics, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<AgentStatistics> buildAgentStatistics(MessageStatus messageStatus) {
        AgentStatistics statistics = null;
        if (this.getResultCode(messageStatus) == 0) {
            statistics = EntityBuilder.buildAgentStatistics(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "agent"));
        }
        return this.dealData(new KF5Entity(), statistics, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<VoiceCall>> buildVoiceCallList(MessageStatus messageStatus) {
        ArrayList<VoiceCall> list = new ArrayList<VoiceCall>();
        if (this.getResultCode(messageStatus) == 0) {
            list.addAll(EntityBuilder.buildVoiceCallList(KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "histories")));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<VoiceCall> buildVoiceCall(MessageStatus messageStatus) {
        VoiceCall voiceCall = null;
        if (this.getResultCode(messageStatus) == 0) {
            voiceCall = EntityBuilder.buildVoiceCall(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "history"));
        }
        return this.dealData(new KF5Entity(), voiceCall, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<VoiceAccount>> buildVoiceAccountList(MessageStatus messageStatus) {
        ArrayList<VoiceAccount> list = new ArrayList<VoiceAccount>();
        if (this.getResultCode(messageStatus) == 0) {
            list.addAll(EntityBuilder.buildVoiceAccountList(KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "agents")));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<VoiceAccount> buildVoiceAccount(MessageStatus messageStatus) {
        VoiceAccount voiceAccount = null;
        if (this.getResultCode(messageStatus) == 0) {
            voiceAccount = EntityBuilder.buildVoiceAccount(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "agent"));
        }
        return this.dealData(new KF5Entity(), voiceAccount, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<VoiceAgentLoginState>> buildVoiceAgentLoginStateList(MessageStatus messageStatus) {
        ArrayList<VoiceAgentLoginState> list = new ArrayList<VoiceAgentLoginState>();
        if (this.getResultCode(messageStatus) == 0) {
            list.addAll(EntityBuilder.buildVoiceAgentLoginStateList(KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "agent_state_logs")));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<VoiceCallUnAnswered>> buildVoiceCallUnAnsweredList(MessageStatus messageStatus) {
        ArrayList<VoiceCallUnAnswered> list = new ArrayList<VoiceCallUnAnswered>();
        if (this.getResultCode(messageStatus) == 0) {
            list.addAll(EntityBuilder.buildVoiceCallUnAnsweredList(KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "unanswered")));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<AgentVoiceCallOutbound>> buildAgentVoiceCallOutboundList(MessageStatus messageStatus) {
        ArrayList<AgentVoiceCallOutbound> list = new ArrayList<AgentVoiceCallOutbound>();
        if (this.getResultCode(messageStatus) == 0) {
            list.addAll(EntityBuilder.buildAgentVoiceCallOutboundList(KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "agent_outbound_stats")));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<AgentVoiceCallInbound>> buildAgentVoiceCallInboundList(MessageStatus messageStatus) {
        ArrayList<AgentVoiceCallInbound> list = new ArrayList<AgentVoiceCallInbound>();
        if (this.getResultCode(messageStatus) == 0) {
            list.addAll(EntityBuilder.buildAgentVoiceCallInboundList(KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "agent_inbound_stats")));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<AgentVoicePerformance>> buildAgentVoicePerformanceList(MessageStatus messageStatus) {
        ArrayList<AgentVoicePerformance> list = new ArrayList<AgentVoicePerformance>();
        if (this.getResultCode(messageStatus) == 0) {
            list.addAll(EntityBuilder.buildAgentVoicePerformanceList(KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "agent_performance_stats")));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<AgentVoiceStateTime>> buildAgentVoiceStateTimeList(MessageStatus messageStatus) {
        ArrayList<AgentVoiceStateTime> list = new ArrayList<AgentVoiceStateTime>();
        if (this.getResultCode(messageStatus) == 0) {
            list.addAll(EntityBuilder.buildAgentVoiceStateTimeList(KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "agent_state_stats")));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<AgentVoiceCallSubsectionInbound>> buildAgentVoiceCallSubsectionInboundList(MessageStatus messageStatus) {
        ArrayList<AgentVoiceCallSubsectionInbound> list = new ArrayList<AgentVoiceCallSubsectionInbound>();
        if (this.getResultCode(messageStatus) == 0) {
            list.addAll(EntityBuilder.buildAgentVoiceCallSubsectionInboundList(KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "inbound_stats")));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<AgentVoiceCallSubsectionOutbound>> buildAgentVoiceCallSubsectionOutboundList(MessageStatus messageStatus) {
        ArrayList<AgentVoiceCallSubsectionOutbound> list = new ArrayList<AgentVoiceCallSubsectionOutbound>();
        if (this.getResultCode(messageStatus) == 0) {
            list.addAll(EntityBuilder.buildAgentVoiceCallSubsectionOutboundList(KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "outbound_stats")));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<VoiceQueueCall>> buildVoiceQueueCallList(MessageStatus messageStatus) {
        ArrayList<VoiceQueueCall> list = new ArrayList<VoiceQueueCall>();
        if (this.getResultCode(messageStatus) == 0) {
            list.addAll(EntityBuilder.buildVoiceQueueCallList(KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "queue_calls")));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<AgentVoiceStatus>> buildAgentVoiceStatusList(MessageStatus messageStatus) {
        ArrayList<AgentVoiceStatus> list = new ArrayList<AgentVoiceStatus>();
        if (this.getResultCode(messageStatus) == 0) {
            list.addAll(EntityBuilder.buildAgentVoiceStatusList(KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "availabilities")));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<AgentVoiceStatus> buildAgentVoiceStatus(MessageStatus messageStatus) {
        AgentVoiceStatus status = null;
        if (this.getResultCode(messageStatus) == 0) {
            status = EntityBuilder.buildAgentVoiceStatus(KF5EntityBuilder.safeObject(this.getResultObj(messageStatus), "availability"));
        }
        return this.dealData(new KF5Entity(), status, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5PaginationEntity<List<SystemLog>> buildSystemLogList(MessageStatus messageStatus) {
        ArrayList<SystemLog> list = new ArrayList<SystemLog>();
        if (this.getResultCode(messageStatus) == 0) {
            list.addAll(EntityBuilder.buildSystemLogList(KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "system_log")));
        }
        return this.dealPaginationListData(new KF5PaginationEntity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected <T> KF5Entity<T> dealBaseMessage(KF5Entity<T> entity, MessageStatus messageStatus) {
        entity.setResultCode(messageStatus.getStatus());
        entity.setMessage(KF5EntityBuilder.safeGet(messageStatus.getJsonObject(), "message"));
        return entity;
    }

    protected KF5Entity<List<DocumentStats>> buildDocumentStatsList(MessageStatus messageStatus) {
        ArrayList<DocumentStats> list = new ArrayList<DocumentStats>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "posts_list");
            list.addAll(EntityBuilder.buildDocumentStatsList(jsonArray));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }

    protected KF5Entity<List<PostVote>> buildPostVoteList(MessageStatus messageStatus) {
        ArrayList<PostVote> list = new ArrayList<PostVote>();
        if (this.getResultCode(messageStatus) == 0) {
            JSONArray jsonArray = KF5EntityBuilder.safeArray(this.getResultObj(messageStatus), "post_vote_users");
            list.addAll(EntityBuilder.buildPostVoteList(jsonArray));
        }
        return this.dealData(new KF5Entity(), list, this.getResultObj(messageStatus), this.getResultCode(messageStatus));
    }
}

