/*
 * Decompiled with CFR 0.152.
 */
package com.kf5.support.internet;

import com.kf5.support.model.MessageStatus;
import com.kf5.support.model.builder.KF5EntityBuilder;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.kf5.support.fastjson.JSONObject;

public class HttpRequest {
    private static final String MESSAGE = "message";
    private static final String CODE = "code";
    private static final int ERROR_CODE = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageStatus sendGetRequest(String url, String baseToken) {
        System.out.println("\u8bf7\u6c42\u5730\u5740" + url);
        MessageStatus messageStatus = new MessageStatus();
        HttpURLConnection connection = null;
        try {
            URL realUrl = new URL(url);
            connection = (HttpURLConnection)realUrl.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setConnectTimeout(10000);
            connection.setRequestProperty("Authorization", "Basic " + baseToken);
            System.out.println("Basic " + baseToken);
            connection.connect();
            if (connection.getResponseCode() == 200) {
                messageStatus.setStatus(0);
                messageStatus.setJsonObject(KF5EntityBuilder.safeObject(HttpRequest.getInputStream(connection.getInputStream())));
            } else {
                messageStatus.setStatus(connection.getResponseCode());
                messageStatus.setJsonObject(KF5EntityBuilder.safeObject(HttpRequest.getInputStream(connection.getErrorStream())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(CODE, (Object)-1);
            jsonObject.put(MESSAGE, (Object)e.getMessage());
            messageStatus.setStatus(-1);
            messageStatus.setJsonObject(jsonObject);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        System.out.println("\u8fd4\u56de\u503c" + messageStatus.getJsonObject().toJSONString());
        return messageStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageStatus sendDeleteRequest(String url, String baseToken) {
        MessageStatus messageStatus = new MessageStatus();
        HttpURLConnection connection = null;
        try {
            URL realUrl = new URL(url);
            connection = (HttpURLConnection)realUrl.openConnection();
            connection.setRequestMethod("DELETE");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setConnectTimeout(10000);
            connection.setRequestProperty("Authorization", "Basic " + baseToken);
            connection.connect();
            if (connection.getResponseCode() == 200) {
                messageStatus.setStatus(0);
                messageStatus.setJsonObject(KF5EntityBuilder.safeObject(HttpRequest.getInputStream(connection.getInputStream())));
                System.out.println("\u5220\u9664\u6210\u529f" + connection.getResponseCode());
            } else {
                System.out.println("\u5220\u9664\u5931\u8d25" + connection.getResponseCode());
                messageStatus.setStatus(connection.getResponseCode());
                messageStatus.setJsonObject(KF5EntityBuilder.safeObject(HttpRequest.getInputStream(connection.getErrorStream())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(CODE, (Object)-1);
            jsonObject.put(MESSAGE, (Object)e.getMessage());
            messageStatus.setStatus(-1);
            messageStatus.setJsonObject(jsonObject);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return messageStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageStatus sendDeleteRequest(String url, String baseToken, String param) {
        MessageStatus messageStatus = new MessageStatus();
        HttpURLConnection connection = null;
        try {
            URL realUrl = new URL(url);
            connection = (HttpURLConnection)realUrl.openConnection();
            connection.setRequestMethod("DELETE");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setConnectTimeout(10000);
            connection.setRequestProperty("Authorization", "Basic " + baseToken);
            connection.connect();
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.write(param.getBytes("utf-8"));
            out.flush();
            out.close();
            if (connection.getResponseCode() == 200) {
                messageStatus.setStatus(0);
                messageStatus.setJsonObject(KF5EntityBuilder.safeObject(HttpRequest.getInputStream(connection.getInputStream())));
            } else {
                messageStatus.setStatus(connection.getResponseCode());
                messageStatus.setJsonObject(KF5EntityBuilder.safeObject(HttpRequest.getInputStream(connection.getErrorStream())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put(CODE, (Object)-1);
            jsonObject.put(MESSAGE, (Object)e.getMessage());
            messageStatus.setStatus(-1);
            messageStatus.setJsonObject(jsonObject);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return messageStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageStatus sendPostRequest(String url, String baseToken, String param) {
        JSONObject jsonObject;
        System.out.println("\u8bf7\u6c42\u7684url" + url);
        System.out.println("\u8bf7\u6c42\u53c2\u6570" + param);
        MessageStatus messageStatus = new MessageStatus();
        FilterOutputStream out = null;
        HttpURLConnection connection = null;
        try {
            URL realUrl = new URL(url);
            connection = (HttpURLConnection)realUrl.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setConnectTimeout(10000);
            connection.setRequestProperty("Authorization", "Basic " + baseToken);
            connection.connect();
            out = new DataOutputStream(connection.getOutputStream());
            out.write(param.getBytes("utf-8"));
            ((DataOutputStream)out).flush();
            out.close();
            if (connection.getResponseCode() == 200 || connection.getResponseCode() == 201) {
                messageStatus.setStatus(0);
                messageStatus.setJsonObject(KF5EntityBuilder.safeObject(HttpRequest.getInputStream(connection.getInputStream())));
            } else {
                messageStatus.setStatus(connection.getResponseCode());
                messageStatus.setJsonObject(KF5EntityBuilder.safeObject(HttpRequest.getInputStream(connection.getErrorStream())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            jsonObject = new JSONObject();
            jsonObject.put(CODE, (Object)-1);
            jsonObject.put(MESSAGE, (Object)e.getMessage());
            messageStatus.setStatus(-1);
            messageStatus.setJsonObject(jsonObject);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                jsonObject = new JSONObject();
                jsonObject.put(CODE, (Object)-1);
                jsonObject.put(MESSAGE, (Object)e2.getMessage());
                messageStatus.setStatus(-1);
                messageStatus.setJsonObject(jsonObject);
            }
        }
        System.out.println(messageStatus.getStatus() + "\u72b6\u6001\u7801");
        System.out.println("\u8fd4\u56de\u503c" + messageStatus.getJsonObject().toJSONString());
        return messageStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageStatus sendPutRequest(String url, String baseToken, String param) {
        JSONObject jsonObject;
        MessageStatus messageStatus = new MessageStatus();
        FilterOutputStream out = null;
        HttpURLConnection connection = null;
        try {
            URL realUrl = new URL(url);
            connection = (HttpURLConnection)realUrl.openConnection();
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setConnectTimeout(10000);
            connection.setRequestProperty("Authorization", "Basic " + baseToken);
            connection.connect();
            out = new DataOutputStream(connection.getOutputStream());
            out.write(param.getBytes("utf-8"));
            ((DataOutputStream)out).flush();
            out.close();
            if (connection.getResponseCode() == 200) {
                messageStatus.setStatus(0);
                messageStatus.setJsonObject(KF5EntityBuilder.safeObject(HttpRequest.getInputStream(connection.getInputStream())));
            } else {
                messageStatus.setStatus(connection.getResponseCode());
                messageStatus.setJsonObject(KF5EntityBuilder.safeObject(HttpRequest.getInputStream(connection.getErrorStream())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            jsonObject = new JSONObject();
            jsonObject.put(CODE, (Object)-1);
            jsonObject.put(MESSAGE, (Object)e.getMessage());
            messageStatus.setStatus(-1);
            messageStatus.setJsonObject(jsonObject);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                jsonObject = new JSONObject();
                jsonObject.put(CODE, (Object)-1);
                jsonObject.put(MESSAGE, (Object)e2.getMessage());
                messageStatus.setStatus(-1);
                messageStatus.setJsonObject(jsonObject);
            }
        }
        System.out.println("PUT\u8bf7\u6c42\u8fd4\u56de\u503c" + messageStatus.getJsonObject().toJSONString());
        return messageStatus;
    }

    public static String uploadAttachment(String url, File file, String baseToken) throws Exception {
        URL uri = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)uri.openConnection();
        conn.setReadTimeout(10000);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("connection", "keep-alive");
        conn.setRequestProperty("Charsert", "UTF-8");
        conn.setRequestProperty("Content-Type", "application/binary");
        conn.setRequestProperty("Authorization", "Basic " + baseToken);
        DataOutputStream outStream = new DataOutputStream(conn.getOutputStream());
        if (file != null) {
            FileInputStream is = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = ((InputStream)is).read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            ((InputStream)is).close();
        }
        outStream.flush();
        int res = conn.getResponseCode();
        String result = "";
        result = res == 200 || res == 201 ? HttpRequest.getInputStream(conn.getInputStream()) : HttpRequest.getInputStream(conn.getErrorStream());
        outStream.close();
        conn.disconnect();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageStatus sendCustomIMPostRequest(String url, String baseToken, String domain, String param) {
        JSONObject jsonObject;
        MessageStatus messageStatus = new MessageStatus();
        FilterOutputStream out = null;
        HttpURLConnection connection = null;
        try {
            URL realUrl = new URL(url);
            connection = (HttpURLConnection)realUrl.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setConnectTimeout(10000);
            connection.setRequestProperty("Authorization", baseToken);
            connection.setRequestProperty("KF5-Domain", domain);
            connection.connect();
            out = new DataOutputStream(connection.getOutputStream());
            out.write(param.getBytes("utf-8"));
            ((DataOutputStream)out).flush();
            out.close();
            if (connection.getResponseCode() == 200 || connection.getResponseCode() == 201) {
                messageStatus.setStatus(0);
                messageStatus.setJsonObject(KF5EntityBuilder.safeObject(HttpRequest.getInputStream(connection.getInputStream())));
            } else {
                messageStatus.setStatus(connection.getResponseCode());
                messageStatus.setJsonObject(KF5EntityBuilder.safeObject(HttpRequest.getInputStream(connection.getErrorStream())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            jsonObject = new JSONObject();
            jsonObject.put(CODE, (Object)-1);
            jsonObject.put(MESSAGE, (Object)e.getMessage());
            messageStatus.setStatus(-1);
            messageStatus.setJsonObject(jsonObject);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
                jsonObject = new JSONObject();
                jsonObject.put(CODE, (Object)-1);
                jsonObject.put(MESSAGE, (Object)e2.getMessage());
                messageStatus.setStatus(-1);
                messageStatus.setJsonObject(jsonObject);
            }
        }
        return messageStatus;
    }

    public static String uploadCustomIMAttachment(String url, File file, String baseToken, String domain) throws Exception {
        URL uri = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)uri.openConnection();
        conn.setReadTimeout(10000);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("connection", "keep-alive");
        conn.setRequestProperty("Charsert", "UTF-8");
        conn.setRequestProperty("Content-Type", "application/binary");
        conn.setRequestProperty("Authorization", baseToken);
        conn.setRequestProperty("KF5-Domain", domain);
        DataOutputStream outStream = new DataOutputStream(conn.getOutputStream());
        if (file != null) {
            FileInputStream is = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = ((InputStream)is).read(buffer)) != -1) {
                outStream.write(buffer, 0, len);
            }
            ((InputStream)is).close();
        }
        outStream.flush();
        int res = conn.getResponseCode();
        String result = "";
        result = res == 200 || res == 201 ? HttpRequest.getInputStream(conn.getInputStream()) : HttpRequest.getInputStream(conn.getErrorStream());
        outStream.close();
        conn.disconnect();
        return result;
    }

    private static String getInputStream(InputStream stream) throws Exception {
        String line;
        if (stream == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new InputStreamReader(stream, "utf-8"));
        while ((line = bufferedReader.readLine()) != null) {
            sb.append(line);
        }
        bufferedReader.close();
        return sb.toString();
    }
}

