/*
 * Decompiled with CFR 0.152.
 */
package com.kf5.support.model.builder;

import com.kf5.support.model.AICategory;
import com.kf5.support.model.AIQuestionCategory;
import com.kf5.support.model.AITag;
import com.kf5.support.model.Action;
import com.kf5.support.model.Agent;
import com.kf5.support.model.AgentConversation;
import com.kf5.support.model.AgentConversationOverview;
import com.kf5.support.model.AgentConversationStatistics;
import com.kf5.support.model.AgentLog;
import com.kf5.support.model.AgentOverview;
import com.kf5.support.model.AgentStatistics;
import com.kf5.support.model.AgentStatus;
import com.kf5.support.model.AgentStatusSummary;
import com.kf5.support.model.AgentStatusTime;
import com.kf5.support.model.AgentStatusTimeStatistics;
import com.kf5.support.model.AgentVoiceCallInbound;
import com.kf5.support.model.AgentVoiceCallOutbound;
import com.kf5.support.model.AgentVoiceCallSubsectionInbound;
import com.kf5.support.model.AgentVoiceCallSubsectionOutbound;
import com.kf5.support.model.AgentVoicePerformance;
import com.kf5.support.model.AgentVoiceStateTime;
import com.kf5.support.model.AgentVoiceStatus;
import com.kf5.support.model.AgentWorkStatus;
import com.kf5.support.model.AgentWorkStatusOverview;
import com.kf5.support.model.AgentWorkStatusStatistics;
import com.kf5.support.model.Attachment;
import com.kf5.support.model.Automation;
import com.kf5.support.model.Category;
import com.kf5.support.model.Chat;
import com.kf5.support.model.ChatInfo;
import com.kf5.support.model.ChatSource;
import com.kf5.support.model.ChatSourceOverview;
import com.kf5.support.model.ChatSourceStatistics;
import com.kf5.support.model.Comment;
import com.kf5.support.model.Condition;
import com.kf5.support.model.CustomField;
import com.kf5.support.model.CustomFieldOption;
import com.kf5.support.model.DocumentStats;
import com.kf5.support.model.Forum;
import com.kf5.support.model.Group;
import com.kf5.support.model.GroupInfo;
import com.kf5.support.model.IMAgent;
import com.kf5.support.model.IMAgentInfo;
import com.kf5.support.model.IMGroup;
import com.kf5.support.model.Message;
import com.kf5.support.model.MonitorAgent;
import com.kf5.support.model.Organization;
import com.kf5.support.model.OrganizationField;
import com.kf5.support.model.Post;
import com.kf5.support.model.PostComment;
import com.kf5.support.model.PostVote;
import com.kf5.support.model.Question;
import com.kf5.support.model.QuestionComment;
import com.kf5.support.model.QueueVisitorInfo;
import com.kf5.support.model.Requester;
import com.kf5.support.model.SystemLog;
import com.kf5.support.model.Ticket;
import com.kf5.support.model.TicketField;
import com.kf5.support.model.Topic;
import com.kf5.support.model.Trigger;
import com.kf5.support.model.Upload;
import com.kf5.support.model.User;
import com.kf5.support.model.UserField;
import com.kf5.support.model.UserFiled;
import com.kf5.support.model.View;
import com.kf5.support.model.ViewCount;
import com.kf5.support.model.VoiceAccount;
import com.kf5.support.model.VoiceAgentLoginState;
import com.kf5.support.model.VoiceCall;
import com.kf5.support.model.VoiceCallUnAnswered;
import com.kf5.support.model.VoiceQueueCall;
import com.kf5.support.model.builder.KF5EntityBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kf5.support.fastjson.JSONArray;
import org.kf5.support.fastjson.JSONObject;

public class EntityBuilder
extends KF5EntityBuilder {
    public static Ticket buildTicket(JSONObject jsonObject) {
        Ticket ticket = new Ticket();
        ticket.setId(EntityBuilder.safeInt(jsonObject, "id"));
        ticket.setUrl(EntityBuilder.safeGet(jsonObject, "url"));
        ticket.setTitle(EntityBuilder.safeGet(jsonObject, "title"));
        ticket.setDescription(EntityBuilder.safeGet(jsonObject, "description"));
        ticket.setType(EntityBuilder.safeGet(jsonObject, "type"));
        ticket.setStatus(EntityBuilder.safeGet(jsonObject, "status"));
        ticket.setPriority(EntityBuilder.safeGet(jsonObject, "priority"));
        ticket.setRecipient(EntityBuilder.safeGet(jsonObject, "recipient"));
        ticket.setRequesterId(EntityBuilder.safeInt(jsonObject, "requester_id"));
        ticket.setAssigneeId(EntityBuilder.safeInt(jsonObject, "assignee_id"));
        ticket.setOrganizationId(EntityBuilder.safeInt(jsonObject, "organization_id"));
        ticket.setGroupId(EntityBuilder.safeInt(jsonObject, "group_id"));
        ticket.setProblemId(EntityBuilder.safeInt(jsonObject, "problem_id"));
        ticket.setDueDate(EntityBuilder.safeInt(jsonObject, "due_date").intValue());
        ticket.setCreatedAt(EntityBuilder.safeGet(jsonObject, "created_at"));
        ticket.setUpdatedAt(EntityBuilder.safeGet(jsonObject, "updated_at"));
        ticket.setAssigneedAt(EntityBuilder.safeGet(jsonObject, "assigneed_at"));
        ticket.setResolvedAt(EntityBuilder.safeGet(jsonObject, "resolved_at"));
        ticket.setClosedAt(EntityBuilder.safeGet(jsonObject, "closed_at"));
        ticket.setSource(EntityBuilder.safeGet(jsonObject, "source"));
        ticket.setSatisfactionRating(EntityBuilder.safeGet(jsonObject, "satisfaction_rating"));
        JSONArray array = EntityBuilder.safeArray(jsonObject, "custom_fields");
        if (array != null) {
            int size = array.size();
            ArrayList<CustomField> customList = new ArrayList<CustomField>();
            for (int i = 0; i < size; ++i) {
                JSONObject customObject = array.getJSONObject(i);
                customList.add(EntityBuilder.buildCustomField(customObject));
            }
            ticket.setListCustomFields(customList);
        }
        return ticket;
    }

    public static CustomField buildCustomField(JSONObject jsonObject) {
        CustomField customField = new CustomField();
        customField.setKey(EntityBuilder.safeGet(jsonObject, "name"));
        customField.setValue(EntityBuilder.safeGet(jsonObject, "value"));
        return customField;
    }

    public static List<Ticket> buildTicketList(JSONArray jsonArray) {
        ArrayList<Ticket> ticketList = new ArrayList<Ticket>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                Ticket ticket = EntityBuilder.buildTicket(jsonObject);
                ticketList.add(ticket);
            }
        }
        return ticketList;
    }

    public static User buildUser(JSONObject jsonObject) {
        JSONArray groupInfosArray;
        User user = new User();
        user.setId(EntityBuilder.safeInt(jsonObject, "id"));
        user.setUrl(EntityBuilder.safeGet(jsonObject, "url"));
        user.setEmail(EntityBuilder.safeGet(jsonObject, "email"));
        user.setName(EntityBuilder.safeGet(jsonObject, "name"));
        user.setAgentDisplayName(EntityBuilder.safeGet(jsonObject, "agent_display_name"));
        user.setRole(EntityBuilder.safeGet(jsonObject, "role"));
        user.setPhone(EntityBuilder.safeGet(jsonObject, "phone"));
        user.setPhoneBind(EntityBuilder.safeBoolean(jsonObject, "phone_bind"));
        user.setSignature(EntityBuilder.safeGet(jsonObject, "signature"));
        user.setDetails(EntityBuilder.safeGet(jsonObject, "details"));
        user.setNotes(EntityBuilder.safeGet(jsonObject, "notes"));
        user.setOrganizationId(EntityBuilder.safeInt(jsonObject, "organization_id"));
        user.setLanguage(EntityBuilder.safeGet(jsonObject, "language"));
        user.setCreatedAt(EntityBuilder.safeGet(jsonObject, "created_at"));
        user.setUpdatedAt(EntityBuilder.safeGet(jsonObject, "updated_at"));
        user.setLastLoginAt(EntityBuilder.safeGet(jsonObject, "last_login_at"));
        user.setStatus(EntityBuilder.safeGet(jsonObject, "status"));
        user.setPhoto(EntityBuilder.safeGet(jsonObject, "photo"));
        user.setModetator(EntityBuilder.safeBoolean(jsonObject, "moderator"));
        user.setPublicComments(EntityBuilder.safeBoolean(jsonObject, "public_comments"));
        user.setManagePeople(EntityBuilder.safeBoolean(jsonObject, "manage_people"));
        user.setTicketRestriction(EntityBuilder.safeGet(jsonObject, "ticket_restriction"));
        user.setCustomRoleId(EntityBuilder.safeInt(jsonObject, "custom_role_id"));
        JSONArray fieldArray = EntityBuilder.safeArray(jsonObject, "user_fields");
        if (fieldArray != null) {
            int size = fieldArray.size();
            ArrayList<UserFiled> userFileds = new ArrayList<UserFiled>();
            for (int i = 0; i < size; ++i) {
                JSONObject fieldObject = fieldArray.getJSONObject(i);
                UserFiled userFiled = EntityBuilder.buildUserFiled(fieldObject);
                userFileds.add(userFiled);
            }
            user.setUserFileds(userFileds);
        }
        if ((groupInfosArray = EntityBuilder.safeArray(jsonObject, "groups_info")) != null) {
            ArrayList<GroupInfo> groupInfos = new ArrayList<GroupInfo>();
            int size = groupInfosArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject itemObj = groupInfosArray.getJSONObject(i);
                groupInfos.add(EntityBuilder.buildGroupInfo(itemObj));
            }
            user.setGroupInfos(groupInfos);
        }
        return user;
    }

    public static UserFiled buildUserFiled(JSONObject jsonObject) {
        UserFiled userFiled = new UserFiled();
        userFiled.setKey(EntityBuilder.safeGet(jsonObject, "name"));
        userFiled.setValue(EntityBuilder.safeGet(jsonObject, "value"));
        return userFiled;
    }

    private static GroupInfo buildGroupInfo(JSONObject jsonObject) {
        GroupInfo groupInfo = new GroupInfo();
        groupInfo.setName(EntityBuilder.safeGet(jsonObject, "name"));
        groupInfo.setId(EntityBuilder.safeGet(jsonObject, "id"));
        groupInfo.setDisplayName(EntityBuilder.safeGet(jsonObject, "display_name"));
        return groupInfo;
    }

    public static List<User> buildUsers(JSONArray jsonArray) {
        ArrayList<User> users = new ArrayList<User>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject itemObject = jsonArray.getJSONObject(i);
                users.add(EntityBuilder.buildUser(itemObject));
            }
        }
        return users;
    }

    public static Requester buildRequester(JSONObject jsonObject) {
        Requester requester = new Requester();
        requester.setId(EntityBuilder.safeInt(jsonObject, "id"));
        requester.setUrl(EntityBuilder.safeGet(jsonObject, "url"));
        requester.setTitle(EntityBuilder.safeGet(jsonObject, "title"));
        requester.setDescription(EntityBuilder.safeGet(jsonObject, "description"));
        requester.setType(EntityBuilder.safeGet(jsonObject, "type"));
        requester.setStatus(EntityBuilder.safeGet(jsonObject, "status"));
        requester.setPriority(EntityBuilder.safeGet(jsonObject, "priority"));
        requester.setRequester_id(EntityBuilder.safeInt(jsonObject, "requester_id"));
        requester.setAssignee_id(EntityBuilder.safeInt(jsonObject, "assignee_id"));
        requester.setOrganization_id(EntityBuilder.safeInt(jsonObject, "organization_id"));
        requester.setGroup_id(EntityBuilder.safeInt(jsonObject, "group_id"));
        requester.setDue_date(EntityBuilder.safeGet(jsonObject, "due_date"));
        requester.setCreated_at(EntityBuilder.safeGet(jsonObject, "created_at"));
        requester.setUpdated_at(EntityBuilder.safeGet(jsonObject, "updated_at"));
        JSONArray jsonArray = EntityBuilder.safeArray(jsonObject, "custom_fields");
        if (jsonArray != null) {
            ArrayList<CustomField> list = new ArrayList<CustomField>();
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject customObject = jsonArray.getJSONObject(i);
                list.add(EntityBuilder.buildCustomField(customObject));
            }
            requester.setCustomFields(list);
        }
        return requester;
    }

    public static List<Requester> buildRequesters(JSONArray jsonArray) {
        ArrayList<Requester> list = new ArrayList<Requester>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject itemObject = jsonArray.getJSONObject(i);
                list.add(EntityBuilder.buildRequester(itemObject));
            }
        }
        return list;
    }

    public static Comment buildComment(JSONObject jsonObject) {
        Comment comment = new Comment();
        comment.setId(EntityBuilder.safeInt(jsonObject, "id"));
        comment.setContent(EntityBuilder.safeGet(jsonObject, "content"));
        comment.setHtml_content(EntityBuilder.safeGet(jsonObject, "html_content"));
        comment.setPublic(EntityBuilder.safeBoolean(jsonObject, "public"));
        comment.setCreated_at(EntityBuilder.safeGet(jsonObject, "created_at"));
        comment.setAuthor_id(EntityBuilder.safeInt(jsonObject, "author_id"));
        comment.setAuthor_name(EntityBuilder.safeGet(jsonObject, "author_name"));
        JSONArray attachmentArray = EntityBuilder.safeArray(jsonObject, "attachments");
        if (attachmentArray != null) {
            int size = attachmentArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject attachmentObj = attachmentArray.getJSONObject(i);
                comment.getListAttachments().add(EntityBuilder.buildAttachment(attachmentObj));
            }
        }
        return comment;
    }

    public static List<Comment> buildComments(JSONArray jsonArray) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject itemJsonObject = jsonArray.getJSONObject(i);
                comments.add(EntityBuilder.buildComment(itemJsonObject));
            }
        }
        return comments;
    }

    public static TicketField buildTicketField(JSONObject jsonObject) {
        TicketField ticketField = new TicketField();
        ticketField.setId(EntityBuilder.safeInt(jsonObject, "id"));
        ticketField.setUrl(EntityBuilder.safeGet(jsonObject, "url"));
        ticketField.setName(EntityBuilder.safeGet(jsonObject, "name"));
        ticketField.setType(EntityBuilder.safeGet(jsonObject, "type"));
        ticketField.setAgent_title(EntityBuilder.safeGet(jsonObject, "agent_title"));
        ticketField.setAgent_required(EntityBuilder.safeBoolean(jsonObject, "agent_required"));
        ticketField.setEnduser_visible(EntityBuilder.safeBoolean(jsonObject, "enduser_visible"));
        ticketField.setEnduser_title(EntityBuilder.safeGet(jsonObject, "enduser_title"));
        ticketField.setEnduser_editable(EntityBuilder.safeBoolean(jsonObject, "enduser_editable"));
        ticketField.setEnduser_description(EntityBuilder.safeGet(jsonObject, "enduser_description"));
        ticketField.setEnduser_required(EntityBuilder.safeBoolean(jsonObject, "enduser_required"));
        ticketField.setActive(EntityBuilder.safeBoolean(jsonObject, "active"));
        ticketField.setRegexp_for_validation(EntityBuilder.safeGet(jsonObject, "regexp_for_validation"));
        JSONArray optionArray = EntityBuilder.safeArray(jsonObject, "custom_field_options");
        if (optionArray != null) {
            int size = optionArray.size();
            ArrayList<CustomFieldOption> list = new ArrayList<CustomFieldOption>();
            for (int i = 0; i < size; ++i) {
                JSONObject itemObject = optionArray.getJSONObject(i);
                list.add(EntityBuilder.buildCustomFieldOption(itemObject));
            }
            ticketField.setCustomFieldOptions(list);
        }
        return ticketField;
    }

    public static CustomFieldOption buildCustomFieldOption(JSONObject jsonObject) {
        CustomFieldOption customFieldOption = new CustomFieldOption();
        customFieldOption.setKey(EntityBuilder.safeGet(jsonObject, "key"));
        customFieldOption.setValue(EntityBuilder.safeGet(jsonObject, "value"));
        return customFieldOption;
    }

    public static List<TicketField> buildTicketFields(JSONArray jsonArray) {
        ArrayList<TicketField> list = new ArrayList<TicketField>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject itemObject = jsonArray.getJSONObject(i);
                list.add(EntityBuilder.buildTicketField(itemObject));
            }
        }
        return list;
    }

    public static View buildView(JSONObject jsonObject) {
        View view = new View();
        view.setId(EntityBuilder.safeInt(jsonObject, "id"));
        view.setUrl(EntityBuilder.safeGet(jsonObject, "url"));
        view.setTitle(EntityBuilder.safeGet(jsonObject, "title"));
        view.setActive(EntityBuilder.safeBoolean(jsonObject, "active"));
        view.setCreated_at(EntityBuilder.safeGet(jsonObject, "created_at"));
        view.setSlas_id(EntityBuilder.safeInt(jsonObject, "slas_id"));
        return view;
    }

    public static List<View> buildViews(JSONArray jsonArray) {
        ArrayList<View> views = new ArrayList<View>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject itemObject = jsonArray.getJSONObject(i);
                views.add(EntityBuilder.buildView(itemObject));
            }
        }
        return views;
    }

    public static ViewCount buildViewCount(JSONObject jsonObject) {
        ViewCount viewCount = new ViewCount();
        viewCount.setCount(EntityBuilder.safeInt(jsonObject, "count"));
        viewCount.setUrl(EntityBuilder.safeGet(jsonObject, "url"));
        viewCount.setView_id(EntityBuilder.safeInt(jsonObject, "view_id"));
        return viewCount;
    }

    public static List<ViewCount> buildViewCounts(JSONArray jsonArray) {
        ArrayList<ViewCount> viewCounts = new ArrayList<ViewCount>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                viewCounts.add(EntityBuilder.buildViewCount(jsonObject));
            }
        }
        return viewCounts;
    }

    public static UserField buildUserField(JSONObject jsonObject) {
        UserField userFiled = new UserField();
        userFiled.setId(EntityBuilder.safeInt(jsonObject, "id"));
        userFiled.setUrl(EntityBuilder.safeGet(jsonObject, "url"));
        userFiled.setName(EntityBuilder.safeGet(jsonObject, "name"));
        userFiled.setType(EntityBuilder.safeGet(jsonObject, "type"));
        userFiled.setTitle(EntityBuilder.safeGet(jsonObject, "title"));
        userFiled.setDescription(EntityBuilder.safeGet(jsonObject, "description"));
        JSONArray jsonArray = EntityBuilder.safeArray(jsonObject, "custom_field_options");
        if (jsonArray != null) {
            int size = jsonArray.size();
            ArrayList<CustomFieldOption> list = new ArrayList<CustomFieldOption>();
            for (int i = 0; i < size; ++i) {
                JSONObject itemObject = jsonArray.getJSONObject(i);
                list.add(EntityBuilder.buildCustomFieldOption(itemObject));
            }
            userFiled.setCustomFieldOptions(list);
        }
        return userFiled;
    }

    public static List<UserField> buildUserFields(JSONArray jsonArray) {
        ArrayList<UserField> list = new ArrayList<UserField>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject itemObject = jsonArray.getJSONObject(i);
                list.add(EntityBuilder.buildUserField(itemObject));
            }
        }
        return list;
    }

    public static Agent buildAgent(JSONObject jsonObject) {
        Agent agent = new Agent();
        agent.setId(EntityBuilder.safeInt(jsonObject, "id"));
        agent.setUrl(EntityBuilder.safeGet(jsonObject, "url"));
        agent.setName(EntityBuilder.safeGet(jsonObject, "name"));
        agent.setUsername(EntityBuilder.safeGet(jsonObject, "username"));
        return agent;
    }

    public static List<Agent> buildAgents(JSONArray jsonArray) {
        ArrayList<Agent> list = new ArrayList<Agent>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject itemObject = jsonArray.getJSONObject(i);
                list.add(EntityBuilder.buildAgent(itemObject));
            }
        }
        return list;
    }

    public static Group buildGroup(JSONObject jsonObject) {
        Group group = new Group();
        group.setId(EntityBuilder.safeInt(jsonObject, "id"));
        group.setUrl(EntityBuilder.safeGet(jsonObject, "url"));
        group.setName(EntityBuilder.safeGet(jsonObject, "name"));
        group.setCreated_at(EntityBuilder.safeGet(jsonObject, "created_at"));
        JSONArray jsonArray = EntityBuilder.safeArray(jsonObject, "agents");
        group.setListAgents(EntityBuilder.buildAgents(jsonArray));
        return group;
    }

    public static List<Group> buildGroups(JSONArray jsonArray) {
        ArrayList<Group> list = new ArrayList<Group>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject itemObject = jsonArray.getJSONObject(i);
                list.add(EntityBuilder.buildGroup(itemObject));
            }
        }
        return list;
    }

    public static Category buildCategory(JSONObject jsonObject) {
        Category category = new Category();
        category.setId(EntityBuilder.safeInt(jsonObject, "id"));
        category.setUrl(EntityBuilder.safeGet(jsonObject, "url"));
        category.setTitle(EntityBuilder.safeGet(jsonObject, "title"));
        category.setContent(EntityBuilder.safeGet(jsonObject, "content"));
        category.setDisplay_limit(EntityBuilder.safeInt(jsonObject, "display_limit"));
        category.setSort(EntityBuilder.safeInt(jsonObject, "sort"));
        return category;
    }

    public static List<Category> buildCategories(JSONArray jsonArray) {
        ArrayList<Category> list = new ArrayList<Category>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                list.add(EntityBuilder.buildCategory(jsonObject));
            }
        }
        return list;
    }

    public static Forum buildForum(JSONObject jsonObject) {
        Forum forum = new Forum();
        forum.setId(EntityBuilder.safeInt(jsonObject, "id"));
        forum.setUrl(EntityBuilder.safeGet(jsonObject, "url"));
        forum.setCategory_id(EntityBuilder.safeInt(jsonObject, "category_id"));
        forum.setTitle(EntityBuilder.safeGet(jsonObject, "title"));
        forum.setContent(EntityBuilder.safeGet(jsonObject, "content"));
        forum.setRole_view(EntityBuilder.safeGet(jsonObject, "role_view"));
        forum.setSort(EntityBuilder.safeInt(jsonObject, "sort"));
        return forum;
    }

    public static List<Forum> buildForums(JSONArray jsonArray) {
        ArrayList<Forum> list = new ArrayList<Forum>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                list.add(EntityBuilder.buildForum(object));
            }
        }
        return list;
    }

    public static Attachment buildAttachment(JSONObject jsonObject) {
        Attachment attachment = new Attachment();
        attachment.setId(EntityBuilder.safeInt(jsonObject, "id"));
        attachment.setUrl(EntityBuilder.safeGet(jsonObject, "url"));
        attachment.setName(EntityBuilder.safeGet(jsonObject, "name"));
        attachment.setSize(EntityBuilder.safeInt(jsonObject, "size"));
        attachment.setContent_url(EntityBuilder.safeGet(jsonObject, "content_url"));
        attachment.setToken(EntityBuilder.safeGet(jsonObject, "token"));
        return attachment;
    }

    public static List<Attachment> buildAttachments(JSONArray jsonArray) {
        ArrayList<Attachment> list = new ArrayList<Attachment>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                list.add(EntityBuilder.buildAttachment(object));
            }
        }
        return list;
    }

    public static Post buildPost(JSONObject jsonObject) {
        Post post = new Post();
        post.setId(EntityBuilder.safeInt(jsonObject, "id"));
        post.setUrl(EntityBuilder.safeGet(jsonObject, "url"));
        post.setForum_id(EntityBuilder.safeInt(jsonObject, "forum_id"));
        post.setTitle(EntityBuilder.safeGet(jsonObject, "title"));
        post.setContent(EntityBuilder.safeGet(jsonObject, "content"));
        post.setAuthor_id(EntityBuilder.safeInt(jsonObject, "author_id"));
        post.setDisable_comments(EntityBuilder.safeBoolean(jsonObject, "disable_comments"));
        post.setIs_home(EntityBuilder.safeBoolean(jsonObject, "is_home"));
        post.setIs_highlight(EntityBuilder.safeBoolean(jsonObject, "is_highlight"));
        post.setIs_top(EntityBuilder.safeBoolean(jsonObject, "is_top"));
        post.setIs_draft(EntityBuilder.safeBoolean(jsonObject, "is_draft"));
        post.setCreated_at(EntityBuilder.safeGet(jsonObject, "created_at"));
        post.setUpdated_at(EntityBuilder.safeGet(jsonObject, "updated_at"));
        JSONArray attachmentArray = EntityBuilder.safeArray(jsonObject, "attachments");
        if (attachmentArray != null) {
            int size = attachmentArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject attachmentObj = attachmentArray.getJSONObject(i);
                post.getAttachments().add(EntityBuilder.buildAttachment(attachmentObj));
            }
        }
        return post;
    }

    public static List<Post> buildPosts(JSONArray jsonArray) {
        ArrayList<Post> list = new ArrayList<Post>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                list.add(EntityBuilder.buildPost(object));
            }
        }
        return list;
    }

    public static PostComment buildPostComment(JSONObject jsonObject) {
        PostComment comment = new PostComment();
        comment.setAuthor_id(EntityBuilder.safeInt(jsonObject, "author_id"));
        comment.setContent(EntityBuilder.safeGet(jsonObject, "content"));
        comment.setCreated_at(EntityBuilder.safeGet(jsonObject, "created_at"));
        comment.setId(EntityBuilder.safeInt(jsonObject, "id"));
        comment.setUpdated_at(EntityBuilder.safeGet(jsonObject, "updated_at"));
        return comment;
    }

    public static List<PostComment> buildPostComments(JSONArray jsonArray) {
        ArrayList<PostComment> list = new ArrayList<PostComment>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                list.add(EntityBuilder.buildPostComment(object));
            }
        }
        return list;
    }

    public static Organization buildOrganization(JSONObject jsonObject) {
        Organization organization = new Organization();
        organization.setId(EntityBuilder.safeInt(jsonObject, "id"));
        organization.setUrl(EntityBuilder.safeGet(jsonObject, "url"));
        organization.setName(EntityBuilder.safeGet(jsonObject, "name"));
        organization.setDomain(EntityBuilder.safeGet(jsonObject, "domain"));
        organization.setDesription(EntityBuilder.safeGet(jsonObject, "description"));
        organization.setGroup_id(EntityBuilder.safeInt(jsonObject, "group_id"));
        organization.setCreated_at(EntityBuilder.safeGet(jsonObject, "created_at"));
        JSONArray jsonArray = EntityBuilder.safeArray(jsonObject, "organization_fields");
        if (jsonArray != null) {
            ArrayList<OrganizationField> organizationFields = new ArrayList<OrganizationField>();
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject fildObject = jsonArray.getJSONObject(i);
                organizationFields.add(EntityBuilder.buildOrganizationField(fildObject));
            }
            organization.setOrganizationFields(organizationFields);
        }
        return organization;
    }

    public static List<Organization> buildOrganizations(JSONArray jsonArray) {
        ArrayList<Organization> list = new ArrayList<Organization>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject itemObject = jsonArray.getJSONObject(i);
                list.add(EntityBuilder.buildOrganization(itemObject));
            }
        }
        return list;
    }

    public static OrganizationField buildOrganizationField(JSONObject jsonObject) {
        OrganizationField field = new OrganizationField();
        field.setKey(EntityBuilder.safeGet(jsonObject, "name"));
        field.setValue(EntityBuilder.safeGet(jsonObject, "value"));
        return field;
    }

    public static Topic buildTopic(JSONObject jsonObject) {
        Topic topic = new Topic();
        topic.setId(EntityBuilder.safeInt(jsonObject, "id"));
        topic.setUrl(EntityBuilder.safeGet(jsonObject, "url"));
        topic.setTitle(EntityBuilder.safeGet(jsonObject, "title"));
        topic.setDecription(EntityBuilder.safeGet(jsonObject, "description"));
        topic.setSort(EntityBuilder.safeInt(jsonObject, "sort"));
        topic.setCreated_at(EntityBuilder.safeGet(jsonObject, "created_at"));
        return topic;
    }

    public static List<Topic> buildTopics(JSONArray jsonArray) {
        ArrayList<Topic> list = new ArrayList<Topic>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject itemObject = jsonArray.getJSONObject(i);
                list.add(EntityBuilder.buildTopic(itemObject));
            }
        }
        return list;
    }

    public static Question buildQuestion(JSONObject jsonObject) {
        Question question = new Question();
        question.setId(EntityBuilder.safeInt(jsonObject, "id"));
        question.setUrl(EntityBuilder.safeGet(jsonObject, "url"));
        question.setTopic_id(EntityBuilder.safeInt(jsonObject, "topic_id"));
        question.setTitle(EntityBuilder.safeGet(jsonObject, "title"));
        question.setContent(EntityBuilder.safeGet(jsonObject, "content"));
        question.setAuthor_id(EntityBuilder.safeInt(jsonObject, "author_id"));
        question.setCreated_at(EntityBuilder.safeGet(jsonObject, "created_at"));
        question.setUpdated_at(EntityBuilder.safeGet(jsonObject, "updated_at"));
        return question;
    }

    public static List<Question> buildQuestions(JSONArray jsonArray) {
        ArrayList<Question> list = new ArrayList<Question>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject object = jsonArray.getJSONObject(i);
                list.add(EntityBuilder.buildQuestion(object));
            }
        }
        return list;
    }

    public static QuestionComment buildQuestionComment(JSONObject jsonObject) {
        QuestionComment questionComment = new QuestionComment();
        questionComment.setId(EntityBuilder.safeInt(jsonObject, "id"));
        questionComment.setContent(EntityBuilder.safeGet(jsonObject, "content"));
        questionComment.setAuthor_id(EntityBuilder.safeInt(jsonObject, "author_id"));
        questionComment.setCreated_at(EntityBuilder.safeGet(jsonObject, "created_at"));
        questionComment.setUpdated_at(EntityBuilder.safeGet(jsonObject, "updated_at"));
        return questionComment;
    }

    public static List<QuestionComment> buildQuestionComments(JSONArray jsonArray) {
        ArrayList<QuestionComment> list = new ArrayList<QuestionComment>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                list.add(EntityBuilder.buildQuestionComment(jsonObject));
            }
        }
        return list;
    }

    public static List<Chat> buildChatList(JSONArray jsonArray) {
        ArrayList<Chat> list = new ArrayList<Chat>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                list.add(EntityBuilder.buildChat(jsonObject));
            }
        }
        return list;
    }

    public static Chat buildChat(JSONObject jsonObject) {
        Chat chat = new Chat();
        if (jsonObject != null) {
            chat.setEnd_at(EntityBuilder.safeGet(jsonObject, "end_at"));
            chat.setAgent_id(EntityBuilder.safeInt(jsonObject, "agent_id"));
            chat.setAssigned_at(EntityBuilder.safeGet(jsonObject, "assigned_at"));
            chat.setVisitor_id(EntityBuilder.safeInt(jsonObject, "visitor_id"));
            chat.setCreated_at(EntityBuilder.safeGet(jsonObject, "created_at"));
            chat.setId(EntityBuilder.safeInt(jsonObject, "id"));
            chat.setType(EntityBuilder.safeGet(jsonObject, "type"));
            chat.setStarted_by(EntityBuilder.safeGet(jsonObject, "started_by"));
            chat.setStatus(EntityBuilder.safeGet(jsonObject, "status"));
            chat.setQualified(EntityBuilder.safeBoolean(jsonObject, "qualified"));
            chat.setMessage_count(EntityBuilder.safeInt(jsonObject, "message_count"));
            chat.setDuration(EntityBuilder.safeInt(jsonObject, "duration"));
            chat.setIs_temp(EntityBuilder.safeInt(jsonObject, "is_temp"));
            chat.setAssigned(EntityBuilder.safeLong(jsonObject, "assigned"));
            chat.setCochat(EntityBuilder.safeInt(jsonObject, "cochat"));
            JSONArray messageArray = EntityBuilder.safeArray(jsonObject, "messages");
            if (messageArray != null) {
                ArrayList<Message> list = new ArrayList<Message>();
                int size = messageArray.size();
                for (int i = 0; i < size; ++i) {
                    JSONObject itemObj = messageArray.getJSONObject(i);
                    list.add(EntityBuilder.buildMessage(itemObj));
                }
                chat.setList(list);
            }
        }
        return chat;
    }

    public static Message buildMessage(JSONObject jsonObject) {
        Message message = new Message();
        if (jsonObject != null) {
            message.setMsg(EntityBuilder.safeGet(jsonObject, "msg"));
            message.setIs_read(EntityBuilder.safeBoolean(jsonObject, "is_read"));
            message.setUser_id(EntityBuilder.safeInt(jsonObject, "user_id"));
            message.setName(EntityBuilder.safeGet(jsonObject, "name"));
            message.setCreate_at(EntityBuilder.safeGet(jsonObject, "created_at"));
            message.setId(EntityBuilder.safeInt(jsonObject, "id"));
            message.setType(EntityBuilder.safeGet(jsonObject, "type"));
            message.setReply_timeout(EntityBuilder.safeBoolean(jsonObject, "reply_timeout"));
            message.setChat_id(EntityBuilder.safeInt(jsonObject, "chat_id"));
            message.setUpload_id(EntityBuilder.safeInt(jsonObject, "upload_id"));
            JSONObject uploadObj = EntityBuilder.safeObject(jsonObject, "upload");
            if (uploadObj != null) {
                message.setUpload(EntityBuilder.buildUpload(uploadObj));
            }
        }
        return message;
    }

    public static Upload buildUpload(JSONObject jsonObject) {
        Upload upload = new Upload();
        upload.setSize(EntityBuilder.safeInt(jsonObject, "size"));
        upload.setCreate(EntityBuilder.safeInt(jsonObject, "created"));
        upload.setName(EntityBuilder.safeGet(jsonObject, "name"));
        upload.setId(EntityBuilder.safeInt(jsonObject, "id"));
        upload.setType(EntityBuilder.safeGet(jsonObject, "type"));
        upload.setUrl(EntityBuilder.safeGet(jsonObject, "url"));
        upload.setWidth(EntityBuilder.safeInt(jsonObject, "width"));
        upload.setOss_token(EntityBuilder.safeGet(jsonObject, "oss_token"));
        upload.setHeight(EntityBuilder.safeInt(jsonObject, "height"));
        upload.setToken(EntityBuilder.safeGet(jsonObject, "token"));
        return upload;
    }

    public static AICategory buildAiCategory(JSONObject jsonObject) {
        JSONObject aiQuestionCategoryObj;
        AICategory aiCategory = new AICategory();
        aiCategory.setActive(EntityBuilder.safeBoolean(jsonObject, "active"));
        aiCategory.setCategory_id(EntityBuilder.safeInt(jsonObject, "category_id"));
        aiCategory.setAnswer(EntityBuilder.safeGet(jsonObject, "answer"));
        aiCategory.setCreated_at(EntityBuilder.safeGet(jsonObject, "created_at"));
        aiCategory.setId(EntityBuilder.safeInt(jsonObject, "id"));
        aiCategory.setTitle(EntityBuilder.safeGet(jsonObject, "title"));
        JSONArray otherTitlesArray = EntityBuilder.safeArray(jsonObject, "other_titles");
        if (otherTitlesArray != null) {
            aiCategory.setOther_titles(otherTitlesArray.toString());
        }
        if ((aiQuestionCategoryObj = EntityBuilder.safeObject(jsonObject, "question_category")) != null) {
            aiCategory.setAiQuestionCategory(EntityBuilder.buildAIQuestionCategory(aiQuestionCategoryObj));
        }
        return aiCategory;
    }

    public static AIQuestionCategory buildAIQuestionCategory(JSONObject jsonObject) {
        AIQuestionCategory aiQuestionCategory = new AIQuestionCategory();
        aiQuestionCategory.setId(EntityBuilder.safeInt(jsonObject, "id"));
        aiQuestionCategory.setTitle(EntityBuilder.safeGet(jsonObject, "title"));
        return aiQuestionCategory;
    }

    public static List<AIQuestionCategory> buildAIQuestionCategoryList(JSONArray jsonArray) {
        ArrayList<AIQuestionCategory> list = new ArrayList<AIQuestionCategory>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                list.add(EntityBuilder.buildAIQuestionCategory(jsonObject));
            }
        }
        return list;
    }

    public static List<AICategory> buildAICategoryList(JSONArray jsonArray) {
        ArrayList<AICategory> list = new ArrayList<AICategory>();
        if (jsonArray != null) {
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                list.add(EntityBuilder.buildAiCategory(jsonObject));
            }
        }
        return list;
    }

    private static Condition buildCondition(JSONObject jsonObject) {
        Condition condition = new Condition();
        if (jsonObject != null) {
            condition.setCompany_id(EntityBuilder.safeGet(jsonObject, "company_id"));
            condition.setDelete_at(EntityBuilder.safeGet(jsonObject, "deleted_at"));
            condition.setOperator(EntityBuilder.safeGet(jsonObject, "operator"));
            condition.setSource(EntityBuilder.safeGet(jsonObject, "source"));
            condition.setValue(EntityBuilder.safeGet(jsonObject, "value"));
        }
        return condition;
    }

    private static List<Condition> buildListCondition(JSONArray jsonArray) {
        ArrayList<Condition> list = new ArrayList<Condition>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildCondition(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    private static Action buildAction(JSONObject jsonObject) {
        Action action = new Action();
        if (jsonObject != null) {
            action.setCompany_id(EntityBuilder.safeGet(jsonObject, "company_id"));
            action.setGroup_id(EntityBuilder.safeGet(jsonObject, "group_id"));
            action.setSubject(EntityBuilder.safeGet(jsonObject, "subject"));
            action.setSource(EntityBuilder.safeGet(jsonObject, "source"));
            action.setBody(EntityBuilder.safeGet(jsonObject, "body"));
            action.setValue(EntityBuilder.safeGet(jsonObject, "value"));
            action.setDeleted_at(EntityBuilder.safeGet(jsonObject, "deleted_at"));
            action.setOverflowable(EntityBuilder.safeGet(jsonObject, "overflowable"));
            action.setOverflow_type(EntityBuilder.safeGet(jsonObject, "overflow_type"));
        }
        return action;
    }

    private static List<Action> buildListAction(JSONArray jsonArray) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                actions.add(EntityBuilder.buildAction(jsonArray.getJSONObject(i)));
            }
        }
        return actions;
    }

    private static Trigger buildTrigger(JSONObject jsonObject, Trigger trigger) {
        if (jsonObject != null) {
            JSONArray actionArray;
            trigger.setCreated_at(EntityBuilder.safeGet(jsonObject, "created_at"));
            trigger.setId(EntityBuilder.safeInt(jsonObject, "id"));
            trigger.setSort(EntityBuilder.safeInt(jsonObject, "sort"));
            trigger.setTitle(EntityBuilder.safeGet(jsonObject, "title"));
            JSONObject conditionObj = EntityBuilder.safeObject(jsonObject, "conditions");
            if (conditionObj != null) {
                JSONArray anyArray;
                JSONArray allArray = EntityBuilder.safeArray(conditionObj, "all");
                if (allArray != null) {
                    trigger.setAllConditions(EntityBuilder.buildListCondition(allArray));
                }
                if ((anyArray = EntityBuilder.safeArray(conditionObj, "any")) != null) {
                    trigger.setAnyConditions(EntityBuilder.buildListCondition(anyArray));
                }
            }
            if ((actionArray = EntityBuilder.safeArray(jsonObject, "actions")) != null) {
                trigger.setActions(EntityBuilder.buildListAction(actionArray));
            }
            trigger.setUrl(EntityBuilder.safeGet(jsonObject, "url"));
            trigger.setStatus(EntityBuilder.safeBoolean(jsonObject, "status"));
        }
        return trigger;
    }

    public static Trigger buildTrigger(JSONObject jsonObject) {
        return EntityBuilder.buildTrigger(jsonObject, new Trigger());
    }

    public static List<Trigger> buildTriggerList(JSONArray jsonArray) {
        ArrayList<Trigger> list = new ArrayList<Trigger>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildTrigger(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    public static Automation buildAutomation(JSONObject jsonObject) {
        Automation automation = new Automation();
        if (jsonObject != null) {
            EntityBuilder.buildTrigger(jsonObject, automation);
        }
        return automation;
    }

    public static List<Automation> buildAutomationList(JSONArray jsonArray) {
        ArrayList<Automation> list = new ArrayList<Automation>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildAutomation(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    private static AgentLog buildAgentLog(JSONObject jsonObject) {
        AgentLog agentLog = new AgentLog();
        if (jsonObject != null) {
            agentLog.setLog_id(EntityBuilder.safeLong(jsonObject, "log_id"));
            agentLog.setOperate(EntityBuilder.safeGet(jsonObject, "operate"));
            agentLog.setUser_id(EntityBuilder.safeInt(jsonObject, "user_id"));
            agentLog.setMax_serve(EntityBuilder.safeInt(jsonObject, "max_serve"));
            agentLog.setCreated(EntityBuilder.safeLong(jsonObject, "created"));
            agentLog.setUser_name(EntityBuilder.safeGet(jsonObject, "user_name"));
            agentLog.setPlatform(EntityBuilder.safeGet(jsonObject, "platform"));
        }
        return agentLog;
    }

    public static List<AgentLog> buildAgentLogList(JSONArray jsonArray) {
        ArrayList<AgentLog> list = new ArrayList<AgentLog>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildAgentLog(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    public static AITag buildAITag(JSONObject jsonObject) {
        AITag aiTag = new AITag();
        if (jsonObject != null) {
            aiTag.setId(EntityBuilder.safeInt(jsonObject, "id"));
            aiTag.setName(EntityBuilder.safeGet(jsonObject, "name"));
            aiTag.setType(EntityBuilder.safeGet(jsonObject, "type"));
        }
        return aiTag;
    }

    public static List<AITag> buildAITagList(JSONArray jsonArray) {
        ArrayList<AITag> list = new ArrayList<AITag>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildAITag(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    private static AgentStatus buildAgentStatus(JSONObject jsonObject) {
        AgentStatus agentStatus = new AgentStatus();
        if (jsonObject != null) {
            agentStatus.setServeCount(EntityBuilder.safeInt(jsonObject, "serveCount"));
            agentStatus.setAgentId(EntityBuilder.safeInt(jsonObject, "agent_id"));
            agentStatus.setChatNum(EntityBuilder.safeInt(jsonObject, "chatNum"));
            agentStatus.setMessageNum(EntityBuilder.safeInt(jsonObject, "messageNum"));
            agentStatus.setMaxServe(EntityBuilder.safeInt(jsonObject, "max_serve"));
            agentStatus.setAgentName(EntityBuilder.safeGet(jsonObject, "agentName"));
            agentStatus.setAgentStatus(EntityBuilder.safeGet(jsonObject, "agentStatus"));
            agentStatus.setEnabled(EntityBuilder.safeInt(jsonObject, "enabled"));
            agentStatus.setAverageResponseTime(EntityBuilder.safeInt(jsonObject, "averageResponseTime"));
            agentStatus.setAverageServeTime(EntityBuilder.safeFloat(jsonObject, "averageServeTime").floatValue());
        }
        return agentStatus;
    }

    private static List<AgentStatus> buildAgentStatusList(JSONArray jsonArray) {
        ArrayList<AgentStatus> list = new ArrayList<AgentStatus>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildAgentStatus(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    private static AgentOverview buildAgentOverview(JSONObject jsonObject) {
        AgentOverview agentOverview = new AgentOverview();
        if (jsonObject != null) {
            agentOverview.setServeCount(EntityBuilder.safeInt(jsonObject, "serveCount"));
            agentOverview.setAverageResponseTime(EntityBuilder.safeInt(jsonObject, "averageResponseTime"));
            agentOverview.setAverageServeTime(EntityBuilder.safeFloat(jsonObject, "averageServeTime").floatValue());
            agentOverview.setSumResponseTime(EntityBuilder.safeInt(jsonObject, "sumResponseTime"));
            agentOverview.setChatNum(EntityBuilder.safeInt(jsonObject, "chatNum"));
            agentOverview.setMessageNum(EntityBuilder.safeInt(jsonObject, "messageNum"));
            agentOverview.setSumServeTime(EntityBuilder.safeInt(jsonObject, "sumServeTime"));
        }
        return agentOverview;
    }

    public static MonitorAgent buildMonitorAgent(JSONObject jsonObject) {
        MonitorAgent monitorAgent = new MonitorAgent();
        JSONObject overviewObj = EntityBuilder.safeObject(jsonObject, "monitor_overview");
        monitorAgent.setAgentOverview(EntityBuilder.buildAgentOverview(overviewObj));
        monitorAgent.setAgentStatus(EntityBuilder.buildAgentStatusList(EntityBuilder.safeArray(jsonObject, "monitor_table")));
        return monitorAgent;
    }

    private static ChatInfo buildChatInfo(JSONObject jsonObject) {
        ChatInfo chatInfo = new ChatInfo();
        if (chatInfo != null) {
            chatInfo.setAgent_name(EntityBuilder.safeGet(jsonObject, "agent_name"));
            chatInfo.setCreated(EntityBuilder.safeLong(jsonObject, "created"));
            chatInfo.setVisitor_id(EntityBuilder.safeInt(jsonObject, "visitor_id"));
            chatInfo.setType(EntityBuilder.safeGet(jsonObject, "type"));
            chatInfo.setMessage_count(EntityBuilder.safeInt(jsonObject, "message_count"));
            chatInfo.setVisitor_name(EntityBuilder.safeGet(jsonObject, "visitor_name"));
            chatInfo.setChat_id(EntityBuilder.safeInt(jsonObject, "chat_id"));
            chatInfo.setAssigned(EntityBuilder.safeLong(jsonObject, "assigned"));
            chatInfo.setClosed(EntityBuilder.safeInt(jsonObject, "closed"));
            chatInfo.setChat_from(EntityBuilder.safeGet(jsonObject, "chat_from"));
            chatInfo.setAgent_ids(EntityBuilder.safeInt(jsonObject, "agent_ids"));
            chatInfo.setStatus(EntityBuilder.safeGet(jsonObject, "status"));
        }
        return chatInfo;
    }

    public static List<ChatInfo> buildChatInfoList(JSONArray jsonArray) {
        ArrayList<ChatInfo> list = new ArrayList<ChatInfo>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildChatInfo(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    private static QueueVisitorInfo buildQueueVisitorInfo(JSONObject jsonObject) {
        QueueVisitorInfo queueVisitorInfo = new QueueVisitorInfo();
        if (jsonObject != null) {
            queueVisitorInfo.setSelectedAgentIds(EntityBuilder.safeGet(jsonObject, "selectedAgentIds"));
            queueVisitorInfo.setKf5_user_id(EntityBuilder.safeGet(jsonObject, "kf5_user_id"));
            queueVisitorInfo.setStartedBy(EntityBuilder.safeGet(jsonObject, "started_by"));
            queueVisitorInfo.setSession_id(EntityBuilder.safeGet(jsonObject, "session_id"));
            queueVisitorInfo.setAssignType(EntityBuilder.safeGet(jsonObject, "assignType"));
            queueVisitorInfo.setSource(EntityBuilder.safeGet(jsonObject, "source"));
            queueVisitorInfo.setPlatform(EntityBuilder.safeGet(jsonObject, "platform"));
            queueVisitorInfo.setEnqueueTime(EntityBuilder.safeGet(jsonObject, "enqueueTime"));
            queueVisitorInfo.setDuration(EntityBuilder.safeInt(jsonObject, "duration"));
            queueVisitorInfo.setCompanyId(EntityBuilder.safeGet(jsonObject, "company_id"));
            queueVisitorInfo.setName(EntityBuilder.safeGet(jsonObject, "name"));
            queueVisitorInfo.setId(EntityBuilder.safeGet(jsonObject, "id"));
            queueVisitorInfo.setLang(EntityBuilder.safeGet(jsonObject, "lang"));
            queueVisitorInfo.setStatus(EntityBuilder.safeGet(jsonObject, "status"));
        }
        return queueVisitorInfo;
    }

    public static List<QueueVisitorInfo> buildQueueVisitorInfoList(JSONArray jsonArray) {
        ArrayList<QueueVisitorInfo> list = new ArrayList<QueueVisitorInfo>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildQueueVisitorInfo(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    private static AgentWorkStatusOverview buildAgentWorkStatusOverview(JSONObject jsonObject) {
        AgentWorkStatusOverview overview = new AgentWorkStatusOverview();
        if (jsonObject != null) {
            overview.setServeCount(EntityBuilder.safeInt(jsonObject, "serveCount"));
            overview.setRatingNum(EntityBuilder.safeInt(jsonObject, "ratingNum"));
            overview.setChatNum(EntityBuilder.safeInt(jsonObject, "chatNum"));
            overview.setMessageNum(EntityBuilder.safeInt(jsonObject, "messageNum"));
            overview.setSatisfaction(EntityBuilder.safeInt(jsonObject, "satisfaction"));
            overview.setRatingRate(EntityBuilder.safeFloat(jsonObject, "ratingRate").floatValue());
        }
        return overview;
    }

    private static AgentWorkStatus buildAgentWorkStatus(JSONObject jsonObject) {
        AgentWorkStatus agentWorkStatus = new AgentWorkStatus();
        if (jsonObject != null) {
            agentWorkStatus.setAverageResponseTime(EntityBuilder.safeInt(jsonObject, "averageResponseTime"));
            agentWorkStatus.setServeCount(EntityBuilder.safeInt(jsonObject, "serveCount"));
            agentWorkStatus.setRatingNum(EntityBuilder.safeInt(jsonObject, "ratingNum"));
            agentWorkStatus.setAverageServeTime(EntityBuilder.safeFloat(jsonObject, "averageServeTime").floatValue());
            agentWorkStatus.setChatNum(EntityBuilder.safeInt(jsonObject, "chatNum"));
            agentWorkStatus.setAgent_id(EntityBuilder.safeGet(jsonObject, "agent_id"));
            agentWorkStatus.setMessageNum(EntityBuilder.safeInt(jsonObject, "messageNum"));
            agentWorkStatus.setSatisfaction(EntityBuilder.safeInt(jsonObject, "satisfaction"));
            agentWorkStatus.setRatingRate(EntityBuilder.safeInt(jsonObject, "ratingRate"));
        }
        return agentWorkStatus;
    }

    private static List<AgentWorkStatus> buildAgentWorkStatusList(JSONArray jsonArray) {
        ArrayList<AgentWorkStatus> list = new ArrayList<AgentWorkStatus>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildAgentWorkStatus(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    public static AgentWorkStatusStatistics buildAgentWorkStatusStatistics(JSONObject jsonObject) {
        AgentWorkStatusStatistics agentWorkStatusStatistics = new AgentWorkStatusStatistics();
        agentWorkStatusStatistics.setAgentWorkStatusOverview(EntityBuilder.buildAgentWorkStatusOverview(EntityBuilder.safeObject(jsonObject, "agent_overview")));
        agentWorkStatusStatistics.setAgentWorkStatus(EntityBuilder.buildAgentWorkStatusList(EntityBuilder.safeArray(jsonObject, "agent_table")));
        return agentWorkStatusStatistics;
    }

    private static AgentConversationOverview buildAgentConversationOverview(JSONObject jsonObject) {
        AgentConversationOverview conversationOverview = new AgentConversationOverview();
        if (jsonObject != null) {
            conversationOverview.setServeCount(EntityBuilder.safeInt(jsonObject, "serveCount"));
            conversationOverview.setAverageResponseTime(EntityBuilder.safeInt(jsonObject, "averageResponseTime"));
            conversationOverview.setAverageServeTime(EntityBuilder.safeInt(jsonObject, "averageServeTime"));
            conversationOverview.setSumResponseTime(EntityBuilder.safeInt(jsonObject, "sumResponseTime"));
            conversationOverview.setChatNum(EntityBuilder.safeInt(jsonObject, "chatNum"));
            conversationOverview.setSumServeTime(EntityBuilder.safeInt(jsonObject, "sumServeTime"));
        }
        return conversationOverview;
    }

    private static AgentConversation buildAgentConversation(JSONObject jsonObject) {
        AgentConversation agentConversation = new AgentConversation();
        if (jsonObject != null) {
            agentConversation.setServeCount(EntityBuilder.safeInt(jsonObject, "serveCount"));
            agentConversation.setSumResponseTime(EntityBuilder.safeInt(jsonObject, "sumResponseTime"));
            agentConversation.setChatNum(EntityBuilder.safeInt(jsonObject, "chatNum"));
            agentConversation.setMessageNum(EntityBuilder.safeInt(jsonObject, "messageNum"));
            agentConversation.setSumServeTime(EntityBuilder.safeInt(jsonObject, "sumServeTime"));
            agentConversation.setTimestamp(EntityBuilder.safeLong(jsonObject, "timestamp"));
        }
        return agentConversation;
    }

    private static List<AgentConversation> buildAgentConversationList(JSONArray jsonArray) {
        ArrayList<AgentConversation> list = new ArrayList<AgentConversation>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildAgentConversation(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    public static AgentConversationStatistics buildAgentConversationStatistics(JSONObject jsonObject) {
        AgentConversationStatistics agentConversationStatistics = new AgentConversationStatistics();
        agentConversationStatistics.setAgentConversationOverview(EntityBuilder.buildAgentConversationOverview(EntityBuilder.safeObject(jsonObject, "time_overview")));
        agentConversationStatistics.setAgentConversations(EntityBuilder.buildAgentConversationList(EntityBuilder.safeArray(jsonObject, "time_table")));
        return agentConversationStatistics;
    }

    private static AgentStatusSummary buildAgentStatusSummary(JSONObject jsonObject) {
        AgentStatusSummary agentStatusSummary = new AgentStatusSummary();
        if (jsonObject != null) {
            agentStatusSummary.setOnlineAverage(EntityBuilder.safeFloat(jsonObject, "onlineAverage").floatValue());
            agentStatusSummary.setBusyAverage(EntityBuilder.safeFloat(jsonObject, "busyAverage").floatValue());
            agentStatusSummary.setOnlineTotal(EntityBuilder.safeFloat(jsonObject, "onlineTotal").floatValue());
            agentStatusSummary.setBusyTotal(EntityBuilder.safeFloat(jsonObject, "busyTotal").floatValue());
        }
        return agentStatusSummary;
    }

    private static AgentStatusTime buildAgentStatusTime(JSONObject jsonObject) {
        AgentStatusTime agentStatusTime = new AgentStatusTime();
        if (jsonObject != null) {
            agentStatusTime.setAgent_id(EntityBuilder.safeInt(jsonObject, "agent_id"));
            agentStatusTime.setOnlineAverage(EntityBuilder.safeFloat(jsonObject, "onlineAverage").floatValue());
            agentStatusTime.setBusyAverage(EntityBuilder.safeFloat(jsonObject, "busyAverage").floatValue());
            agentStatusTime.setOnlineTotal(EntityBuilder.safeFloat(jsonObject, "onlineTotal").floatValue());
            agentStatusTime.setBusyTotal(EntityBuilder.safeFloat(jsonObject, "busyTotal").floatValue());
        }
        return agentStatusTime;
    }

    private static List<AgentStatusTime> buildAgentStatusTimeList(JSONArray jsonArray) {
        ArrayList<AgentStatusTime> list = new ArrayList<AgentStatusTime>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildAgentStatusTime(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    public static AgentStatusTimeStatistics buildAgentStatusTimeStatistics(JSONObject jsonObject) {
        AgentStatusTimeStatistics statistics = new AgentStatusTimeStatistics();
        statistics.setAgentStatusSummary(EntityBuilder.buildAgentStatusSummary(EntityBuilder.safeObject(jsonObject, "summary")));
        statistics.setAgentStatusTimes(EntityBuilder.buildAgentStatusTimeList(EntityBuilder.safeArray(jsonObject, "agents")));
        return statistics;
    }

    private static ChatSource buildChatSource(JSONObject jsonObject) {
        ChatSource chatSource = new ChatSource();
        if (jsonObject != null) {
            chatSource.setChatNum(EntityBuilder.safeInt(jsonObject, "chatNum"));
            chatSource.setMessageNum(EntityBuilder.safeInt(jsonObject, "messageNum"));
            chatSource.setType(EntityBuilder.safeGet(jsonObject, "type"));
        }
        return chatSource;
    }

    private static List<ChatSource> buildChatSourceList(JSONArray jsonArray) {
        ArrayList<ChatSource> list = new ArrayList<ChatSource>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildChatSource(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    private static ChatSourceOverview buildChatSourceOverview(JSONObject jsonObject) {
        ChatSourceOverview chatSourceOverview = new ChatSourceOverview();
        if (jsonObject != null) {
            chatSourceOverview.setMessageNum(EntityBuilder.safeInt(jsonObject, "messageNum"));
            chatSourceOverview.setChatNum(EntityBuilder.safeInt(jsonObject, "chatNum"));
        }
        return chatSourceOverview;
    }

    public static ChatSourceStatistics buildChatSourceStatistics(JSONObject jsonObject) {
        ChatSourceStatistics statistics = new ChatSourceStatistics();
        statistics.setChatSourceOverview(EntityBuilder.buildChatSourceOverview(EntityBuilder.safeObject(jsonObject, "source_overview")));
        statistics.setChatSources(EntityBuilder.buildChatSourceList(EntityBuilder.safeArray(jsonObject, "source_table")));
        return statistics;
    }

    public static AgentStatistics buildAgentStatistics(JSONObject jsonObject) {
        AgentStatistics statistics = new AgentStatistics();
        if (jsonObject != null) {
            statistics.setRole(EntityBuilder.safeGet(jsonObject, "role"));
            statistics.setAgent_id(EntityBuilder.safeInt(jsonObject, "agent_id"));
            statistics.setMax_serve(EntityBuilder.safeInt(jsonObject, "max_serve"));
            statistics.setCreated(EntityBuilder.safeLong(jsonObject, "created"));
            statistics.setName(EntityBuilder.safeGet(jsonObject, "name"));
            statistics.setPhoto(EntityBuilder.safeGet(jsonObject, "photo"));
            statistics.setDisplay_name(EntityBuilder.safeGet(jsonObject, "display_name"));
            statistics.setAppStatus(EntityBuilder.safeGet(jsonObject, "appStatus"));
            statistics.setWebStatus(EntityBuilder.safeGet(jsonObject, "webStatus"));
            statistics.setEmail(EntityBuilder.safeGet(jsonObject, "email"));
            statistics.setEnabled(EntityBuilder.safeInt(jsonObject, "enabled"));
        }
        return statistics;
    }

    public static VoiceCall buildVoiceCall(JSONObject jsonObject) {
        VoiceCall voiceCall = new VoiceCall();
        if (jsonObject != null) {
            voiceCall.setCallsid(EntityBuilder.safeGet(jsonObject, "callsid"));
            voiceCall.setRecordurl(EntityBuilder.safeGet(jsonObject, "recordurl"));
            voiceCall.setUser_name(EntityBuilder.safeGet(jsonObject, "user_name"));
            voiceCall.setAlerting_seconds(EntityBuilder.safeInt(jsonObject, "alerting_seconds"));
            voiceCall.setCreated_at(EntityBuilder.safeGet(jsonObject, "created_at"));
            voiceCall.setCallduration(EntityBuilder.safeInt(jsonObject, "callduration"));
            voiceCall.setType(EntityBuilder.safeGet(jsonObject, "type"));
            voiceCall.setDuration(EntityBuilder.safeInt(jsonObject, "duration"));
            voiceCall.setUser_id(EntityBuilder.safeInt(jsonObject, "user_id"));
            voiceCall.setFrom(EntityBuilder.safeGet(jsonObject, "from"));
            voiceCall.setId(EntityBuilder.safeInt(jsonObject, "id"));
            voiceCall.setTo(EntityBuilder.safeGet(jsonObject, "to"));
            voiceCall.setIs_answered(EntityBuilder.safeInt(jsonObject, "is_answered"));
            voiceCall.setAgent_id(EntityBuilder.safeInt(jsonObject, "agent_id"));
            voiceCall.setAgent_name(EntityBuilder.safeGet(jsonObject, "agent_name"));
            voiceCall.setSource(EntityBuilder.safeGet(jsonObject, "source"));
            voiceCall.setFromattr(EntityBuilder.safeGet(jsonObject, "fromattr"));
            voiceCall.setSatisfaction(EntityBuilder.safeGet(jsonObject, "satisfaction"));
        }
        return voiceCall;
    }

    public static List<VoiceCall> buildVoiceCallList(JSONArray jsonArray) {
        ArrayList<VoiceCall> list = new ArrayList<VoiceCall>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildVoiceCall(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    public static VoiceAccount buildVoiceAccount(JSONObject jsonObject) {
        VoiceAccount account = new VoiceAccount();
        if (jsonObject != null) {
            account.setVoip_account(EntityBuilder.safeGet(jsonObject, "voip_account"));
            account.setUser_id(EntityBuilder.safeGet(jsonObject, "user_id"));
            account.setCreated(EntityBuilder.safeGet(jsonObject, "created"));
            account.setStatus_updated(EntityBuilder.safeGet(jsonObject, "status_updated"));
            account.setId(EntityBuilder.safeGet(jsonObject, "id"));
            account.setVoip_pwd(EntityBuilder.safeGet(jsonObject, "voip_pwd"));
            account.setType(EntityBuilder.safeGet(jsonObject, "type"));
            account.setStatus(EntityBuilder.safeGet(jsonObject, "status"));
        }
        return account;
    }

    public static List<VoiceAccount> buildVoiceAccountList(JSONArray jsonArray) {
        ArrayList<VoiceAccount> list = new ArrayList<VoiceAccount>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildVoiceAccount(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    private static VoiceAgentLoginState buildVoiceAgentLoginState(JSONObject jsonObject) {
        VoiceAgentLoginState state = new VoiceAgentLoginState();
        if (jsonObject != null) {
            state.setAgent_id(EntityBuilder.safeGet(jsonObject, "agent_id"));
            state.setCreated(EntityBuilder.safeGet(jsonObject, "created"));
            state.setType(EntityBuilder.safeInt(jsonObject, "type"));
        }
        return state;
    }

    public static List<VoiceAgentLoginState> buildVoiceAgentLoginStateList(JSONArray jsonArray) {
        ArrayList<VoiceAgentLoginState> list = new ArrayList<VoiceAgentLoginState>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildVoiceAgentLoginState(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    private static VoiceCallUnAnswered buildVoiceCallUnAnswered(JSONObject jsonObject) {
        VoiceCallUnAnswered unAnswered = new VoiceCallUnAnswered();
        if (jsonObject != null) {
            unAnswered.setReason(EntityBuilder.safeGet(jsonObject, "reason"));
            unAnswered.setUser_id(EntityBuilder.safeGet(jsonObject, "user_id"));
            unAnswered.setCreated(EntityBuilder.safeGet(jsonObject, "created"));
            unAnswered.setAlerting_seconds(EntityBuilder.safeGet(jsonObject, "alerting_seconds"));
            unAnswered.setFrom(EntityBuilder.safeGet(jsonObject, "from"));
            unAnswered.setId(EntityBuilder.safeGet(jsonObject, "id"));
            unAnswered.setCallduration(EntityBuilder.safeGet(jsonObject, "callduration"));
        }
        return unAnswered;
    }

    public static List<VoiceCallUnAnswered> buildVoiceCallUnAnsweredList(JSONArray jsonArray) {
        ArrayList<VoiceCallUnAnswered> list = new ArrayList<VoiceCallUnAnswered>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildVoiceCallUnAnswered(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    private static AgentVoiceCallOutbound buildAgentVoiceCallOutbound(JSONObject jsonObject) {
        AgentVoiceCallOutbound outbound = new AgentVoiceCallOutbound();
        if (jsonObject != null) {
            outbound.setAgentid(EntityBuilder.safeInt(jsonObject, "agentid"));
            outbound.setTotal(EntityBuilder.safeInt(jsonObject, "total"));
            outbound.setAvg_callduration(EntityBuilder.safeInt(jsonObject, "avg_callduration"));
            outbound.setAgent_name(EntityBuilder.safeGet(jsonObject, "agent_name"));
            outbound.setCallduration(EntityBuilder.safeInt(jsonObject, "callduration"));
            outbound.setAnswer_rate(EntityBuilder.safeGet(jsonObject, "answer_rate"));
            outbound.setAnswer(EntityBuilder.safeInt(jsonObject, "answer"));
        }
        return outbound;
    }

    public static List<AgentVoiceCallOutbound> buildAgentVoiceCallOutboundList(JSONArray jsonArray) {
        ArrayList<AgentVoiceCallOutbound> list = new ArrayList<AgentVoiceCallOutbound>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildAgentVoiceCallOutbound(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    private static AgentVoiceCallInbound buildAgentVoiceCallInbound(JSONObject jsonObject) {
        AgentVoiceCallInbound inbound = new AgentVoiceCallInbound();
        if (jsonObject != null) {
            inbound.setAvg_callduration(EntityBuilder.safeInt(jsonObject, "avg_callduration"));
            inbound.setTicket_num(EntityBuilder.safeInt(jsonObject, "ticket_num"));
            inbound.setAgent_id(EntityBuilder.safeGet(jsonObject, "agent_id"));
            inbound.setAgent_name(EntityBuilder.safeGet(jsonObject, "agent_name"));
            inbound.setScore_rate(EntityBuilder.safeGet(jsonObject, "score_rate"));
            inbound.setCallduration(EntityBuilder.safeInt(jsonObject, "callduration"));
            inbound.setAnswer_rate(EntityBuilder.safeGet(jsonObject, "answer_rate"));
            inbound.setTotal(EntityBuilder.safeInt(jsonObject, "total"));
            inbound.setScore_num(EntityBuilder.safeInt(jsonObject, "score_num"));
            inbound.setAnswer(EntityBuilder.safeInt(jsonObject, "answer"));
            inbound.setCancel_rate(EntityBuilder.safeGet(jsonObject, "cancel_rate"));
            inbound.setUser_cancel(EntityBuilder.safeInt(jsonObject, "user_cancel"));
            inbound.setAvg_score(EntityBuilder.safeGet(jsonObject, "avg_score"));
        }
        return inbound;
    }

    public static List<AgentVoiceCallInbound> buildAgentVoiceCallInboundList(JSONArray jsonArray) {
        ArrayList<AgentVoiceCallInbound> list = new ArrayList<AgentVoiceCallInbound>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildAgentVoiceCallInbound(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    private static AgentVoicePerformance buildAgentVoicePerformance(JSONObject jsonObject) {
        AgentVoicePerformance performance = new AgentVoicePerformance();
        if (jsonObject != null) {
            performance.setAgentid(EntityBuilder.safeInt(jsonObject, "agentid"));
            performance.setAgent_name(EntityBuilder.safeGet(jsonObject, "agent_name"));
            performance.setAlerting_times(EntityBuilder.safeInt(jsonObject, "alerting_times"));
            performance.setTransfered_times(EntityBuilder.safeInt(jsonObject, "transfered_times"));
            performance.setTotal_holding_duration(EntityBuilder.safeInt(jsonObject, "total_holding_duration"));
            performance.setAvg_transfer_duration(EntityBuilder.safeInt(jsonObject, "avg_transfer_duration"));
            performance.setAvg_holding_duration(EntityBuilder.safeInt(jsonObject, "avg_holding_duration"));
            performance.setTransfer_times(EntityBuilder.safeInt(jsonObject, "transfer_times"));
            performance.setAvg_alerting_duration(EntityBuilder.safeInt(jsonObject, "avg_alerting_duration"));
            performance.setAvg_transfered_duration(EntityBuilder.safeInt(jsonObject, "avg_transfered_duration"));
            performance.setHolding_times(EntityBuilder.safeInt(jsonObject, "holding_times"));
            performance.setTotal_transfer_duration(EntityBuilder.safeInt(jsonObject, "total_transfer_duration"));
            performance.setTotal_alerting_duration(EntityBuilder.safeInt(jsonObject, "total_alerting_duration"));
            performance.setTotal_transfered_duration(EntityBuilder.safeInt(jsonObject, "total_transfered_duration"));
        }
        return performance;
    }

    public static List<AgentVoicePerformance> buildAgentVoicePerformanceList(JSONArray jsonArray) {
        ArrayList<AgentVoicePerformance> list = new ArrayList<AgentVoicePerformance>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildAgentVoicePerformance(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    private static AgentVoiceStateTime buildAgentVoiceStateTime(JSONObject jsonObject) {
        AgentVoiceStateTime time = new AgentVoiceStateTime();
        if (jsonObject != null) {
            time.setAvg_online_duration(EntityBuilder.safeInt(jsonObject, "avg_online_duration"));
            time.setAgentid(EntityBuilder.safeInt(jsonObject, "agentid"));
            time.setAgent_name(EntityBuilder.safeGet(jsonObject, "agent_name"));
            time.setAvg_break_duration(EntityBuilder.safeInt(jsonObject, "avg_break_duration"));
            time.setAvg_busy_duration(EntityBuilder.safeInt(jsonObject, "avg_busy_duration"));
            time.setOnline_duration(EntityBuilder.safeInt(jsonObject, "online_duration"));
            time.setBreak_duration(EntityBuilder.safeInt(jsonObject, "break_duration"));
            time.setBusy_duration(EntityBuilder.safeInt(jsonObject, "busy_duration"));
        }
        return time;
    }

    public static List<AgentVoiceStateTime> buildAgentVoiceStateTimeList(JSONArray jsonArray) {
        ArrayList<AgentVoiceStateTime> list = new ArrayList<AgentVoiceStateTime>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildAgentVoiceStateTime(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    private static AgentVoiceCallSubsectionInbound buildAgentVoiceCallSubsectionInbound(JSONObject jsonObject) {
        AgentVoiceCallSubsectionInbound inbound = new AgentVoiceCallSubsectionInbound();
        if (jsonObject != null) {
            inbound.setAvg_callduration(EntityBuilder.safeInt(jsonObject, "avg_callduration"));
            inbound.setTicket_num(EntityBuilder.safeInt(jsonObject, "ticket_num"));
            inbound.setAnswer(EntityBuilder.safeInt(jsonObject, "answer"));
            inbound.setAvg_response_duration(EntityBuilder.safeInt(jsonObject, "avg_response_duration"));
            inbound.setTime(EntityBuilder.safeGet(jsonObject, "time"));
            inbound.setAnswer_rate(EntityBuilder.safeGet(jsonObject, "answer_rate"));
            inbound.setAcd_cancel(EntityBuilder.safeInt(jsonObject, "acd_cancel"));
            inbound.setAgent_num(EntityBuilder.safeInt(jsonObject, "agent_num"));
            inbound.setIvr_cancel(EntityBuilder.safeInt(jsonObject, "ivr_cancel"));
            inbound.setAgent_reject(EntityBuilder.safeInt(jsonObject, "agent_reject"));
            inbound.setAvg_score(EntityBuilder.safeGet(jsonObject, "avg_score"));
        }
        return inbound;
    }

    public static List<AgentVoiceCallSubsectionInbound> buildAgentVoiceCallSubsectionInboundList(JSONArray jsonArray) {
        ArrayList<AgentVoiceCallSubsectionInbound> list = new ArrayList<AgentVoiceCallSubsectionInbound>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildAgentVoiceCallSubsectionInbound(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    private static AgentVoiceCallSubsectionOutbound buildAgentVoiceCallSubsectionOutbound(JSONObject jsonObject) {
        AgentVoiceCallSubsectionOutbound outbound = new AgentVoiceCallSubsectionOutbound();
        if (jsonObject != null) {
            outbound.setAvg_callduration(EntityBuilder.safeInt(jsonObject, "avg_callduration"));
            outbound.setTicket_num(EntityBuilder.safeInt(jsonObject, "ticket_num"));
            outbound.setAnswer(EntityBuilder.safeInt(jsonObject, "answer"));
            outbound.setUnanswer(EntityBuilder.safeInt(jsonObject, "unanswer"));
            outbound.setTime(EntityBuilder.safeGet(jsonObject, "time"));
            outbound.setAnswer_rate(EntityBuilder.safeGet(jsonObject, "answer_rate"));
            outbound.setAgent_num(EntityBuilder.safeInt(jsonObject, "agent_num"));
        }
        return outbound;
    }

    public static List<AgentVoiceCallSubsectionOutbound> buildAgentVoiceCallSubsectionOutboundList(JSONArray jsonArray) {
        ArrayList<AgentVoiceCallSubsectionOutbound> list = new ArrayList<AgentVoiceCallSubsectionOutbound>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildAgentVoiceCallSubsectionOutbound(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    private static VoiceQueueCall buildVoiceQueueCall(JSONObject jsonObject) {
        VoiceQueueCall call = new VoiceQueueCall();
        if (jsonObject != null) {
            call.setCallsid(EntityBuilder.safeGet(jsonObject, "callsid"));
            call.setNumber(EntityBuilder.safeGet(jsonObject, "number"));
            call.setSource(EntityBuilder.safeGet(jsonObject, "source"));
            call.setCreated(EntityBuilder.safeGet(jsonObject, "created"));
            call.setQueuetype(EntityBuilder.safeGet(jsonObject, "queuetype"));
            call.setFromattr(EntityBuilder.safeGet(jsonObject, "fromattr"));
            call.setUser_id(EntityBuilder.safeGet(jsonObject, "user_id"));
            call.setOrganization_name(EntityBuilder.safeGet(jsonObject, "organization_name"));
            call.setName(EntityBuilder.safeGet(jsonObject, "name"));
            call.setElaspe(EntityBuilder.safeInt(jsonObject, "elaspe"));
        }
        return call;
    }

    public static List<VoiceQueueCall> buildVoiceQueueCallList(JSONArray jsonArray) {
        ArrayList<VoiceQueueCall> list = new ArrayList<VoiceQueueCall>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildVoiceQueueCall(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    public static AgentVoiceStatus buildAgentVoiceStatus(JSONObject jsonObject) {
        AgentVoiceStatus status = new AgentVoiceStatus();
        if (jsonObject != null) {
            status.setAgent_id(EntityBuilder.safeGet(jsonObject, "agent_id"));
            status.setAgent_name(EntityBuilder.safeGet(jsonObject, "agent_name"));
            status.setUser_id(EntityBuilder.safeGet(jsonObject, "user_id"));
            status.setStatus_updated(EntityBuilder.safeGet(jsonObject, "status_updated"));
            status.setType(EntityBuilder.safeGet(jsonObject, "type"));
            status.setStatus(EntityBuilder.safeGet(jsonObject, "status"));
            status.setNumber(EntityBuilder.safeGet(jsonObject, "number"));
            status.setCall_status(EntityBuilder.safeGet(jsonObject, "call_status"));
        }
        return status;
    }

    public static List<AgentVoiceStatus> buildAgentVoiceStatusList(JSONArray jsonArray) {
        ArrayList<AgentVoiceStatus> list = new ArrayList<AgentVoiceStatus>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildAgentVoiceStatus(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    private static SystemLog buildSystemLog(JSONObject jsonObject) {
        SystemLog log = new SystemLog();
        if (jsonObject != null) {
            log.setUser_id(EntityBuilder.safeInt(jsonObject, "user_id"));
            log.setObject_type(EntityBuilder.safeGet(jsonObject, "object_type"));
            log.setUser_name(EntityBuilder.safeGet(jsonObject, "user_name"));
            log.setIp(EntityBuilder.safeGet(jsonObject, "ip"));
            log.setAction(EntityBuilder.safeGet(jsonObject, "action"));
            log.setCreated_at(EntityBuilder.safeGet(jsonObject, "created_at"));
            log.setId(EntityBuilder.safeInt(jsonObject, "id"));
            log.setObject(EntityBuilder.safeGet(jsonObject, "object"));
        }
        return log;
    }

    public static List<SystemLog> buildSystemLogList(JSONArray jsonArray) {
        ArrayList<SystemLog> list = new ArrayList<SystemLog>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildSystemLog(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    private static IMAgent buildIMAgent(JSONObject jsonObject) {
        IMAgent imAgent = new IMAgent();
        if (jsonObject != null) {
            imAgent.setMax_serve(EntityBuilder.safeInt(jsonObject, "max_serve"));
            imAgent.setApp_status(EntityBuilder.safeGet(jsonObject, "app_status"));
            imAgent.setName(EntityBuilder.safeGet(jsonObject, "name"));
            imAgent.setPhoto(EntityBuilder.safeGet(jsonObject, "photo"));
            imAgent.setWeb_status(EntityBuilder.safeGet(jsonObject, "web_status"));
            imAgent.setId(EntityBuilder.safeInt(jsonObject, "id"));
            imAgent.setDiplay_name(EntityBuilder.safeGet(jsonObject, "display_name"));
        }
        return imAgent;
    }

    private static List<IMAgent> buildIMAgentList(JSONArray jsonArray) {
        ArrayList<IMAgent> list = new ArrayList<IMAgent>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildIMAgent(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    private static IMGroup buildIMGroup(JSONObject jsonObject) {
        IMGroup group = new IMGroup();
        if (jsonObject != null) {
            group.setId(EntityBuilder.safeGet(jsonObject, "id"));
            group.setName(EntityBuilder.safeGet(jsonObject, "name"));
            group.setAgents(EntityBuilder.safeArray(jsonObject, "agents"));
        }
        return group;
    }

    private static List<IMGroup> buildIMGroupList(JSONArray jsonArray) {
        ArrayList<IMGroup> list = new ArrayList<IMGroup>();
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(EntityBuilder.buildIMGroup(jsonArray.getJSONObject(i)));
            }
        }
        return list;
    }

    public static IMAgentInfo buildIMAgentInfo(JSONObject jsonObject) {
        IMAgentInfo imAgentInfo = new IMAgentInfo();
        if (jsonObject != null) {
            imAgentInfo.setImAgents(EntityBuilder.buildIMAgentList(EntityBuilder.safeArray(jsonObject, "agents")));
            imAgentInfo.setImGroups(EntityBuilder.buildIMGroupList(EntityBuilder.safeArray(jsonObject, "groups")));
        }
        return imAgentInfo;
    }

    public static DocumentStats buildDocumentStats(JSONObject jsonObject) {
        DocumentStats stat = new DocumentStats();
        if (jsonObject != null) {
            DocumentStats.StatsValue statsValue = new DocumentStats.StatsValue(stat);
            stat.setId(EntityBuilder.safeGet(jsonObject, "id"));
            stat.setTitle(EntityBuilder.safeGet(jsonObject, "title"));
            JSONObject valueObj = EntityBuilder.safeObject(jsonObject, "values");
            if (valueObj != null) {
                statsValue.setUpdatedTime(EntityBuilder.safeGet(valueObj, "updatedTime"));
                statsValue.setCount_comment(EntityBuilder.safeGet(valueObj, "count_comment"));
                statsValue.setCount_vote(EntityBuilder.safeInt(valueObj, "count_vote"));
                statsValue.setAuthor(EntityBuilder.safeGet(valueObj, "author"));
                statsValue.setForumTitle(EntityBuilder.safeGet(valueObj, "forumTitle"));
                statsValue.setCount_view(EntityBuilder.safeInt(valueObj, "count_view"));
                statsValue.setCreatedTime(EntityBuilder.safeGet(valueObj, "createdTime"));
            }
            stat.setStatsValue(statsValue);
        }
        return stat;
    }

    public static List<DocumentStats> buildDocumentStatsList(JSONArray jsonArray) {
        if (jsonArray == null || jsonArray.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DocumentStats> list = new ArrayList<DocumentStats>();
        int size = jsonArray.size();
        for (int i = 0; i < size; ++i) {
            list.add(EntityBuilder.buildDocumentStats(jsonArray.getJSONObject(i)));
        }
        return list;
    }

    public static PostVote buildPostVote(JSONObject jsonObject) {
        PostVote postVote = new PostVote();
        if (jsonObject != null) {
            postVote.setPost_id(EntityBuilder.safeInt(jsonObject, "post_id"));
            postVote.setUser_id(EntityBuilder.safeGet(jsonObject, "user_id"));
            postVote.setUser_name(EntityBuilder.safeGet(jsonObject, "user_name"));
            postVote.setCreated_time(EntityBuilder.safeGet(jsonObject, "created_at"));
            postVote.setId(EntityBuilder.safeInt(jsonObject, "id"));
        }
        return postVote;
    }

    public static List<PostVote> buildPostVoteList(JSONArray jsonArray) {
        if (jsonArray == null || jsonArray.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PostVote> list = new ArrayList<PostVote>();
        int size = jsonArray.size();
        for (int i = 0; i < size; ++i) {
            list.add(EntityBuilder.buildPostVote(jsonArray.getJSONObject(i)));
        }
        return list;
    }
}

