/*
 * Decompiled with CFR 0.152.
 */
package org.kf5.support.fastjson.parser.deserializer;

import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.kf5.support.fastjson.JSONException;
import org.kf5.support.fastjson.parser.DefaultJSONParser;
import org.kf5.support.fastjson.parser.JSONScanner;
import org.kf5.support.fastjson.parser.deserializer.AbstractDateDeserializer;
import org.kf5.support.fastjson.parser.deserializer.ObjectDeserializer;

public class DateDeserializer
extends AbstractDateDeserializer
implements ObjectDeserializer {
    public static final DateDeserializer instance = new DateDeserializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T cast(DefaultJSONParser parser, Type clazz, Object fieldName, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Date) {
            return (T)val;
        }
        if (val instanceof Number) {
            return (T)new Date(((Number)val).longValue());
        }
        if (val instanceof String) {
            String strVal = (String)val;
            if (strVal.length() == 0) {
                return null;
            }
            try (JSONScanner dateLexer = new JSONScanner(strVal);){
                if (dateLexer.scanISO8601DateIfMatch(false)) {
                    Calendar calendar = dateLexer.getCalendar();
                    if (clazz == Calendar.class) {
                        Calendar calendar2 = calendar;
                        return (T)calendar2;
                    }
                    Date date = calendar.getTime();
                    return (T)date;
                }
            }
            DateFormat dateFormat = parser.getDateFormat();
            try {
                return (T)dateFormat.parse(strVal);
            }
            catch (ParseException parseException) {
                long longVal = Long.parseLong(strVal);
                return (T)new Date(longVal);
            }
        }
        throw new JSONException("parse error");
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

