/*
 * Decompiled with CFR 0.152.
 */
package org.kf5.support.fastjson.parser.deserializer;

import java.lang.reflect.Type;
import java.util.Map;
import org.kf5.support.fastjson.parser.DefaultJSONParser;
import org.kf5.support.fastjson.parser.JSONLexer;
import org.kf5.support.fastjson.parser.ParserConfig;
import org.kf5.support.fastjson.parser.deserializer.FieldDeserializer;
import org.kf5.support.fastjson.parser.deserializer.ObjectDeserializer;
import org.kf5.support.fastjson.util.FieldInfo;

public class StringFieldDeserializer
extends FieldDeserializer {
    private final ObjectDeserializer fieldValueDeserilizer;

    public StringFieldDeserializer(ParserConfig config, Class<?> clazz, FieldInfo fieldInfo) {
        super(clazz, fieldInfo);
        this.fieldValueDeserilizer = config.getDeserializer(fieldInfo);
    }

    @Override
    public void parseField(DefaultJSONParser parser, Object object, Type objectType, Map<String, Object> fieldValues) {
        String value;
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 4) {
            value = lexer.stringVal();
            lexer.nextToken(16);
        } else {
            Object obj = parser.parse();
            value = obj == null ? null : obj.toString();
        }
        if (object == null) {
            fieldValues.put(this.fieldInfo.getName(), value);
        } else {
            this.setValue(object, value);
        }
    }

    @Override
    public int getFastMatchToken() {
        return this.fieldValueDeserilizer.getFastMatchToken();
    }
}

