/*
 * Decompiled with CFR 0.152.
 */
package org.kf5.support.fastjson.serializer;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kf5.support.fastjson.parser.DefaultJSONParser;
import org.kf5.support.fastjson.parser.JSONLexer;
import org.kf5.support.fastjson.parser.deserializer.ObjectDeserializer;
import org.kf5.support.fastjson.serializer.JSONSerializer;
import org.kf5.support.fastjson.serializer.ObjectSerializer;
import org.kf5.support.fastjson.serializer.SerializeWriter;
import org.kf5.support.fastjson.serializer.SerializerFeature;
import org.kf5.support.fastjson.util.TypeUtils;

public class BooleanCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final BooleanCodec instance = new BooleanCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.getWriter();
        Boolean value = (Boolean)object;
        if (value == null) {
            if (out.isEnabled(SerializerFeature.WriteNullBooleanAsFalse)) {
                out.write("false");
            } else {
                out.writeNull();
            }
            return;
        }
        if (value.booleanValue()) {
            out.write("true");
        } else {
            out.write("false");
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        Boolean boolObj;
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 6) {
            lexer.nextToken(16);
            boolObj = Boolean.TRUE;
        } else if (lexer.token() == 7) {
            lexer.nextToken(16);
            boolObj = Boolean.FALSE;
        } else if (lexer.token() == 2) {
            int intValue = lexer.intValue();
            lexer.nextToken(16);
            boolObj = intValue == 1 ? Boolean.TRUE : Boolean.FALSE;
        } else {
            Object value = parser.parse();
            if (value == null) {
                return null;
            }
            boolObj = TypeUtils.castToBoolean(value);
        }
        if (clazz == AtomicBoolean.class) {
            return (T)new AtomicBoolean(boolObj);
        }
        return (T)boolObj;
    }

    @Override
    public int getFastMatchToken() {
        return 6;
    }
}

