/*
 * Decompiled with CFR 0.152.
 */
package org.kf5.support.fastjson.serializer;

import java.io.IOException;
import java.lang.reflect.Type;
import org.kf5.support.fastjson.parser.DefaultJSONParser;
import org.kf5.support.fastjson.parser.deserializer.ObjectDeserializer;
import org.kf5.support.fastjson.serializer.JSONSerializer;
import org.kf5.support.fastjson.serializer.ObjectSerializer;
import org.kf5.support.fastjson.serializer.SerializeWriter;
import org.kf5.support.fastjson.util.TypeUtils;

public class CharacterCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final CharacterCodec instance = new CharacterCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.getWriter();
        Character value = (Character)object;
        if (value == null) {
            out.writeString("");
            return;
        }
        char c = value.charValue();
        if (c == '\u0000') {
            out.writeString("\u0000");
        } else {
            out.writeString(value.toString());
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        Object value = parser.parse();
        if (value == null) {
            return null;
        }
        return (T)TypeUtils.castToChar(value);
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

