/*
 * Decompiled with CFR 0.152.
 */
package org.kf5.support.fastjson.serializer;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.sql.Clob;
import java.sql.SQLException;
import org.kf5.support.fastjson.serializer.JSONSerializer;
import org.kf5.support.fastjson.serializer.ObjectSerializer;

public class ClobSeriliazer
implements ObjectSerializer {
    public static final ClobSeriliazer instance = new ClobSeriliazer();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        try {
            if (object == null) {
                serializer.writeNull();
                return;
            }
            Clob clob = (Clob)object;
            Reader reader = clob.getCharacterStream();
            StringWriter writer = new StringWriter();
            char[] buf = new char[1024];
            int len = 0;
            while ((len = reader.read(buf)) != -1) {
                writer.write(buf, 0, len);
            }
            reader.close();
            String text = writer.toString();
            serializer.write(text);
        }
        catch (SQLException e) {
            throw new IOException("write clob error", e);
        }
    }
}

