/*
 * Decompiled with CFR 0.152.
 */
package org.kf5.support.fastjson.serializer;

import java.io.IOException;
import java.lang.reflect.Type;
import org.kf5.support.fastjson.parser.DefaultJSONParser;
import org.kf5.support.fastjson.parser.JSONLexer;
import org.kf5.support.fastjson.parser.deserializer.ObjectDeserializer;
import org.kf5.support.fastjson.serializer.JSONSerializer;
import org.kf5.support.fastjson.serializer.ObjectSerializer;
import org.kf5.support.fastjson.serializer.SerializeWriter;
import org.kf5.support.fastjson.serializer.SerializerFeature;
import org.kf5.support.fastjson.util.TypeUtils;

public class FloatCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static FloatCodec instance = new FloatCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            if (serializer.isEnabled(SerializerFeature.WriteNullNumberAsZero)) {
                out.write('0');
            } else {
                out.writeNull();
            }
            return;
        }
        float floatValue = ((Float)object).floatValue();
        if (Float.isNaN(floatValue)) {
            out.writeNull();
        } else if (Float.isInfinite(floatValue)) {
            out.writeNull();
        } else {
            String floatText = Float.toString(floatValue);
            if (floatText.endsWith(".0")) {
                floatText = floatText.substring(0, floatText.length() - 2);
            }
            out.write(floatText);
            if (serializer.isEnabled(SerializerFeature.WriteClassName)) {
                out.write('F');
            }
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        return FloatCodec.deserialze(parser);
    }

    public static <T> T deserialze(DefaultJSONParser parser) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 2) {
            String val = lexer.numberString();
            lexer.nextToken(16);
            return (T)Float.valueOf(Float.parseFloat(val));
        }
        if (lexer.token() == 3) {
            float val = lexer.floatValue();
            lexer.nextToken(16);
            return (T)Float.valueOf(val);
        }
        Object value = parser.parse();
        if (value == null) {
            return null;
        }
        return (T)TypeUtils.castToFloat(value);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

