/*
 * Decompiled with CFR 0.152.
 */
package org.kf5.support.fastjson.serializer;

import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import org.kf5.support.fastjson.parser.DefaultJSONParser;
import org.kf5.support.fastjson.parser.deserializer.ObjectDeserializer;
import org.kf5.support.fastjson.serializer.JSONSerializer;
import org.kf5.support.fastjson.serializer.ObjectSerializer;

public class URICodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final URICodec instance = new URICodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        if (object == null) {
            serializer.writeNull();
            return;
        }
        URI uri = (URI)object;
        serializer.write(uri.toString());
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        String uri = (String)parser.parse();
        if (uri == null) {
            return null;
        }
        return (T)URI.create(uri);
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

