/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openapitools.api.ApiUtil;
import org.openapitools.model.AddOrganizationUsersRequest;
import org.openapitools.model.AddOrganizationUsersResponse;
import org.openapitools.model.ConnectedAppsAccessToken;
import org.openapitools.model.ConnectedAppsAuthUrl;
import org.openapitools.model.CreateApplicationRequest;
import org.openapitools.model.CreateApplicationResponse;
import org.openapitools.model.CreateFeatureFlagRequest;
import org.openapitools.model.CreateOrganizationRequest;
import org.openapitools.model.CreateOrganizationResponse;
import org.openapitools.model.CreateOrganizationUserRoleRequest;
import org.openapitools.model.CreatePermissionRequest;
import org.openapitools.model.CreateRoleRequest;
import org.openapitools.model.CreateSubscriberSuccessResponse;
import org.openapitools.model.CreateUserRequest;
import org.openapitools.model.CreateUserResponse;
import org.openapitools.model.ErrorResponse;
import org.openapitools.model.GetApplicationResponse;
import org.openapitools.model.GetApplicationsResponse;
import org.openapitools.model.GetEnvironmentFeatureFlagsResponse;
import org.openapitools.model.GetOrganizationFeatureFlagsResponse;
import org.openapitools.model.GetOrganizationUsersResponse;
import org.openapitools.model.GetOrganizationsResponse;
import org.openapitools.model.GetOrganizationsUserRolesResponse;
import org.openapitools.model.GetRolesResponse;
import org.openapitools.model.GetSubscriberResponse;
import org.openapitools.model.GetSubscribersResponse;
import org.openapitools.model.Organization;
import org.openapitools.model.RedirectCallbackUrls;
import org.openapitools.model.ReplaceRedirectCallbackURLsRequest;
import org.openapitools.model.SuccessResponse;
import org.openapitools.model.UpdateApplicationRequest;
import org.openapitools.model.UpdateEnvironementFeatureFlagOverrideRequest;
import org.openapitools.model.UpdateOrganizationRequest;
import org.openapitools.model.UpdateOrganizationUsersRequest;
import org.openapitools.model.UpdateOrganizationUsersResponse;
import org.openapitools.model.UpdateRolePermissionsRequest;
import org.openapitools.model.UpdateRolePermissionsResponse;
import org.openapitools.model.UpdateRolesRequest;
import org.openapitools.model.UpdateUserRequest;
import org.openapitools.model.User;
import org.openapitools.model.UsersResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.NativeWebRequest;

@Validated
@Tag(name="Organizations", description="the Organizations API")
public interface ApiApi {
    default public Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    @Operation(operationId="addOrganizationUsers", summary="Add Organization Users", description="Add existing users to an organization.", tags={"Organizations"}, responses={@ApiResponse(responseCode="200", description="Users successfully added.", content={@Content(mediaType="application/json", schema=@Schema(implementation=AddOrganizationUsersResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=AddOrganizationUsersResponse.class))}), @ApiResponse(responseCode="204", description="No users added."), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/organizations/{org_code}/users"}, produces={"application/json", "application/json; charset=utf-8"}, consumes={"application/json"})
    default public ResponseEntity<AddOrganizationUsersResponse> addOrganizationUsers(@Parameter(name="org_code", description="The organization's code.", required=true, in=ParameterIn.PATH) @PathVariable(value="org_code") String orgCode, @Parameter(name="AddOrganizationUsersRequest", description="") @Valid @RequestBody(required=false) AddOrganizationUsersRequest addOrganizationUsersRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"users_added\" : [ \"users_added\", \"users_added\" ], \"code\" : \"code\", \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"users_added\" : [ \"users_added\", \"users_added\" ], \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="addRedirectCallbackURLs", summary="Add Redirect Callback URLs", description="Add additional redirect callback URLs. ", tags={"Callbacks"}, responses={@ApiResponse(responseCode="200", description="Callbacks successfully updated", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/applications/{app_id}/auth_redirect_urls"}, produces={"application/json; charset=utf-8"}, consumes={"application/json"})
    default public ResponseEntity<SuccessResponse> addRedirectCallbackURLs(@Parameter(name="app_id", description="The identifier for the application.", required=true, in=ParameterIn.PATH) @PathVariable(value="app_id") String appId, @Parameter(name="ReplaceRedirectCallbackURLsRequest", description="Callback details.", required=true) @Valid @RequestBody ReplaceRedirectCallbackURLsRequest replaceRedirectCallbackURLsRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="createApplication", summary="Create Application", description="Create an application.", tags={"Applications"}, responses={@ApiResponse(responseCode="200", description="Application successfully created.", content={@Content(mediaType="application/json", schema=@Schema(implementation=CreateApplicationResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=CreateApplicationResponse.class))}), @ApiResponse(responseCode="400", description="Error creating user.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/applications"}, produces={"application/json", "application/json; charset=utf-8"}, consumes={"application/json"})
    default public ResponseEntity<CreateApplicationResponse> createApplication(@Parameter(name="CreateApplicationRequest", description="Application details.") @Valid @RequestBody(required=false) CreateApplicationRequest createApplicationRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"application\" : { \"id\" : \"id\", \"client_secret\" : \"client_secret\", \"client_id\" : \"client_id\" }, \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"application\" : { \"id\" : \"id\", \"client_secret\" : \"client_secret\", \"client_id\" : \"client_id\" }, \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="createFeatureFlag", summary="Create Feature Flag", description="Create feature flag.", tags={"Feature Flags"}, responses={@ApiResponse(responseCode="201", description="Feature flag successfully created", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/feature_flags"}, produces={"application/json", "application/json; charset=utf-8"}, consumes={"application/json"})
    default public ResponseEntity<SuccessResponse> createFeatureFlag(@Parameter(name="CreateFeatureFlagRequest", description="Flag details.", required=true) @Valid @RequestBody CreateFeatureFlagRequest createFeatureFlagRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="createOrganization", summary="Create Organization", description="Create an organization.", tags={"Organizations"}, responses={@ApiResponse(responseCode="200", description="Organization successfully created.", content={@Content(mediaType="application/json", schema=@Schema(implementation=CreateOrganizationResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=CreateOrganizationResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials."), @ApiResponse(responseCode="400", description="Error creating user.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="500", description="Could not create organization.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/organization"}, produces={"application/json", "application/json; charset=utf-8"}, consumes={"application/json"})
    default public ResponseEntity<CreateOrganizationResponse> createOrganization(@Parameter(name="CreateOrganizationRequest", description="Organization details.") @Valid @RequestBody(required=false) CreateOrganizationRequest createOrganizationRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"organization\" : { \"code\" : \"code\" }, \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"organization\" : { \"code\" : \"code\" }, \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="createOrganizationUserRole", summary="Add Organization User Role", description="Add role to an organization user.", tags={"Organizations"}, responses={@ApiResponse(responseCode="200", description="User successfully removed from", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/organizations/{org_code}/users/{user_id}/roles"}, produces={"application/json", "application/json; charset=utf-8"}, consumes={"application/json"})
    default public ResponseEntity<SuccessResponse> createOrganizationUserRole(@Parameter(name="org_code", description="The organization's code.", required=true, in=ParameterIn.PATH) @PathVariable(value="org_code") String orgCode, @Parameter(name="user_id", description="The user's id.", required=true, in=ParameterIn.PATH) @PathVariable(value="user_id") String userId, @Parameter(name="CreateOrganizationUserRoleRequest", description="Role details.", required=true) @Valid @RequestBody CreateOrganizationUserRoleRequest createOrganizationUserRoleRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="createPermission", summary="Create Permission", description="Create a new permission.", tags={"Permissions"}, responses={@ApiResponse(responseCode="201", description="Permission successfully created", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/permissions"}, produces={"application/json; charset=utf-8"}, consumes={"application/json"})
    default public ResponseEntity<SuccessResponse> createPermission(@Parameter(name="CreatePermissionRequest", description="Permission details.") @Valid @RequestBody(required=false) CreatePermissionRequest createPermissionRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="createRole", summary="Create Role", description="Create role.", tags={"Roles"}, responses={@ApiResponse(responseCode="201", description="Role successfully created", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/role"}, produces={"application/json; charset=utf-8"}, consumes={"application/json"})
    default public ResponseEntity<SuccessResponse> createRole(@Parameter(name="CreateRoleRequest", description="Role details.") @Valid @RequestBody(required=false) CreateRoleRequest createRoleRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="createSubscriber", summary="Create Subscriber", description="Create subscriber.", tags={"Subscribers"}, responses={@ApiResponse(responseCode="201", description="Subscriber successfully created", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=CreateSubscriberSuccessResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/subscribers"}, produces={"application/json; charset=utf-8"})
    default public ResponseEntity<CreateSubscriberSuccessResponse> createSubscriber(@NotNull @Parameter(name="first_name", description="Subscriber's first name.", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="first_name", required=true) String firstName, @NotNull @Parameter(name="last_name", description="Subscriber's last name.", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="last_name", required=true) String lastName, @NotNull @Parameter(name="email", description="The email address of the subscriber.", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="email", required=true) String email) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"subscriber\" : { \"subscriber_id\" : \"subscriber_id\" } }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="createUser", summary="Create User", description="Creates a user record and optionally zero or more identities for the user. An example identity could be the email address of the user. ", tags={"Users"}, responses={@ApiResponse(responseCode="200", description="User successfully created.", content={@Content(mediaType="application/json", schema=@Schema(implementation=CreateUserResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=CreateUserResponse.class))}), @ApiResponse(responseCode="400", description="Error creating user.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/user"}, produces={"application/json", "application/json; charset=utf-8"}, consumes={"application/json"})
    default public ResponseEntity<CreateUserResponse> createUser(@Parameter(name="CreateUserRequest", description="The details of the user to create.") @Valid @RequestBody(required=false) CreateUserRequest createUserRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"identities\" : [ { \"result\" : { \"created\" : true }, \"type\" : \"type\" }, { \"result\" : { \"created\" : true }, \"type\" : \"type\" } ], \"created\" : true, \"id\" : \"id\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"identities\" : [ { \"result\" : { \"created\" : true }, \"type\" : \"type\" }, { \"result\" : { \"created\" : true }, \"type\" : \"type\" } ], \"created\" : true, \"id\" : \"id\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="deleteCallbackURLs", summary="Delete Callback URLs", description="Delete callback URLs. ", tags={"Callbacks"}, responses={@ApiResponse(responseCode="200", description="Callback URLs successfully deleted.", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/v1/applications/{app_id}/auth_redirect_urls"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<SuccessResponse> deleteCallbackURLs(@Parameter(name="app_id", description="The identifier for the application.", required=true, in=ParameterIn.PATH) @PathVariable(value="app_id") String appId, @NotNull @Parameter(name="urls", description="Urls to delete, comma separated and url encoded.", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="urls", required=true) String urls) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="deleteEnvironementFeatureFlagOverride", summary="Delete Environment Feature Flag Override", description="Delete environment feature flag override.", tags={"Environments"}, responses={@ApiResponse(responseCode="200", description="Feature flag deleted successfully.", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/v1/environment/feature_flags/{feature_flag_key}"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<SuccessResponse> deleteEnvironementFeatureFlagOverride(@Parameter(name="feature_flag_key", description="The identifier for the feature flag.", required=true, in=ParameterIn.PATH) @PathVariable(value="feature_flag_key") String featureFlagKey) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="deleteEnvironementFeatureFlagOverrides", summary="Delete Environment Feature Flag Overrides", description="Delete all environment feature flag overrides.", tags={"Environments"}, responses={@ApiResponse(responseCode="200", description="Feature flag overrides deleted successfully.", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/v1/environment/feature_flags"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<SuccessResponse> deleteEnvironementFeatureFlagOverrides() {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="deleteFeatureFlag", summary="Delete Feature Flag", description="Delete feature flag", tags={"Feature Flags"}, responses={@ApiResponse(responseCode="200", description="Feature flag successfully updated.", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/v1/feature_flags/{feature_flag_key}"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<SuccessResponse> deleteFeatureFlag(@Parameter(name="feature_flag_key", description="The identifier for the feature flag.", required=true, in=ParameterIn.PATH) @PathVariable(value="feature_flag_key") String featureFlagKey) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="deleteOrganization", summary="Delete Organization", description="Delete an organization.", tags={"Organizations"}, responses={@ApiResponse(responseCode="200", description="Organization successfully deleted."), @ApiResponse(responseCode="403", description="Invalid credentials."), @ApiResponse(responseCode="400", description="Error deleting organization.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/v1/organization/{org_code}"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<Void> deleteOrganization(@Parameter(name="org_code", description="The identifier for the organization.", required=true, in=ParameterIn.PATH) @PathVariable(value="org_code") String orgCode) {
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="deleteOrganizationFeatureFlagOverride", summary="Delete Organization Feature Flag Override", description="Delete organization feature flag override.", tags={"Organizations"}, responses={@ApiResponse(responseCode="200", description="Feature flag override successfully deleted.", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/v1/organizations/{org_code}/feature_flags/{feature_flag_key}"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<SuccessResponse> deleteOrganizationFeatureFlagOverride(@Parameter(name="org_code", description="The identifier for the organization.", required=true, in=ParameterIn.PATH) @PathVariable(value="org_code") String orgCode, @Parameter(name="feature_flag_key", description="The identifier for the feature flag.", required=true, in=ParameterIn.PATH) @PathVariable(value="feature_flag_key") String featureFlagKey) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="deleteOrganizationFeatureFlagOverrides", summary="Delete Organization Feature Flag Overrides", description="Delete all organization feature flag overrides.", tags={"Organizations"}, responses={@ApiResponse(responseCode="200", description="Feature flag overrides successfully deleted.", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/v1/organizations/{org_code}/feature_flags"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<SuccessResponse> deleteOrganizationFeatureFlagOverrides(@Parameter(name="org_code", description="The identifier for the organization.", required=true, in=ParameterIn.PATH) @PathVariable(value="org_code") String orgCode) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="deleteOrganizationUserRole", summary="Delete Organization User Role", description="Delete role for an organization user.", tags={"Organizations"}, responses={@ApiResponse(responseCode="200", description="User successfully removed.", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Error creating user.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/v1/organizations/{org_code}/users/{user_id}/roles/{role_id}"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<SuccessResponse> deleteOrganizationUserRole(@Parameter(name="org_code", description="The organization's code.", required=true, in=ParameterIn.PATH) @PathVariable(value="org_code") String orgCode, @Parameter(name="user_id", description="The user's id.", required=true, in=ParameterIn.PATH) @PathVariable(value="user_id") String userId, @Parameter(name="role_id", description="The role id.", required=true, in=ParameterIn.PATH) @PathVariable(value="role_id") String roleId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="deleteUser", summary="Delete User", description="Delete a user record. ", tags={"Users"}, responses={@ApiResponse(responseCode="200", description="User successfully deleted.", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/v1/user"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<SuccessResponse> deleteUser(@NotNull @Parameter(name="id", description="The user's id.", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="id", required=true) String id, @Parameter(name="is_delete_profile", description="Delete all data and remove the user's profile from all of Kinde, including the subscriber list", in=ParameterIn.QUERY) @Valid @RequestParam(value="is_delete_profile", required=false) String isDeleteProfile) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getApplication", summary="Get Application", description="Gets an application given the application's id. ", tags={"Applications"}, responses={@ApiResponse(responseCode="200", description="Application successfully retrieved.", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetApplicationResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=GetApplicationResponse.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/applications/{application_id}"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<GetApplicationResponse> getApplication(@Parameter(name="application_id", description="The identifier for the application.", required=true, in=ParameterIn.PATH) @PathVariable(value="application_id") String applicationId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"application\" : { \"name\" : \"name\", \"id\" : \"id\", \"client_secret\" : \"client_secret\", \"type\" : \"type\", \"client_id\" : \"client_id\" }, \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"application\" : { \"name\" : \"name\", \"id\" : \"id\", \"client_secret\" : \"client_secret\", \"type\" : \"type\", \"client_id\" : \"client_id\" }, \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getApplications", summary="List Applications", description="Get a list of applications. ", tags={"Applications"}, responses={@ApiResponse(responseCode="200", description="A successful response with a list of applications or an empty list.", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetApplicationsResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=GetApplicationsResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/applications"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<GetApplicationsResponse> getApplications(@Parameter(name="sort", description="Field and order to sort the result by.", in=ParameterIn.QUERY) @Valid @RequestParam(value="sort", required=false) String sort, @Parameter(name="page_size", description="Number of results per page. Defaults to 10 if parameter not sent.", in=ParameterIn.QUERY) @Valid @RequestParam(value="page_size", required=false) Integer pageSize, @Parameter(name="next_token", description="A string to get the next page of results if there are more results.", in=ParameterIn.QUERY) @Valid @RequestParam(value="next_token", required=false) String nextToken) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\", \"next_token\" : \"next_token\", \"applications\" : [ { \"name\" : \"name\", \"id\" : \"id\", \"type\" : \"type\" }, { \"name\" : \"name\", \"id\" : \"id\", \"type\" : \"type\" } ] }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\", \"next_token\" : \"next_token\", \"applications\" : [ { \"name\" : \"name\", \"id\" : \"id\", \"type\" : \"type\" }, { \"name\" : \"name\", \"id\" : \"id\", \"type\" : \"type\" } ] }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getBusiness", summary="List business details", description="Get your business details.", tags={"Business"}, responses={@ApiResponse(responseCode="201", description="A successful response with your business details.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/business"}, produces={"application/json; charset=utf-8"})
    default public ResponseEntity<SuccessResponse> getBusiness(@NotNull @Parameter(name="code", description="Business code.", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="code", required=true) String code, @NotNull @Parameter(name="name", description="Business name.", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="name", required=true) String name, @NotNull @Parameter(name="email", description="Email associated with business.", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="email", required=true) String email, @Parameter(name="phone", description="Phone number associated with business.", in=ParameterIn.QUERY) @Valid @RequestParam(value="phone", required=false) String phone, @Parameter(name="industry", description="The industry your business is in.", in=ParameterIn.QUERY) @Valid @RequestParam(value="industry", required=false) String industry, @Parameter(name="timezone", description="The timezone your business is in.", in=ParameterIn.QUERY) @Valid @RequestParam(value="timezone", required=false) String timezone, @Parameter(name="privacy_url", description="Your Privacy policy URL.", in=ParameterIn.QUERY) @Valid @RequestParam(value="privacy_url", required=false) String privacyUrl, @Parameter(name="terms_url", description="Your Terms and Conditions URL.", in=ParameterIn.QUERY) @Valid @RequestParam(value="terms_url", required=false) String termsUrl) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getCallbackURLs", summary="List Callback URLs", description="Returns an application's redirect callback URLs. ", tags={"Callbacks"}, responses={@ApiResponse(responseCode="200", description="Callback URLs successfully retrieved.", content={@Content(mediaType="application/json", schema=@Schema(implementation=RedirectCallbackUrls.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=RedirectCallbackUrls.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/applications/{app_id}/auth_redirect_urls"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<RedirectCallbackUrls> getCallbackURLs(@Parameter(name="app_id", description="The identifier for the application.", required=true, in=ParameterIn.PATH) @PathVariable(value="app_id") String appId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"redirect_urls\" : [ \"redirect_urls\", \"redirect_urls\" ] }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"redirect_urls\" : [ \"redirect_urls\", \"redirect_urls\" ] }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getConnectedAppAuthUrl", summary="Get Connected App URL", description="Get a URL that authenticates and authorizes a user to a third-party connected app.", tags={"Connected Apps"}, responses={@ApiResponse(responseCode="200", description="A URL that can be used to authenticate and a session id to identify this authentication session.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConnectedAppsAuthUrl.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ConnectedAppsAuthUrl.class))}), @ApiResponse(responseCode="400", description="Error retrieving connected app auth url.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="404", description="Error retrieving connected app auth url.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/connected_apps/auth_url"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<ConnectedAppsAuthUrl> getConnectedAppAuthUrl(@NotNull @Parameter(name="key_code_ref", description="The unique key code reference of the connected app to authenticate against.", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="key_code_ref", required=true) String keyCodeRef, @NotNull @Parameter(name="user_id", description="The id of the user that needs to authenticate to the third-party connected app.", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="user_id", required=true) String userId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"session_id\" : \"session_id\", \"url\" : \"url\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"session_id\" : \"session_id\", \"url\" : \"url\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getConnectedAppToken", summary="Get Connected App Token", description="Get an access token that can be used to call the third-party provider linked to the connected app.", tags={"Connected Apps"}, responses={@ApiResponse(responseCode="200", description="An access token that can be used to query a third-party provider, as well as the token's expiry time.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ConnectedAppsAccessToken.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ConnectedAppsAccessToken.class))}), @ApiResponse(responseCode="400", description="The session id provided points to an invalid session.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/connected_apps/token"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<ConnectedAppsAccessToken> getConnectedAppToken(@NotNull @Parameter(name="session_id", description="The unique sesssion id reprensenting the login session of a user.", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="session_id", required=true) String sessionId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"access_token\" : \"access_token\", \"access_token_expiry\" : \"access_token_expiry\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"access_token\" : \"access_token\", \"access_token_expiry\" : \"access_token_expiry\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getEnvironementFeatureFlags", summary="List Environment Feature Flags", description="Get environment feature flags.", tags={"Environments"}, responses={@ApiResponse(responseCode="200", description="Feature flags retrieved successfully.", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetEnvironmentFeatureFlagsResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=GetEnvironmentFeatureFlagsResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/environment/feature_flags"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<GetEnvironmentFeatureFlagsResponse> getEnvironementFeatureFlags() {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"feature_flags\" : { \"key\" : { \"type\" : \"str\", \"value\" : \"value\" } }, \"message\" : \"message\", \"next_token\" : \"next_token\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"feature_flags\" : { \"key\" : { \"type\" : \"str\", \"value\" : \"value\" } }, \"message\" : \"message\", \"next_token\" : \"next_token\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getIndustries", summary="List industries and industry keys.", description="Get a list of industries and associated industry keys.", tags={"Industries"}, responses={@ApiResponse(responseCode="201", description="A successful response with a list of industries and industry keys.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/industries"}, produces={"application/json; charset=utf-8"})
    default public ResponseEntity<SuccessResponse> getIndustries(@Parameter(name="industry_key", description="Industry Key.", in=ParameterIn.QUERY) @Valid @RequestParam(value="industry_key", required=false) String industryKey, @Parameter(name="name", description="Industry name.", in=ParameterIn.QUERY) @Valid @RequestParam(value="name", required=false) String name) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getOrganization", summary="Get Organization", description="Gets an organization given the organization's code. ", tags={"Organizations"}, responses={@ApiResponse(responseCode="200", description="Organization successfully retrieved.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Organization.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=Organization.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/organization"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<Organization> getOrganization(@Parameter(name="code", description="The organization's code.", in=ParameterIn.QUERY) @Valid @RequestParam(value="code", required=false) String code) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"name\" : \"name\", \"is_default\" : true }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"name\" : \"name\", \"is_default\" : true }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getOrganizationFeatureFlags", summary="List Organization Feature Flags", description="Get all organization feature flags.", tags={"Organizations"}, responses={@ApiResponse(responseCode="200", description="Feature flag overrides successfully returned.", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetOrganizationFeatureFlagsResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=GetOrganizationFeatureFlagsResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/organizations/{org_code}/feature_flags"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<GetOrganizationFeatureFlagsResponse> getOrganizationFeatureFlags(@Parameter(name="org_code", description="The identifier for the organization.", required=true, in=ParameterIn.PATH) @PathVariable(value="org_code") String orgCode) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"feature_flags\" : { \"key\" : { \"type\" : \"str\", \"value\" : \"value\" } }, \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"feature_flags\" : { \"key\" : { \"type\" : \"str\", \"value\" : \"value\" } }, \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getOrganizationUserRoles", summary="List Organization User Roles", description="Get roles for an organization user.", tags={"Organizations"}, responses={@ApiResponse(responseCode="200", description="A successful response with a list of user roles.", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetOrganizationsUserRolesResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=GetOrganizationsUserRolesResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/organizations/{org_code}/users/{user_id}/roles"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<GetOrganizationsUserRolesResponse> getOrganizationUserRoles(@Parameter(name="org_code", description="The organization's code.", required=true, in=ParameterIn.PATH) @PathVariable(value="org_code") String orgCode, @Parameter(name="user_id", description="The user's id.", required=true, in=ParameterIn.PATH) @PathVariable(value="user_id") String userId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"roles\" : [ { \"name\" : \"name\", \"id\" : \"id\", \"key\" : \"key\" }, { \"name\" : \"name\", \"id\" : \"id\", \"key\" : \"key\" } ], \"message\" : \"message\", \"next_token\" : \"next_token\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"roles\" : [ { \"name\" : \"name\", \"id\" : \"id\", \"key\" : \"key\" }, { \"name\" : \"name\", \"id\" : \"id\", \"key\" : \"key\" } ], \"message\" : \"message\", \"next_token\" : \"next_token\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getOrganizationUsers", summary="List Organization Users", description="Get users in an organization.", tags={"Organizations"}, responses={@ApiResponse(responseCode="200", description="A successful response with a list of organization users or an empty list.", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetOrganizationUsersResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=GetOrganizationUsersResponse.class))}), @ApiResponse(responseCode="400", description="Error creating user", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/organizations/{org_code}/users"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<GetOrganizationUsersResponse> getOrganizationUsers(@Parameter(name="org_code", description="The organization's code.", required=true, in=ParameterIn.PATH) @PathVariable(value="org_code") String orgCode, @Parameter(name="sort", description="Field and order to sort the result by.", in=ParameterIn.QUERY) @Valid @RequestParam(value="sort", required=false) String sort, @Parameter(name="page_size", description="Number of results per page. Defaults to 10 if parameter not sent.", in=ParameterIn.QUERY) @Valid @RequestParam(value="page_size", required=false) Integer pageSize, @Parameter(name="next_token", description="A string to get the next page of results if there are more results.", in=ParameterIn.QUERY) @Valid @RequestParam(value="next_token", required=false) String nextToken, @Parameter(name="permissions", description="Filter by user permissions", in=ParameterIn.QUERY) @Valid @RequestParam(value="permissions", required=false) String permissions) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"organization_users\" : [ { \"full_name\" : \"full_name\", \"roles\" : [ \"roles\", \"roles\" ], \"last_name\" : \"last_name\", \"id\" : \"id\", \"first_name\" : \"first_name\", \"email\" : \"email\" }, { \"full_name\" : \"full_name\", \"roles\" : [ \"roles\", \"roles\" ], \"last_name\" : \"last_name\", \"id\" : \"id\", \"first_name\" : \"first_name\", \"email\" : \"email\" } ], \"message\" : \"message\", \"next_token\" : \"next_token\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"organization_users\" : [ { \"full_name\" : \"full_name\", \"roles\" : [ \"roles\", \"roles\" ], \"last_name\" : \"last_name\", \"id\" : \"id\", \"first_name\" : \"first_name\", \"email\" : \"email\" }, { \"full_name\" : \"full_name\", \"roles\" : [ \"roles\", \"roles\" ], \"last_name\" : \"last_name\", \"id\" : \"id\", \"first_name\" : \"first_name\", \"email\" : \"email\" } ], \"message\" : \"message\", \"next_token\" : \"next_token\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getOrganizations", summary="List Organizations", description="Get a list of organizations. ", tags={"Organizations"}, responses={@ApiResponse(responseCode="200", description="A successful response with a list of organizations or an empty list.", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetOrganizationsResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=GetOrganizationsResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/organizations"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<GetOrganizationsResponse> getOrganizations(@Parameter(name="sort", description="Field and order to sort the result by.", in=ParameterIn.QUERY) @Valid @RequestParam(value="sort", required=false) String sort, @Parameter(name="page_size", description="Number of results per page. Defaults to 10 if parameter not sent.", in=ParameterIn.QUERY) @Valid @RequestParam(value="page_size", required=false) Integer pageSize, @Parameter(name="next_token", description="A string to get the next page of results if there are more results.", in=ParameterIn.QUERY) @Valid @RequestParam(value="next_token", required=false) String nextToken) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"roles\" : [ { \"name\" : \"name\", \"description\" : \"description\", \"id\" : \"id\", \"key\" : \"key\" }, { \"name\" : \"name\", \"description\" : \"description\", \"id\" : \"id\", \"key\" : \"key\" } ], \"message\" : \"message\", \"next_token\" : \"next_token\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"roles\" : [ { \"name\" : \"name\", \"description\" : \"description\", \"id\" : \"id\", \"key\" : \"key\" }, { \"name\" : \"name\", \"description\" : \"description\", \"id\" : \"id\", \"key\" : \"key\" } ], \"message\" : \"message\", \"next_token\" : \"next_token\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getPermissions", summary="List Permissions", description="The returned list can be sorted by permission name or permission ID in ascending or descending order. The number of records to return at a time can also be controlled using the `page_size` query string parameter. ", tags={"Permissions"}, responses={@ApiResponse(responseCode="200", description="Permissions successfully retrieved.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/permissions"}, produces={"application/json; charset=utf-8"})
    default public ResponseEntity<SuccessResponse> getPermissions(@Parameter(name="sort", description="Field and order to sort the result by.", in=ParameterIn.QUERY) @Valid @RequestParam(value="sort", required=false) String sort, @Parameter(name="page_size", description="Number of results per page. Defaults to 10 if parameter not sent.", in=ParameterIn.QUERY) @Valid @RequestParam(value="page_size", required=false) Integer pageSize, @Parameter(name="next_token", description="A string to get the next page of results if there are more results.", in=ParameterIn.QUERY) @Valid @RequestParam(value="next_token", required=false) String nextToken) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getRoles", summary="List Roles", description="The returned list can be sorted by role name or role ID in ascending or descending order. The number of records to return at a time can also be controlled using the `page_size` query string parameter. ", tags={"Roles"}, responses={@ApiResponse(responseCode="200", description="Roles successfully retrieved.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=GetRolesResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/roles"}, produces={"application/json; charset=utf-8"})
    default public ResponseEntity<GetRolesResponse> getRoles(@Parameter(name="sort", description="Field and order to sort the result by.", in=ParameterIn.QUERY) @Valid @RequestParam(value="sort", required=false) String sort, @Parameter(name="page_size", description="Number of results per page. Defaults to 10 if parameter not sent.", in=ParameterIn.QUERY) @Valid @RequestParam(value="page_size", required=false) Integer pageSize, @Parameter(name="next_token", description="A string to get the next page of results if there are more results.", in=ParameterIn.QUERY) @Valid @RequestParam(value="next_token", required=false) String nextToken) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"roles\" : [ { \"name\" : \"name\", \"description\" : \"description\", \"key\" : \"key\" }, { \"name\" : \"name\", \"description\" : \"description\", \"key\" : \"key\" } ], \"message\" : \"message\", \"next_token\" : \"next_token\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getSubscriber", summary="Get Subscriber", description="Retrieve a subscriber record. ", tags={"Subscribers"}, responses={@ApiResponse(responseCode="200", description="Subscriber successfully retrieved.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=GetSubscriberResponse.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/subscribers/{subscriber_id}"}, produces={"application/json; charset=utf-8"})
    default public ResponseEntity<GetSubscriberResponse> getSubscriber(@Parameter(name="subscriber_id", description="The subscriber's id.", required=true, in=ParameterIn.PATH) @PathVariable(value="subscriber_id") String subscriberId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"subscribers\" : [ { \"preferred_email\" : \"preferred_email\", \"last_name\" : \"last_name\", \"id\" : \"id\", \"first_name\" : \"first_name\" }, { \"preferred_email\" : \"preferred_email\", \"last_name\" : \"last_name\", \"id\" : \"id\", \"first_name\" : \"first_name\" } ], \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getSubscribers", summary="List Subscribers", description="The returned list can be sorted by full name or email address in ascending or descending order. The number of records to return at a time can also be controlled using the `page_size` query string parameter. ", tags={"Subscribers"}, responses={@ApiResponse(responseCode="200", description="Subscriber successfully retrieved.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=GetSubscribersResponse.class))}), @ApiResponse(responseCode="403", description="Bad request.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/subscribers"}, produces={"application/json; charset=utf-8"})
    default public ResponseEntity<GetSubscribersResponse> getSubscribers(@Parameter(name="sort", description="Field and order to sort the result by.", in=ParameterIn.QUERY) @Valid @RequestParam(value="sort", required=false) String sort, @Parameter(name="page_size", description="Number of results per page. Defaults to 10 if parameter not sent.", in=ParameterIn.QUERY) @Valid @RequestParam(value="page_size", required=false) Integer pageSize, @Parameter(name="next_token", description="A string to get the next page of results if there are more results.", in=ParameterIn.QUERY) @Valid @RequestParam(value="next_token", required=false) String nextToken) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"subscribers\" : [ { \"full_name\" : \"full_name\", \"last_name\" : \"last_name\", \"id\" : \"id\", \"first_name\" : \"first_name\", \"email\" : \"email\" }, { \"full_name\" : \"full_name\", \"last_name\" : \"last_name\", \"id\" : \"id\", \"first_name\" : \"first_name\", \"email\" : \"email\" } ], \"message\" : \"message\", \"next_token\" : \"next_token\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getTimezones", summary="List timezones and timezone IDs.", description="Get a list of timezones and associated timezone keys.", tags={"Timezones"}, responses={@ApiResponse(responseCode="201", description="A successful response with a list of timezones and timezone keys.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/timezones"}, produces={"application/json; charset=utf-8"})
    default public ResponseEntity<SuccessResponse> getTimezones(@Parameter(name="timezone_key", description="Timezone Key.", in=ParameterIn.QUERY) @Valid @RequestParam(value="timezone_key", required=false) String timezoneKey, @Parameter(name="name", description="Timezone.", in=ParameterIn.QUERY) @Valid @RequestParam(value="name", required=false) String name) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getUserData", summary="Get User", description="Retrieve a user record. ", tags={"Users"}, responses={@ApiResponse(responseCode="200", description="User successfully updated.", content={@Content(mediaType="application/json", schema=@Schema(implementation=User.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=User.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/user"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<User> getUserData(@NotNull @Parameter(name="id", description="The user's id.", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="id", required=true) String id) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"failed_sign_ins\" : 6, \"last_name\" : \"last_name\", \"is_suspended\" : true, \"last_signed_in\" : \"last_signed_in\", \"is_password_reset_requested\" : true, \"total_sign_ins\" : 0, \"picture\" : \"picture\", \"full_name\" : \"full_name\", \"created_on\" : \"created_on\", \"id\" : \"id\", \"provided_id\" : \"provided_id\", \"first_name\" : \"first_name\", \"email\" : \"email\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"failed_sign_ins\" : 6, \"last_name\" : \"last_name\", \"is_suspended\" : true, \"last_signed_in\" : \"last_signed_in\", \"is_password_reset_requested\" : true, \"total_sign_ins\" : 0, \"picture\" : \"picture\", \"full_name\" : \"full_name\", \"created_on\" : \"created_on\", \"id\" : \"id\", \"provided_id\" : \"provided_id\", \"first_name\" : \"first_name\", \"email\" : \"email\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getUsers", summary="List Users", description="The returned list can be sorted by full name or email address in ascending or descending order. The number of records to return at a time can also be controlled using the `page_size` query string parameter. ", tags={"Users"}, responses={@ApiResponse(responseCode="200", description="Users successfully retrieved.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UsersResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=UsersResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/api/v1/users"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<UsersResponse> getUsers(@Parameter(name="sort", description="Field and order to sort the result by.", in=ParameterIn.QUERY) @Valid @RequestParam(value="sort", required=false) String sort, @Parameter(name="page_size", description="Number of results per page. Defaults to 10 if parameter not sent.", in=ParameterIn.QUERY) @Valid @RequestParam(value="page_size", required=false) Integer pageSize, @Parameter(name="user_id", description="ID of the user to filter by.", in=ParameterIn.QUERY) @Valid @RequestParam(value="user_id", required=false) String userId, @Parameter(name="next_token", description="A string to get the next page of results if there are more results.", in=ParameterIn.QUERY) @Valid @RequestParam(value="next_token", required=false) String nextToken, @Parameter(name="email", description="Filter the results by email address. The query string should be comma separated and url encoded.", in=ParameterIn.QUERY) @Valid @RequestParam(value="email", required=false) String email) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\", \"next_token\" : \"next_token\", \"users\" : [ { \"failed_sign_ins\" : 6, \"last_name\" : \"last_name\", \"is_suspended\" : true, \"last_signed_in\" : \"last_signed_in\", \"is_password_reset_requested\" : true, \"total_sign_ins\" : 0, \"picture\" : \"picture\", \"full_name\" : \"full_name\", \"created_on\" : \"created_on\", \"id\" : \"id\", \"provided_id\" : \"provided_id\", \"first_name\" : \"first_name\", \"email\" : \"email\" }, { \"failed_sign_ins\" : 6, \"last_name\" : \"last_name\", \"is_suspended\" : true, \"last_signed_in\" : \"last_signed_in\", \"is_password_reset_requested\" : true, \"total_sign_ins\" : 0, \"picture\" : \"picture\", \"full_name\" : \"full_name\", \"created_on\" : \"created_on\", \"id\" : \"id\", \"provided_id\" : \"provided_id\", \"first_name\" : \"first_name\", \"email\" : \"email\" } ] }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\", \"next_token\" : \"next_token\", \"users\" : [ { \"failed_sign_ins\" : 6, \"last_name\" : \"last_name\", \"is_suspended\" : true, \"last_signed_in\" : \"last_signed_in\", \"is_password_reset_requested\" : true, \"total_sign_ins\" : 0, \"picture\" : \"picture\", \"full_name\" : \"full_name\", \"created_on\" : \"created_on\", \"id\" : \"id\", \"provided_id\" : \"provided_id\", \"first_name\" : \"first_name\", \"email\" : \"email\" }, { \"failed_sign_ins\" : 6, \"last_name\" : \"last_name\", \"is_suspended\" : true, \"last_signed_in\" : \"last_signed_in\", \"is_password_reset_requested\" : true, \"total_sign_ins\" : 0, \"picture\" : \"picture\", \"full_name\" : \"full_name\", \"created_on\" : \"created_on\", \"id\" : \"id\", \"provided_id\" : \"provided_id\", \"first_name\" : \"first_name\", \"email\" : \"email\" } ] }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="removeOrganizationUser", summary="Remove Organization User", description="Remove user from an organization.", tags={"Organizations"}, responses={@ApiResponse(responseCode="200", description="User successfully removed from organization", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Error removing user", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/api/v1/organizations/{org_code}/users/{user_id}"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<SuccessResponse> removeOrganizationUser(@Parameter(name="org_code", description="The organization's code.", required=true, in=ParameterIn.PATH) @PathVariable(value="org_code") String orgCode, @Parameter(name="user_id", description="The user's id.", required=true, in=ParameterIn.PATH) @PathVariable(value="user_id") String userId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="replaceRedirectCallbackURLs", summary="Replace Redirect Callback URLs", description="Replace all redirect callback URLs. ", tags={"Callbacks"}, responses={@ApiResponse(responseCode="200", description="Callbacks successfully updated", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/v1/applications/{app_id}/auth_redirect_urls"}, produces={"application/json; charset=utf-8"}, consumes={"application/json"})
    default public ResponseEntity<SuccessResponse> replaceRedirectCallbackURLs(@Parameter(name="app_id", description="The identifier for the application.", required=true, in=ParameterIn.PATH) @PathVariable(value="app_id") String appId, @Parameter(name="ReplaceRedirectCallbackURLsRequest", description="Callback details.", required=true) @Valid @RequestBody ReplaceRedirectCallbackURLsRequest replaceRedirectCallbackURLsRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="revokeConnectedAppToken", summary="Revoke Connected App Token", description="Revoke the tokens linked to the connected app session.", tags={"Connected Apps"}, responses={@ApiResponse(responseCode="200", description="An access token that can be used to query a third-party provider, as well as the token's expiry time.", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="405", description="Invalid HTTP method used.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.POST}, value={"/api/v1/connected_apps/revoke"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<SuccessResponse> revokeConnectedAppToken(@NotNull @Parameter(name="session_id", description="The unique sesssion id reprensenting the login session of a user.", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="session_id", required=true) String sessionId) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="updateApplication", summary="Update Application", description="Update an application.", tags={"Applications"}, responses={@ApiResponse(responseCode="200", description="Application successfully updated."), @ApiResponse(responseCode="403", description="Invalid credentials."), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.PATCH}, value={"/api/v1/applications/{application_id}"}, produces={"application/json", "application/json; charset=utf-8"}, consumes={"application/json"})
    default public ResponseEntity<Void> updateApplication(@Parameter(name="application_id", description="The identifier for the application.", required=true, in=ParameterIn.PATH) @PathVariable(value="application_id") String applicationId, @Parameter(name="UpdateApplicationRequest", description="Application details.") @Valid @RequestBody(required=false) UpdateApplicationRequest updateApplicationRequest) {
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="updateBusiness", summary="Update business details", description="Update business details.", tags={"Business"}, responses={@ApiResponse(responseCode="201", description="Business successfully updated.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.PATCH}, value={"/api/v1/business"}, produces={"application/json; charset=utf-8"})
    default public ResponseEntity<SuccessResponse> updateBusiness(@NotNull @Parameter(name="business_name", description="Business name.", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="business_name", required=true) String businessName, @NotNull @Parameter(name="primary_email", description="Email associated with business.", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="primary_email", required=true) String primaryEmail, @Parameter(name="primary_phone", description="Phone number associated with business.", in=ParameterIn.QUERY) @Valid @RequestParam(value="primary_phone", required=false) String primaryPhone, @Parameter(name="industry_key", description="The key of the industry your business is in.", in=ParameterIn.QUERY) @Valid @RequestParam(value="industry_key", required=false) String industryKey, @Parameter(name="timezone_id", description="The ID of the timezone your business is in.", in=ParameterIn.QUERY) @Valid @RequestParam(value="timezone_id", required=false) String timezoneId, @Parameter(name="privacy_url", description="Your Privacy policy URL.", in=ParameterIn.QUERY) @Valid @RequestParam(value="privacy_url", required=false) String privacyUrl, @Parameter(name="terms_url", description="Your Terms and Conditions URL.", in=ParameterIn.QUERY) @Valid @RequestParam(value="terms_url", required=false) String termsUrl, @Parameter(name="is_show_kinde_branding", description="Display \"Powered by Kinde\" on your sign up, sign in, and subscription pages.", in=ParameterIn.QUERY) @Valid @RequestParam(value="is_show_kinde_branding", required=false) String isShowKindeBranding, @Parameter(name="is_click_wrap", description="Show a policy acceptance checkbox on sign up.", in=ParameterIn.QUERY) @Valid @RequestParam(value="is_click_wrap", required=false) Boolean isClickWrap, @Parameter(name="partner_code", description="Your Kinde Perk code.", in=ParameterIn.QUERY) @Valid @RequestParam(value="partner_code", required=false) String partnerCode) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="updateEnvironementFeatureFlagOverride", summary="Update Environment Feature Flag Override", description="Update environment feature flag override.", tags={"Environments"}, responses={@ApiResponse(responseCode="200", description="Feature flag override successful", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.PATCH}, value={"/api/v1/environment/feature_flags/{feature_flag_key}"}, produces={"application/json", "application/json; charset=utf-8"}, consumes={"application/json"})
    default public ResponseEntity<SuccessResponse> updateEnvironementFeatureFlagOverride(@Parameter(name="feature_flag_key", description="The identifier for the feature flag.", required=true, in=ParameterIn.PATH) @PathVariable(value="feature_flag_key") String featureFlagKey, @Parameter(name="UpdateEnvironementFeatureFlagOverrideRequest", description="Flag details.", required=true) @Valid @RequestBody UpdateEnvironementFeatureFlagOverrideRequest updateEnvironementFeatureFlagOverrideRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="updateFeatureFlag", summary="Replace Feature Flag", description="Update feature flag.", tags={"Feature Flags"}, responses={@ApiResponse(responseCode="200", description="Feature flag successfully updated.", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/api/v1/feature_flags/{feature_flag_key}"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<SuccessResponse> updateFeatureFlag(@Parameter(name="feature_flag_key", description="The key identifier for the feature flag.", required=true, in=ParameterIn.PATH) @PathVariable(value="feature_flag_key") String featureFlagKey, @NotNull @Parameter(name="name", description="The name of the flag.", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="name", required=true) String name, @NotNull @Parameter(name="description", description="Description of the flag purpose.", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="description", required=true) String description, @NotNull @Parameter(name="type", description="The variable type", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="type", required=true) String type, @NotNull @Parameter(name="allow_override_level", description="Allow the flag to be overridden at a different level.", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="allow_override_level", required=true) String allowOverrideLevel, @NotNull @Parameter(name="default_value", description="Default value for the flag used by environments and organizations.", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="default_value", required=true) String defaultValue) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="updateOrganization", summary="Update Organization", description="Update an organization.", tags={"Organizations"}, responses={@ApiResponse(responseCode="200", description="Organization successfully updated.", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials."), @ApiResponse(responseCode="400", description="Error updating organization.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.PATCH}, value={"/api/v1/organization/{org_code}"}, produces={"application/json", "application/json; charset=utf-8"}, consumes={"application/json"})
    default public ResponseEntity<SuccessResponse> updateOrganization(@Parameter(name="org_code", description="The identifier for the organization.", required=true, in=ParameterIn.PATH) @PathVariable(value="org_code") String orgCode, @Parameter(name="UpdateOrganizationRequest", description="Organization details.") @Valid @RequestBody(required=false) UpdateOrganizationRequest updateOrganizationRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="updateOrganizationFeatureFlagOverride", summary="Update Organization Feature Flag Override", description="Update organization feature flag override.", tags={"Organizations"}, responses={@ApiResponse(responseCode="200", description="Feature flag override successfully updated.", content={@Content(mediaType="application/json", schema=@Schema(implementation=SuccessResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.PATCH}, value={"/api/v1/organizations/{org_code}/feature_flags/{feature_flag_key}"}, produces={"application/json", "application/json; charset=utf-8"})
    default public ResponseEntity<SuccessResponse> updateOrganizationFeatureFlagOverride(@Parameter(name="org_code", description="The identifier for the organization", required=true, in=ParameterIn.PATH) @PathVariable(value="org_code") String orgCode, @Parameter(name="feature_flag_key", description="The identifier for the feature flag", required=true, in=ParameterIn.PATH) @PathVariable(value="feature_flag_key") String featureFlagKey, @NotNull @Parameter(name="value", description="Override value", required=true, in=ParameterIn.QUERY) @Valid @RequestParam(value="value", required=true) String value) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="updateOrganizationUsers", summary="Update Organization Users", description="Update users that belong to an organization.", tags={"Organizations"}, responses={@ApiResponse(responseCode="200", description="Users successfully removed.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UpdateOrganizationUsersResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=UpdateOrganizationUsersResponse.class))}), @ApiResponse(responseCode="400", description="Error updating organization user.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.PATCH}, value={"/api/v1/organizations/{org_code}/users"}, produces={"application/json", "application/json; charset=utf-8"}, consumes={"application/json"})
    default public ResponseEntity<UpdateOrganizationUsersResponse> updateOrganizationUsers(@Parameter(name="org_code", description="The organization's code.", required=true, in=ParameterIn.PATH) @PathVariable(value="org_code") String orgCode, @Parameter(name="UpdateOrganizationUsersRequest", description="") @Valid @RequestBody(required=false) UpdateOrganizationUsersRequest updateOrganizationUsersRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"users_added\" : [ \"users_added\", \"users_added\" ], \"users_updated\" : [ \"users_updated\", \"users_updated\" ], \"users_removed\" : [ \"users_removed\", \"users_removed\" ], \"message\" : \"message\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"users_added\" : [ \"users_added\", \"users_added\" ], \"users_updated\" : [ \"users_updated\", \"users_updated\" ], \"users_removed\" : [ \"users_removed\", \"users_removed\" ], \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="updatePermissions", summary="Update Permission", description="Update permission", tags={"Permissions"}, responses={@ApiResponse(responseCode="201", description="Permission successfully updated", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.PATCH}, value={"/api/v1/permissions/{permission_id}"}, produces={"application/json; charset=utf-8"}, consumes={"application/json"})
    default public ResponseEntity<SuccessResponse> updatePermissions(@Parameter(name="permission_id", description="The identifier for the permission.", required=true, in=ParameterIn.PATH) @PathVariable(value="permission_id") Integer permissionId, @Parameter(name="CreatePermissionRequest", description="Permission details.") @Valid @RequestBody(required=false) CreatePermissionRequest createPermissionRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="updateRolePermissions", summary="Update Role Permissions", description="Update role permissions. ", tags={"Roles"}, responses={@ApiResponse(responseCode="200", description="Permissions successfully updated.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UpdateRolePermissionsResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=UpdateRolePermissionsResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.PATCH}, value={"/api/v1/roles/{role_id}/permissions"}, produces={"application/json", "application/json; charset=utf-8"}, consumes={"application/json"})
    default public ResponseEntity<UpdateRolePermissionsResponse> updateRolePermissions(@Parameter(name="role_id", description="The identifier for the role.", required=true, in=ParameterIn.PATH) @PathVariable(value="role_id") String roleId, @Parameter(name="UpdateRolePermissionsRequest", description="", required=true) @Valid @RequestBody UpdateRolePermissionsRequest updateRolePermissionsRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"permissions_added\" : [ \"permissions_added\", \"permissions_added\" ], \"code\" : \"code\", \"message\" : \"message\", \"permissions_removed\" : [ \"permissions_removed\", \"permissions_removed\" ] }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"permissions_added\" : [ \"permissions_added\", \"permissions_added\" ], \"code\" : \"code\", \"message\" : \"message\", \"permissions_removed\" : [ \"permissions_removed\", \"permissions_removed\" ] }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="updateRoles", summary="Update Role", description="Update a role", tags={"Roles"}, responses={@ApiResponse(responseCode="201", description="Role successfully updated", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=SuccessResponse.class))}), @ApiResponse(responseCode="400", description="Invalid request.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.", content={@Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))})}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.PATCH}, value={"/api/v1/roles/{role_id}"}, produces={"application/json; charset=utf-8"}, consumes={"application/json"})
    default public ResponseEntity<SuccessResponse> updateRoles(@Parameter(name="role_id", description="The identifier for the role.", required=true, in=ParameterIn.PATH) @PathVariable(value="role_id") String roleId, @Parameter(name="UpdateRolesRequest", description="Role details.") @Valid @RequestBody(required=false) UpdateRolesRequest updateRolesRequest) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"code\" : \"code\", \"message\" : \"message\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="updateUser", summary="Update User", description="Update a user record. ", tags={"Users"}, responses={@ApiResponse(responseCode="200", description="User successfully updated.", content={@Content(mediaType="application/json", schema=@Schema(implementation=User.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=User.class))}), @ApiResponse(responseCode="400", description="Bad request.", content={@Content(mediaType="application/json", schema=@Schema(implementation=ErrorResponse.class)), @Content(mediaType="application/json; charset=utf-8", schema=@Schema(implementation=ErrorResponse.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.PATCH}, value={"/api/v1/user"}, produces={"application/json", "application/json; charset=utf-8"}, consumes={"application/json"})
    default public ResponseEntity<User> updateUser(@Parameter(name="UpdateUserRequest", description="The user to update.", required=true) @Valid @RequestBody UpdateUserRequest updateUserRequest, @Parameter(name="id", description="The user's id.", in=ParameterIn.QUERY) @Valid @RequestParam(value="id", required=false) String id) {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) {
                    String exampleString = "{ \"failed_sign_ins\" : 6, \"last_name\" : \"last_name\", \"is_suspended\" : true, \"last_signed_in\" : \"last_signed_in\", \"is_password_reset_requested\" : true, \"total_sign_ins\" : 0, \"picture\" : \"picture\", \"full_name\" : \"full_name\", \"created_on\" : \"created_on\", \"id\" : \"id\", \"provided_id\" : \"provided_id\", \"first_name\" : \"first_name\", \"email\" : \"email\" }";
                    ApiUtil.setExampleResponse(request, "application/json", exampleString);
                    break;
                }
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json; charset=utf-8"))) continue;
                String exampleString = "{ \"failed_sign_ins\" : 6, \"last_name\" : \"last_name\", \"is_suspended\" : true, \"last_signed_in\" : \"last_signed_in\", \"is_password_reset_requested\" : true, \"total_sign_ins\" : 0, \"picture\" : \"picture\", \"full_name\" : \"full_name\", \"created_on\" : \"created_on\", \"id\" : \"id\", \"provided_id\" : \"provided_id\", \"first_name\" : \"first_name\", \"email\" : \"email\" }";
                ApiUtil.setExampleResponse(request, "application/json; charset=utf-8", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

