/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Optional;
import org.openapitools.api.ApiUtil;
import org.openapitools.model.UserProfile;
import org.openapitools.model.UserProfileV2;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.NativeWebRequest;

@Validated
@Tag(name="OAuth", description="the OAuth API")
public interface Oauth2Api {
    default public Optional<NativeWebRequest> getRequest() {
        return Optional.empty();
    }

    @Operation(operationId="getUser", summary="Get User Profile", description="Contains the id, names and email of the currently logged in user. ", tags={"OAuth"}, responses={@ApiResponse(responseCode="200", description="Details of logged in user V1.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserProfile.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/oauth2/user_profile"}, produces={"application/json"})
    default public ResponseEntity<UserProfile> getUser() {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"preferred_email\" : \"preferred_email\", \"last_name\" : \"last_name\", \"id\" : \"id\", \"provided_id\" : \"provided_id\", \"first_name\" : \"first_name\", \"picture\" : \"picture\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @Operation(operationId="getUserProfileV2", summary="Returns the details of the currently logged in user", description="Contains the id, names, profile picture URL and email of the currently logged in user. ", tags={"OAuth"}, responses={@ApiResponse(responseCode="200", description="Details of logged in user V2.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UserProfileV2.class))}), @ApiResponse(responseCode="403", description="Invalid credentials.")}, security={@SecurityRequirement(name="kindeBearerAuth")})
    @RequestMapping(method={RequestMethod.GET}, value={"/oauth2/v2/user_profile"}, produces={"application/json"})
    default public ResponseEntity<UserProfileV2> getUserProfileV2() {
        this.getRequest().ifPresent(request -> {
            for (MediaType mediaType : MediaType.parseMediaTypes((String)request.getHeader("Accept"))) {
                if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
                String exampleString = "{ \"sub\" : \"sub\", \"updated_at\" : 0, \"name\" : \"name\", \"id\" : \"id\", \"given_name\" : \"given_name\", \"provided_id\" : \"provided_id\", \"family_name\" : \"family_name\", \"email\" : \"email\", \"picture\" : \"picture\" }";
                ApiUtil.setExampleResponse(request, "application/json", exampleString);
                break;
            }
        });
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

