/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="CreateFeatureFlag_request")
public class CreateFeatureFlagRequest {
    private String name;
    private String description;
    private String key;
    private TypeEnum type;
    private AllowOverrideLevelEnum allowOverrideLevel;
    private String defaultValue;

    @Deprecated
    public CreateFeatureFlagRequest() {
    }

    public CreateFeatureFlagRequest(String name, String key, TypeEnum type, String defaultValue) {
        this.name = name;
        this.key = key;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public CreateFeatureFlagRequest name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", description="The name of the flag.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateFeatureFlagRequest description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="Description of the flag purpose.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CreateFeatureFlagRequest key(String key) {
        this.key = key;
        return this;
    }

    @NotNull
    @Schema(name="key", description="The flag identifier to use in code.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public CreateFeatureFlagRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="type", description="The variable type.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public CreateFeatureFlagRequest allowOverrideLevel(AllowOverrideLevelEnum allowOverrideLevel) {
        this.allowOverrideLevel = allowOverrideLevel;
        return this;
    }

    @Schema(name="allow_override_level", description="Allow the flag to be overridden at a different level.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="allow_override_level")
    public AllowOverrideLevelEnum getAllowOverrideLevel() {
        return this.allowOverrideLevel;
    }

    public void setAllowOverrideLevel(AllowOverrideLevelEnum allowOverrideLevel) {
        this.allowOverrideLevel = allowOverrideLevel;
    }

    public CreateFeatureFlagRequest defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @NotNull
    @Schema(name="default_value", description="Default value for the flag used by environments and organizations.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="default_value")
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateFeatureFlagRequest createFeatureFlagRequest = (CreateFeatureFlagRequest)o;
        return Objects.equals(this.name, createFeatureFlagRequest.name) && Objects.equals(this.description, createFeatureFlagRequest.description) && Objects.equals(this.key, createFeatureFlagRequest.key) && Objects.equals((Object)this.type, (Object)createFeatureFlagRequest.type) && Objects.equals((Object)this.allowOverrideLevel, (Object)createFeatureFlagRequest.allowOverrideLevel) && Objects.equals(this.defaultValue, createFeatureFlagRequest.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.key, this.type, this.allowOverrideLevel, this.defaultValue});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateFeatureFlagRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    allowOverrideLevel: ").append(this.toIndentedString((Object)this.allowOverrideLevel)).append("\n");
        sb.append("    defaultValue: ").append(this.toIndentedString(this.defaultValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        STR("str"),
        INT("int"),
        BOOL("bool");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum AllowOverrideLevelEnum {
        ENV("env"),
        ORG("org");

        private String value;

        private AllowOverrideLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AllowOverrideLevelEnum fromValue(String value) {
            for (AllowOverrideLevelEnum b : AllowOverrideLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

