/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;

@JsonTypeName(value="createOrganization_request")
public class CreateOrganizationRequest {
    private String name;
    @Valid
    private Map<String, InnerEnum> featureFlags = new HashMap<String, InnerEnum>();
    private String externalId;
    private String backgroundColor;
    private String buttonColor;
    private String buttonTextColor;
    private String linkColor;

    public CreateOrganizationRequest name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="The organization's name.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CreateOrganizationRequest featureFlags(Map<String, InnerEnum> featureFlags) {
        this.featureFlags = featureFlags;
        return this;
    }

    public CreateOrganizationRequest putFeatureFlagsItem(String key, InnerEnum featureFlagsItem) {
        if (this.featureFlags == null) {
            this.featureFlags = new HashMap<String, InnerEnum>();
        }
        this.featureFlags.put(key, featureFlagsItem);
        return this;
    }

    @Schema(name="feature_flags", description="The organization's feature flag settings.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="feature_flags")
    public Map<String, InnerEnum> getFeatureFlags() {
        return this.featureFlags;
    }

    public void setFeatureFlags(Map<String, InnerEnum> featureFlags) {
        this.featureFlags = featureFlags;
    }

    public CreateOrganizationRequest externalId(String externalId) {
        this.externalId = externalId;
        return this;
    }

    @Schema(name="external_id", description="The organization's ID.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public CreateOrganizationRequest backgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @Schema(name="background_color", description="The organization's brand settings - background color.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="background_color")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public CreateOrganizationRequest buttonColor(String buttonColor) {
        this.buttonColor = buttonColor;
        return this;
    }

    @Schema(name="button_color", description="The organization's brand settings - button color.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="button_color")
    public String getButtonColor() {
        return this.buttonColor;
    }

    public void setButtonColor(String buttonColor) {
        this.buttonColor = buttonColor;
    }

    public CreateOrganizationRequest buttonTextColor(String buttonTextColor) {
        this.buttonTextColor = buttonTextColor;
        return this;
    }

    @Schema(name="button_text_color", description="The organization's brand settings - button text color.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="button_text_color")
    public String getButtonTextColor() {
        return this.buttonTextColor;
    }

    public void setButtonTextColor(String buttonTextColor) {
        this.buttonTextColor = buttonTextColor;
    }

    public CreateOrganizationRequest linkColor(String linkColor) {
        this.linkColor = linkColor;
        return this;
    }

    @Schema(name="link_color", description="The organization's brand settings - link color.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="link_color")
    public String getLinkColor() {
        return this.linkColor;
    }

    public void setLinkColor(String linkColor) {
        this.linkColor = linkColor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateOrganizationRequest createOrganizationRequest = (CreateOrganizationRequest)o;
        return Objects.equals(this.name, createOrganizationRequest.name) && Objects.equals(this.featureFlags, createOrganizationRequest.featureFlags) && Objects.equals(this.externalId, createOrganizationRequest.externalId) && Objects.equals(this.backgroundColor, createOrganizationRequest.backgroundColor) && Objects.equals(this.buttonColor, createOrganizationRequest.buttonColor) && Objects.equals(this.buttonTextColor, createOrganizationRequest.buttonTextColor) && Objects.equals(this.linkColor, createOrganizationRequest.linkColor);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.featureFlags, this.externalId, this.backgroundColor, this.buttonColor, this.buttonTextColor, this.linkColor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateOrganizationRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    featureFlags: ").append(this.toIndentedString(this.featureFlags)).append("\n");
        sb.append("    externalId: ").append(this.toIndentedString(this.externalId)).append("\n");
        sb.append("    backgroundColor: ").append(this.toIndentedString(this.backgroundColor)).append("\n");
        sb.append("    buttonColor: ").append(this.toIndentedString(this.buttonColor)).append("\n");
        sb.append("    buttonTextColor: ").append(this.toIndentedString(this.buttonTextColor)).append("\n");
        sb.append("    linkColor: ").append(this.toIndentedString(this.linkColor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum InnerEnum {
        STR("str"),
        INT("int"),
        BOOL("bool");

        private String value;

        private InnerEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InnerEnum fromValue(String value) {
            for (InnerEnum b : InnerEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

