/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.openapitools.model.CreateUserRequestIdentitiesInner;
import org.openapitools.model.CreateUserRequestProfile;

@JsonTypeName(value="createUser_request")
public class CreateUserRequest {
    private CreateUserRequestProfile profile;
    @Valid
    private @Valid List<@Valid CreateUserRequestIdentitiesInner> identities;

    public CreateUserRequest profile(CreateUserRequestProfile profile) {
        this.profile = profile;
        return this;
    }

    @Valid
    @Schema(name="profile", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="profile")
    public CreateUserRequestProfile getProfile() {
        return this.profile;
    }

    public void setProfile(CreateUserRequestProfile profile) {
        this.profile = profile;
    }

    public CreateUserRequest identities(List<@Valid CreateUserRequestIdentitiesInner> identities) {
        this.identities = identities;
        return this;
    }

    public CreateUserRequest addIdentitiesItem(CreateUserRequestIdentitiesInner identitiesItem) {
        if (this.identities == null) {
            this.identities = new ArrayList<CreateUserRequestIdentitiesInner>();
        }
        this.identities.add(identitiesItem);
        return this;
    }

    @Valid
    @Schema(name="identities", description="Array of identities to assign to the created user", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="identities")
    public @Valid List<@Valid CreateUserRequestIdentitiesInner> getIdentities() {
        return this.identities;
    }

    public void setIdentities(List<@Valid CreateUserRequestIdentitiesInner> identities) {
        this.identities = identities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateUserRequest createUserRequest = (CreateUserRequest)o;
        return Objects.equals(this.profile, createUserRequest.profile) && Objects.equals(this.identities, createUserRequest.identities);
    }

    public int hashCode() {
        return Objects.hash(this.profile, this.identities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateUserRequest {\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    identities: ").append(this.toIndentedString(this.identities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

