/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.openapitools.model.UserIdentity;

@JsonTypeName(value="create_user_response")
public class CreateUserResponse {
    private String id;
    private Boolean created;
    @Valid
    private @Valid List<@Valid UserIdentity> identities;

    public CreateUserResponse id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", description="Unique id of the user in Kinde.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CreateUserResponse created(Boolean created) {
        this.created = created;
        return this;
    }

    @Schema(name="created", description="True if the user was successfully created.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="created")
    public Boolean getCreated() {
        return this.created;
    }

    public void setCreated(Boolean created) {
        this.created = created;
    }

    public CreateUserResponse identities(List<@Valid UserIdentity> identities) {
        this.identities = identities;
        return this;
    }

    public CreateUserResponse addIdentitiesItem(UserIdentity identitiesItem) {
        if (this.identities == null) {
            this.identities = new ArrayList<UserIdentity>();
        }
        this.identities.add(identitiesItem);
        return this;
    }

    @Valid
    @Schema(name="identities", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="identities")
    public @Valid List<@Valid UserIdentity> getIdentities() {
        return this.identities;
    }

    public void setIdentities(List<@Valid UserIdentity> identities) {
        this.identities = identities;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateUserResponse createUserResponse = (CreateUserResponse)o;
        return Objects.equals(this.id, createUserResponse.id) && Objects.equals(this.created, createUserResponse.created) && Objects.equals(this.identities, createUserResponse.identities);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.created, this.identities);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateUserResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    identities: ").append(this.toIndentedString(this.identities)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

