/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;

@JsonTypeName(value="updateApplication_request")
public class UpdateApplicationRequest {
    private String name;
    private String languageKey;
    @Valid
    private List<String> logoutUris;
    @Valid
    private List<String> redirectUris;

    public UpdateApplicationRequest name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="The application's name.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UpdateApplicationRequest languageKey(String languageKey) {
        this.languageKey = languageKey;
        return this;
    }

    @Schema(name="language_key", description="The application's language key.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="language_key")
    public String getLanguageKey() {
        return this.languageKey;
    }

    public void setLanguageKey(String languageKey) {
        this.languageKey = languageKey;
    }

    public UpdateApplicationRequest logoutUris(List<String> logoutUris) {
        this.logoutUris = logoutUris;
        return this;
    }

    public UpdateApplicationRequest addLogoutUrisItem(String logoutUrisItem) {
        if (this.logoutUris == null) {
            this.logoutUris = new ArrayList<String>();
        }
        this.logoutUris.add(logoutUrisItem);
        return this;
    }

    @Schema(name="logout_uris", description="The application's logout uris.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="logout_uris")
    public List<String> getLogoutUris() {
        return this.logoutUris;
    }

    public void setLogoutUris(List<String> logoutUris) {
        this.logoutUris = logoutUris;
    }

    public UpdateApplicationRequest redirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public UpdateApplicationRequest addRedirectUrisItem(String redirectUrisItem) {
        if (this.redirectUris == null) {
            this.redirectUris = new ArrayList<String>();
        }
        this.redirectUris.add(redirectUrisItem);
        return this;
    }

    @Schema(name="redirect_uris", description="The application's redirect uris.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="redirect_uris")
    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateApplicationRequest updateApplicationRequest = (UpdateApplicationRequest)o;
        return Objects.equals(this.name, updateApplicationRequest.name) && Objects.equals(this.languageKey, updateApplicationRequest.languageKey) && Objects.equals(this.logoutUris, updateApplicationRequest.logoutUris) && Objects.equals(this.redirectUris, updateApplicationRequest.redirectUris);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.languageKey, this.logoutUris, this.redirectUris);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateApplicationRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    languageKey: ").append(this.toIndentedString(this.languageKey)).append("\n");
        sb.append("    logoutUris: ").append(this.toIndentedString(this.logoutUris)).append("\n");
        sb.append("    redirectUris: ").append(this.toIndentedString(this.redirectUris)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

