/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@JsonTypeName(value="updateUser_request")
public class UpdateUserRequest {
    private String givenName;
    private String familyName;
    private Boolean isSuspended;
    private Boolean isPasswordResetRequested;

    public UpdateUserRequest givenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    @Schema(name="given_name", description="User's first name.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="given_name")
    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public UpdateUserRequest familyName(String familyName) {
        this.familyName = familyName;
        return this;
    }

    @Schema(name="family_name", description="User's last name.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="family_name")
    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public UpdateUserRequest isSuspended(Boolean isSuspended) {
        this.isSuspended = isSuspended;
        return this;
    }

    @Schema(name="is_suspended", description="Whether the user is currently suspended or not.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="is_suspended")
    public Boolean getIsSuspended() {
        return this.isSuspended;
    }

    public void setIsSuspended(Boolean isSuspended) {
        this.isSuspended = isSuspended;
    }

    public UpdateUserRequest isPasswordResetRequested(Boolean isPasswordResetRequested) {
        this.isPasswordResetRequested = isPasswordResetRequested;
        return this;
    }

    @Schema(name="is_password_reset_requested", description="Prompt the user to change their password on next sign in.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="is_password_reset_requested")
    public Boolean getIsPasswordResetRequested() {
        return this.isPasswordResetRequested;
    }

    public void setIsPasswordResetRequested(Boolean isPasswordResetRequested) {
        this.isPasswordResetRequested = isPasswordResetRequested;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateUserRequest updateUserRequest = (UpdateUserRequest)o;
        return Objects.equals(this.givenName, updateUserRequest.givenName) && Objects.equals(this.familyName, updateUserRequest.familyName) && Objects.equals(this.isSuspended, updateUserRequest.isSuspended) && Objects.equals(this.isPasswordResetRequested, updateUserRequest.isPasswordResetRequested);
    }

    public int hashCode() {
        return Objects.hash(this.givenName, this.familyName, this.isSuspended, this.isPasswordResetRequested);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateUserRequest {\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    familyName: ").append(this.toIndentedString(this.familyName)).append("\n");
        sb.append("    isSuspended: ").append(this.toIndentedString(this.isSuspended)).append("\n");
        sb.append("    isPasswordResetRequested: ").append(this.toIndentedString(this.isPasswordResetRequested)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

