/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonTypeName(value="user")
public class User {
    private String id;
    private String providedId;
    private String email;
    private String lastName;
    private String firstName;
    private String fullName;
    private Boolean isSuspended;
    private String picture;
    private JsonNullable<Boolean> isPasswordResetRequested = JsonNullable.undefined();
    private JsonNullable<Integer> totalSignIns = JsonNullable.undefined();
    private JsonNullable<Integer> failedSignIns = JsonNullable.undefined();
    private JsonNullable<String> lastSignedIn = JsonNullable.undefined();
    private JsonNullable<String> createdOn = JsonNullable.undefined();

    public User id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", description="Unique id of the user in Kinde.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public User providedId(String providedId) {
        this.providedId = providedId;
        return this;
    }

    @Schema(name="provided_id", description="External id for user.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="provided_id")
    public String getProvidedId() {
        return this.providedId;
    }

    public void setProvidedId(String providedId) {
        this.providedId = providedId;
    }

    public User email(String email) {
        this.email = email;
        return this;
    }

    @Schema(name="email", description="Default email address of the user in Kinde.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public User lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Schema(name="last_name", description="User's last name.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="last_name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public User firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Schema(name="first_name", description="User's first name.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="first_name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public User fullName(String fullName) {
        this.fullName = fullName;
        return this;
    }

    @Schema(name="full_name", description="User's full name.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="full_name")
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public User isSuspended(Boolean isSuspended) {
        this.isSuspended = isSuspended;
        return this;
    }

    @Schema(name="is_suspended", description="Whether the user is currently suspended or not.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="is_suspended")
    public Boolean getIsSuspended() {
        return this.isSuspended;
    }

    public void setIsSuspended(Boolean isSuspended) {
        this.isSuspended = isSuspended;
    }

    public User picture(String picture) {
        this.picture = picture;
        return this;
    }

    @Schema(name="picture", description="User's profile picture URL.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="picture")
    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public User isPasswordResetRequested(Boolean isPasswordResetRequested) {
        this.isPasswordResetRequested = JsonNullable.of((Object)isPasswordResetRequested);
        return this;
    }

    @Schema(name="is_password_reset_requested", description="Whether the user has been asked to reset their password.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="is_password_reset_requested")
    public JsonNullable<Boolean> getIsPasswordResetRequested() {
        return this.isPasswordResetRequested;
    }

    public void setIsPasswordResetRequested(JsonNullable<Boolean> isPasswordResetRequested) {
        this.isPasswordResetRequested = isPasswordResetRequested;
    }

    public User totalSignIns(Integer totalSignIns) {
        this.totalSignIns = JsonNullable.of((Object)totalSignIns);
        return this;
    }

    @Schema(name="total_sign_ins", description="Total number of user sign ins.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="total_sign_ins")
    public JsonNullable<Integer> getTotalSignIns() {
        return this.totalSignIns;
    }

    public void setTotalSignIns(JsonNullable<Integer> totalSignIns) {
        this.totalSignIns = totalSignIns;
    }

    public User failedSignIns(Integer failedSignIns) {
        this.failedSignIns = JsonNullable.of((Object)failedSignIns);
        return this;
    }

    @Schema(name="failed_sign_ins", description="Number of consecutive failed user sign ins.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="failed_sign_ins")
    public JsonNullable<Integer> getFailedSignIns() {
        return this.failedSignIns;
    }

    public void setFailedSignIns(JsonNullable<Integer> failedSignIns) {
        this.failedSignIns = failedSignIns;
    }

    public User lastSignedIn(String lastSignedIn) {
        this.lastSignedIn = JsonNullable.of((Object)lastSignedIn);
        return this;
    }

    @Schema(name="last_signed_in", description="Last sign in date in ISO 8601 format.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="last_signed_in")
    public JsonNullable<String> getLastSignedIn() {
        return this.lastSignedIn;
    }

    public void setLastSignedIn(JsonNullable<String> lastSignedIn) {
        this.lastSignedIn = lastSignedIn;
    }

    public User createdOn(String createdOn) {
        this.createdOn = JsonNullable.of((Object)createdOn);
        return this;
    }

    @Schema(name="created_on", description="Date of user creation in ISO 8601 format.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="created_on")
    public JsonNullable<String> getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(JsonNullable<String> createdOn) {
        this.createdOn = createdOn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.id, user.id) && Objects.equals(this.providedId, user.providedId) && Objects.equals(this.email, user.email) && Objects.equals(this.lastName, user.lastName) && Objects.equals(this.firstName, user.firstName) && Objects.equals(this.fullName, user.fullName) && Objects.equals(this.isSuspended, user.isSuspended) && Objects.equals(this.picture, user.picture) && User.equalsNullable(this.isPasswordResetRequested, user.isPasswordResetRequested) && User.equalsNullable(this.totalSignIns, user.totalSignIns) && User.equalsNullable(this.failedSignIns, user.failedSignIns) && User.equalsNullable(this.lastSignedIn, user.lastSignedIn) && User.equalsNullable(this.createdOn, user.createdOn);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.providedId, this.email, this.lastName, this.firstName, this.fullName, this.isSuspended, this.picture, User.hashCodeNullable(this.isPasswordResetRequested), User.hashCodeNullable(this.totalSignIns), User.hashCodeNullable(this.failedSignIns), User.hashCodeNullable(this.lastSignedIn), User.hashCodeNullable(this.createdOn));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class User {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    providedId: ").append(this.toIndentedString(this.providedId)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    fullName: ").append(this.toIndentedString(this.fullName)).append("\n");
        sb.append("    isSuspended: ").append(this.toIndentedString(this.isSuspended)).append("\n");
        sb.append("    picture: ").append(this.toIndentedString(this.picture)).append("\n");
        sb.append("    isPasswordResetRequested: ").append(this.toIndentedString(this.isPasswordResetRequested)).append("\n");
        sb.append("    totalSignIns: ").append(this.toIndentedString(this.totalSignIns)).append("\n");
        sb.append("    failedSignIns: ").append(this.toIndentedString(this.failedSignIns)).append("\n");
        sb.append("    lastSignedIn: ").append(this.toIndentedString(this.lastSignedIn)).append("\n");
        sb.append("    createdOn: ").append(this.toIndentedString(this.createdOn)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

