/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonTypeName(value="user_profile")
public class UserProfile {
    private String id;
    private String preferredEmail;
    private JsonNullable<String> providedId = JsonNullable.undefined();
    private String lastName;
    private String firstName;
    private String picture;

    public UserProfile id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", description="Unique id of the user in Kinde.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public UserProfile preferredEmail(String preferredEmail) {
        this.preferredEmail = preferredEmail;
        return this;
    }

    @Schema(name="preferred_email", description="Default email address of the user in Kinde.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="preferred_email")
    public String getPreferredEmail() {
        return this.preferredEmail;
    }

    public void setPreferredEmail(String preferredEmail) {
        this.preferredEmail = preferredEmail;
    }

    public UserProfile providedId(String providedId) {
        this.providedId = JsonNullable.of((Object)providedId);
        return this;
    }

    @Schema(name="provided_id", description="Value of the user's id in a third-party system when the user is imported into Kinde.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="provided_id")
    public JsonNullable<String> getProvidedId() {
        return this.providedId;
    }

    public void setProvidedId(JsonNullable<String> providedId) {
        this.providedId = providedId;
    }

    public UserProfile lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Schema(name="last_name", description="User's last name.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="last_name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public UserProfile firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Schema(name="first_name", description="User's first name.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="first_name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public UserProfile picture(String picture) {
        this.picture = picture;
        return this;
    }

    @Schema(name="picture", description="URL that point's to the user's picture or avatar", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="picture")
    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserProfile userProfile = (UserProfile)o;
        return Objects.equals(this.id, userProfile.id) && Objects.equals(this.preferredEmail, userProfile.preferredEmail) && UserProfile.equalsNullable(this.providedId, userProfile.providedId) && Objects.equals(this.lastName, userProfile.lastName) && Objects.equals(this.firstName, userProfile.firstName) && Objects.equals(this.picture, userProfile.picture);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.preferredEmail, UserProfile.hashCodeNullable(this.providedId), this.lastName, this.firstName, this.picture);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserProfile {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    preferredEmail: ").append(this.toIndentedString(this.preferredEmail)).append("\n");
        sb.append("    providedId: ").append(this.toIndentedString(this.providedId)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    picture: ").append(this.toIndentedString(this.picture)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

