/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Objects;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonTypeName(value="user_profile_v2")
public class UserProfileV2 {
    private String id;
    private String sub;
    private JsonNullable<String> providedId = JsonNullable.undefined();
    private String name;
    private String givenName;
    private String familyName;
    private Integer updatedAt;
    private String email;
    private String picture;

    public UserProfileV2 id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", description="Unique id of the user in Kinde (deprecated).", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public UserProfileV2 sub(String sub) {
        this.sub = sub;
        return this;
    }

    @Schema(name="sub", description="Unique id of the user in Kinde.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="sub")
    public String getSub() {
        return this.sub;
    }

    public void setSub(String sub) {
        this.sub = sub;
    }

    public UserProfileV2 providedId(String providedId) {
        this.providedId = JsonNullable.of((Object)providedId);
        return this;
    }

    @Schema(name="provided_id", description="Value of the user's id in a third-party system when the user is imported into Kinde.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="provided_id")
    public JsonNullable<String> getProvidedId() {
        return this.providedId;
    }

    public void setProvidedId(JsonNullable<String> providedId) {
        this.providedId = providedId;
    }

    public UserProfileV2 name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", description="Users's first and last name separated by a space.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UserProfileV2 givenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    @Schema(name="given_name", description="User's first name.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="given_name")
    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public UserProfileV2 familyName(String familyName) {
        this.familyName = familyName;
        return this;
    }

    @Schema(name="family_name", description="User's last name.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="family_name")
    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public UserProfileV2 updatedAt(Integer updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Schema(name="updated_at", description="Date the user was last updated at (In Unix time).", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="updated_at")
    public Integer getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Integer updatedAt) {
        this.updatedAt = updatedAt;
    }

    public UserProfileV2 email(String email) {
        this.email = email;
        return this;
    }

    @Schema(name="email", description="User's email address if available.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UserProfileV2 picture(String picture) {
        this.picture = picture;
        return this;
    }

    @Schema(name="picture", description="URL that point's to the user's picture or avatar", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="picture")
    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserProfileV2 userProfileV2 = (UserProfileV2)o;
        return Objects.equals(this.id, userProfileV2.id) && Objects.equals(this.sub, userProfileV2.sub) && UserProfileV2.equalsNullable(this.providedId, userProfileV2.providedId) && Objects.equals(this.name, userProfileV2.name) && Objects.equals(this.givenName, userProfileV2.givenName) && Objects.equals(this.familyName, userProfileV2.familyName) && Objects.equals(this.updatedAt, userProfileV2.updatedAt) && Objects.equals(this.email, userProfileV2.email) && Objects.equals(this.picture, userProfileV2.picture);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.id, this.sub, UserProfileV2.hashCodeNullable(this.providedId), this.name, this.givenName, this.familyName, this.updatedAt, this.email, this.picture);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserProfileV2 {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    sub: ").append(this.toIndentedString(this.sub)).append("\n");
        sb.append("    providedId: ").append(this.toIndentedString(this.providedId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    familyName: ").append(this.toIndentedString(this.familyName)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    picture: ").append(this.toIndentedString(this.picture)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

