/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.openapitools.model.User;

@JsonTypeName(value="users_response")
public class UsersResponse {
    private String code;
    private String message;
    @Valid
    private @Valid List<@Valid User> users;
    private String nextToken;

    public UsersResponse code(String code) {
        this.code = code;
        return this;
    }

    @Schema(name="code", description="Response code.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="code")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public UsersResponse message(String message) {
        this.message = message;
        return this;
    }

    @Schema(name="message", description="Response message.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public UsersResponse users(List<@Valid User> users) {
        this.users = users;
        return this;
    }

    public UsersResponse addUsersItem(User usersItem) {
        if (this.users == null) {
            this.users = new ArrayList<User>();
        }
        this.users.add(usersItem);
        return this;
    }

    @Valid
    @Schema(name="users", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="users")
    public @Valid List<@Valid User> getUsers() {
        return this.users;
    }

    public void setUsers(List<@Valid User> users) {
        this.users = users;
    }

    public UsersResponse nextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    @Schema(name="next_token", description="Pagination token.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="next_token")
    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsersResponse usersResponse = (UsersResponse)o;
        return Objects.equals(this.code, usersResponse.code) && Objects.equals(this.message, usersResponse.message) && Objects.equals(this.users, usersResponse.users) && Objects.equals(this.nextToken, usersResponse.nextToken);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.message, this.users, this.nextToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsersResponse {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    users: ").append(this.toIndentedString(this.users)).append("\n");
        sb.append("    nextToken: ").append(this.toIndentedString(this.nextToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

