/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.sdk;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openapitools.sdk.KindeClientSDK;
import org.openapitools.sdk.enums.StorageEnums;
import org.openapitools.sdk.storage.Storage;
import org.openapitools.sdk.utils.Utils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;

public class CallbackController {
    private KindeClientSDK kindeClientSDK;
    private Storage storage;

    public CallbackController(KindeClientSDK kindeClientSDK) {
        this.kindeClientSDK = kindeClientSDK;
        this.storage = this.kindeClientSDK.getStorage();
    }

    public RedirectView callback(String code, String state, HttpServletResponse response, HttpServletRequest request) {
        String codeVerifierCookie = Storage.getState(request);
        if (codeVerifierCookie != null) {
            try {
                RestTemplate restTemplate = new RestTemplate();
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
                headers.add("Kinde-SDK", "Java/1.2.0");
                LinkedMultiValueMap body = new LinkedMultiValueMap();
                body.add((Object)"client_id", (Object)this.kindeClientSDK.getClientId());
                body.add((Object)"client_secret", (Object)this.kindeClientSDK.getClientSecret());
                body.add((Object)"code", (Object)code);
                if (this.kindeClientSDK.getGrantType().equals("authorization_code_flow_pkce")) {
                    String codeVerifier = Storage.getCodeVerifier(request);
                    body.add((Object)"grant_type", (Object)"authorization_code");
                    body.add((Object)"code_verifier", (Object)codeVerifier);
                } else {
                    body.add((Object)"scope", (Object)this.kindeClientSDK.getScopes());
                    body.add((Object)"grant_type", (Object)this.kindeClientSDK.getGrantType());
                }
                body.add((Object)"redirect_uri", (Object)(this.kindeClientSDK.getLogoutRedirectUri() + "/api/auth/kinde_callback"));
                HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
                ResponseEntity responseEntity = restTemplate.exchange(this.kindeClientSDK.getDomain() + "/oauth2/token", HttpMethod.POST, requestEntity, Object.class, new Object[0]);
                Object data_ = responseEntity.getBody();
                Map data = (Map)data_;
                String accessToken = (String)data.get("access_token");
                Map<String, Object> payload = Utils.parseJWT(accessToken);
                boolean isAudienceValid = true;
                if (payload.get("iss").equals(this.kindeClientSDK.getDomain()) && isAudienceValid && (long)((Integer)payload.get("exp")).intValue() > System.currentTimeMillis() / 1000L) {
                    String newKey = "kinde_" + StorageEnums.TOKEN.getValue();
                    Cookie cookie = new Cookie(newKey, URLEncoder.encode(new ObjectMapper().writeValueAsString((Object)((Map)data_)), "UTF-8"));
                    Long exp = System.currentTimeMillis() + 1296000000L;
                    cookie.setMaxAge(exp.intValue());
                    cookie.setPath("/");
                    cookie.setSecure(true);
                    cookie.setHttpOnly(true);
                    response.addCookie(cookie);
                } else {
                    System.out.println("One or more of the claims were not verified.");
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
            String redirectUrl = this.kindeClientSDK.getLogoutRedirectUri();
            return new RedirectView(redirectUrl);
        }
        String logoutUrl = UriComponentsBuilder.fromHttpUrl((String)this.kindeClientSDK.getLogoutEndpoint()).queryParam("redirect", new Object[]{this.kindeClientSDK.getLogoutRedirectUri()}).build().toUriString();
        return new RedirectView(logoutUrl);
    }
}

