/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.sdk;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.sdk.enums.GrantType;
import org.openapitools.sdk.enums.StorageEnums;
import org.openapitools.sdk.enums.TokenType;
import org.openapitools.sdk.oauth2.AuthorizationCode;
import org.openapitools.sdk.oauth2.ClientCredentials;
import org.openapitools.sdk.oauth2.PKCE;
import org.openapitools.sdk.storage.Storage;
import org.openapitools.sdk.utils.Utils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;

public class KindeClientSDK {
    private String domain;
    private String redirectUri;
    private String logoutRedirectUri;
    private String clientId;
    private String clientSecret;
    private String authorizationEndpoint;
    private String tokenEndpoint;
    private String logoutEndpoint;
    private String grantType;
    private Map<String, Object> additionalParameters;
    private String scopes;
    private String protocol;
    private Storage storage;

    public String getDomain() {
        return this.domain;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public String getLogoutRedirectUri() {
        return this.logoutRedirectUri;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public String getLogoutEndpoint() {
        return this.logoutEndpoint;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public Map<String, Object> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public String getScopes() {
        return this.scopes;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public KindeClientSDK() {
    }

    public KindeClientSDK(String domain, String redirectUri, String clientId, String clientSecret, String grantType, String logoutRedirectUri, String scopes, Map<String, Object> additionalParameters, String protocol) {
        if (domain == null || domain.isEmpty()) {
            throw new IllegalArgumentException("Please provide domain");
        }
        if (!Utils.validateURL(domain)) {
            throw new IllegalArgumentException("Please provide valid domain");
        }
        this.domain = domain;
        if (redirectUri == null || redirectUri.isEmpty()) {
            throw new IllegalArgumentException("Please provide redirect_uri");
        }
        if (!Utils.validateURL(redirectUri)) {
            throw new IllegalArgumentException("Please provide valid redirect_uri");
        }
        this.redirectUri = redirectUri;
        if (clientSecret == null || clientSecret.isEmpty()) {
            throw new IllegalArgumentException("Please provide client_secret");
        }
        this.clientSecret = clientSecret;
        if (clientId == null || clientId.isEmpty()) {
            throw new IllegalArgumentException("Please provide client_id");
        }
        this.clientId = clientId;
        if (grantType == null || grantType.isEmpty()) {
            throw new IllegalArgumentException("Please provide grant_type");
        }
        this.grantType = grantType;
        if (logoutRedirectUri == null || logoutRedirectUri.isEmpty()) {
            throw new IllegalArgumentException("Please provide logout_redirect_uri");
        }
        if (!Utils.validateURL(logoutRedirectUri)) {
            throw new IllegalArgumentException("Please provide valid logout_redirect_uri");
        }
        if (additionalParameters == null) {
            additionalParameters = new HashMap<String, Object>();
        }
        this.additionalParameters = Utils.checkAdditionalParameters(additionalParameters);
        this.logoutRedirectUri = logoutRedirectUri;
        if (scopes == null || scopes.equals("")) {
            scopes = "openid profile email offline";
        }
        this.scopes = scopes;
        if (protocol == null) {
            protocol = "";
        }
        this.protocol = protocol;
        this.authorizationEndpoint = this.domain + "/oauth2/auth";
        this.tokenEndpoint = this.domain + "/oauth2/token";
        this.logoutEndpoint = this.domain + "/logout";
        this.storage = Storage.getInstance();
    }

    public KindeClientSDK(String domain, String redirectUri, String clientId, String clientSecret, String grantType, String logoutRedirectUri, String scopes, Map<String, Object> additionalParameters) {
        this(domain, redirectUri, clientId, clientSecret, grantType, logoutRedirectUri, scopes, additionalParameters, null);
    }

    public KindeClientSDK(String domain, String redirectUri, String clientId, String clientSecret, String grantType, String logoutRedirectUri, String scopes) {
        this(domain, redirectUri, clientId, clientSecret, grantType, logoutRedirectUri, scopes, null, null);
    }

    public KindeClientSDK(String domain, String redirectUri, String clientId, String clientSecret, String grantType, String logoutRedirectUri) {
        this(domain, redirectUri, clientId, clientSecret, grantType, logoutRedirectUri, null, null, null);
    }

    public KindeClientSDK(String domain, String redirectUri, String clientId, String clientSecret, String grantType, String logoutRedirectUri, Map<String, Object> additionalParameters) {
        this(domain, redirectUri, clientId, clientSecret, grantType, logoutRedirectUri, null, additionalParameters, null);
    }

    public Object login(HttpServletResponse response, Map<String, Object> additionalParameters) {
        this.cleanStorage(response);
        try {
            switch (this.grantType) {
                case "client_credentials": {
                    ClientCredentials clientCredentials = new ClientCredentials(this.storage);
                    return clientCredentials.authenticate(response, this, additionalParameters);
                }
                case "authorization_code": {
                    AuthorizationCode authorizationCode = new AuthorizationCode(this.storage);
                    return authorizationCode.authenticate(response, this, "login", additionalParameters);
                }
                case "authorization_code_flow_pkce": {
                    PKCE pkce = new PKCE(this.storage);
                    return pkce.authenticate(response, this, "login", additionalParameters);
                }
            }
            throw new IllegalArgumentException("Please provide correct grant_type");
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    public Object login(HttpServletResponse response) {
        return this.login(response, new HashMap<String, Object>());
    }

    public Object register(HttpServletResponse resp, Map<String, Object> additionalParameters) {
        switch (this.grantType) {
            case "client_credentials": {
                ClientCredentials clientCredentials = new ClientCredentials(this.storage);
                return clientCredentials.authenticate(resp, this, additionalParameters);
            }
            case "authorization_code": {
                AuthorizationCode authorizationCode = new AuthorizationCode(this.storage);
                return authorizationCode.authenticate(resp, this, "registration", additionalParameters);
            }
            case "authorization_code_flow_pkce": {
                PKCE pkce = new PKCE(this.storage);
                return pkce.authenticate(resp, this, "registration", additionalParameters);
            }
        }
        throw new IllegalArgumentException("Please provide correct grant_type");
    }

    public Object register(HttpServletResponse response) {
        return this.register(response, new HashMap<String, Object>());
    }

    public Object createOrg(HttpServletResponse resp, Map<String, Object> additionalParameters) {
        additionalParameters.put("is_create_org", "true");
        if (!additionalParameters.containsKey("org_name")) {
            additionalParameters.put("org_name", "");
        }
        return this.register(resp, additionalParameters);
    }

    public Object createOrg(HttpServletResponse resp, String orgName) {
        HashMap<String, Object> additionalParameters_ = new HashMap<String, Object>();
        additionalParameters_.put("is_create_org", "true");
        additionalParameters_.put("org_name", orgName);
        return this.register(resp, additionalParameters_);
    }

    public Object createOrg(HttpServletResponse response) {
        return this.createOrg(response, new HashMap<String, Object>());
    }

    public RedirectView logout(HttpServletResponse response) {
        this.cleanStorage(response);
        String logoutUrl = UriComponentsBuilder.fromHttpUrl((String)this.logoutEndpoint).queryParam("redirect", new Object[]{this.logoutRedirectUri}).build().toUriString();
        return new RedirectView(logoutUrl);
    }

    public Object getToken(HttpServletResponse response, HttpServletRequest req) throws Exception {
        String authorizationCode;
        String error;
        MultiValueMap params;
        if (GrantType.CLIENT_CREDENTIALS.getValue().equals(this.grantType)) {
            return this.login(response, new HashMap<String, Object>());
        }
        if (this.isAuthenticated(req, response)) {
            Map<String, Object> token = Storage.getToken(req);
            if (token != null) {
                return token;
            }
        }
        String newGrantType = this.getGrantType(this.grantType);
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        formParams.add((Object)"client_id", (Object)this.getClientId());
        formParams.add((Object)"client_secret", (Object)this.getClientSecret());
        formParams.add((Object)"grant_type", (Object)newGrantType);
        formParams.add((Object)"redirect_uri", (Object)this.getRedirectUri());
        formParams.add((Object)"response_type", (Object)"code");
        String url = req.getRequestURL().toString();
        String queryString = req.getQueryString();
        if (queryString != null) {
            url = url + "?" + queryString;
        }
        String stateServer = (params = UriComponentsBuilder.fromUriString((String)url).build().getQueryParams()).containsKey((Object)"state") && params.getFirst((Object)"state") != null ? (String)params.getFirst((Object)"state") : "";
        this.checkStateAuthentication(req, stateServer);
        String string = error = params.containsKey((Object)"error") && params.getFirst((Object)"error") != null ? (String)params.getFirst((Object)"error") : "";
        if (!StringUtils.isEmpty((CharSequence)error)) {
            String errorDescription = params.containsKey((Object)"error_description") && params.getFirst((Object)"error_description") != null ? (String)params.getFirst((Object)"error_description") : "";
            String msg = !StringUtils.isEmpty((CharSequence)errorDescription) ? errorDescription : error;
            throw new IllegalArgumentException(msg);
        }
        String string2 = authorizationCode = params.containsKey((Object)"code") && params.getFirst((Object)"code") != null ? (String)params.getFirst((Object)"code") : "";
        if (StringUtils.isEmpty((CharSequence)authorizationCode)) {
            throw new IllegalArgumentException("Not found code param");
        }
        formParams.add((Object)"code", (Object)authorizationCode);
        String codeVerifier = Storage.getCodeVerifier(req);
        if (!StringUtils.isEmpty((CharSequence)codeVerifier)) {
            formParams.add((Object)"code_verifier", (Object)codeVerifier);
        } else if (GrantType.PKCE.getValue().equals(this.getGrantType())) {
            throw new IllegalArgumentException("Not found code_verifier");
        }
        return this.fetchToken(response, (MultiValueMap<String, String>)formParams);
    }

    public Map<String, Object> getUserDetails(HttpServletRequest req) {
        return Storage.getUserProfile(req);
    }

    public Map<String, Object> getClaim(HttpServletRequest req, String keyName, String tokenType) {
        Map<String, Object> data = this.getClaims(req, tokenType);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("name", keyName);
        result.put("value", data.containsKey(keyName) && data.get(keyName) != null ? data.get(keyName) : null);
        return result;
    }

    public Map<String, Object> getClaim(HttpServletRequest req, String keyName) {
        return this.getClaim(req, keyName, TokenType.ACCESS_TOKEN.getValue());
    }

    public Map<String, Object> getPermissions(HttpServletRequest req) {
        Map<String, Object> claims = this.getClaims(req);
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("orgCode", claims.get("org_code"));
        response.put("permissions", claims.get("permissions"));
        return response;
    }

    public Map<String, Object> getPermission(HttpServletRequest req, String permission) {
        Map<String, Object> allClaims = this.getClaims(req);
        List permissions = (List)allClaims.get("permissions");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("orgCode", allClaims.get("org_code"));
        result.put("isGranted", permissions.contains(permission));
        return result;
    }

    public Map<String, Object> getOrganization(HttpServletRequest req) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("orgCode", this.getClaim(req, "org_code").get("value"));
        return response;
    }

    public Map<String, Object> getUserOrganizations(HttpServletRequest req) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("orgCodes", this.getClaim(req, "org_codes", TokenType.ID_TOKEN.getValue()).get("value"));
        return response;
    }

    public Map<String, Object> getBooleanFlag(HttpServletRequest req, String flagName, Object defaultValue) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("defaultValue", defaultValue);
        return this.getFlag(req, flagName, options, "b");
    }

    public Map<String, Object> getBooleanFlag(HttpServletRequest req, String flagName) {
        return this.getBooleanFlag(req, flagName, null);
    }

    public Map<String, Object> getStringFlag(HttpServletRequest req, String flagName, Object defaultValue) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("defaultValue", defaultValue);
        return this.getFlag(req, flagName, options, "s");
    }

    public Map<String, Object> getStringFlag(HttpServletRequest req, String flagName) {
        return this.getStringFlag(req, flagName, null);
    }

    public Map<String, Object> getIntegerFlag(HttpServletRequest req, String flagName, Object defaultValue) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("defaultValue", defaultValue);
        return this.getFlag(req, flagName, options, "i");
    }

    public Map<String, Object> getIntegerFlag(HttpServletRequest req, String flagName) {
        return this.getIntegerFlag(req, flagName, null);
    }

    public Map<String, Object> getFlag(HttpServletRequest req, String flagName, Map<String, Object> options, String flagType) {
        boolean isUsedDefault = false;
        Map<String, Object> flag = this.getFeatureFlags(req, flagName);
        if (flag == null || flag.isEmpty()) {
            isUsedDefault = true;
            flag = new HashMap<String, Object>();
            flag.put("v", options.get("defaultValue"));
            flag.put("t", flagType);
        }
        if (!flag.containsKey("v") || flag.get("v") == null) {
            throw new IllegalArgumentException("This flag '" + flagName + "' was not found, and no default value has been provided");
        }
        String flagTypeParsed = Utils.listType.get(flag.get("t"));
        String requestType = Utils.listType.get(flagType);
        if (requestType != null && !flagTypeParsed.equals(requestType)) {
            throw new IllegalArgumentException("Flag '" + flagName + "' is type " + flagTypeParsed + " - requested type " + requestType);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("code", flagName);
        result.put("type", flagTypeParsed);
        result.put("value", flag.get("v"));
        result.put("is_default", isUsedDefault);
        return result;
    }

    public Map<String, Object> getFlag(HttpServletRequest req, String flagName) {
        return this.getFlag(req, flagName, new HashMap<String, Object>(), null);
    }

    public Map<String, Object> getFlag(HttpServletRequest req, String flagName, Map<String, Object> options) {
        return this.getFlag(req, flagName, options, null);
    }

    public Map<String, Object> getFlag(HttpServletRequest req, String flagName, String flagType) {
        return this.getFlag(req, flagName, new HashMap<String, Object>(), flagType);
    }

    private Map<String, Object> getFeatureFlags(HttpServletRequest req, String name) {
        Map flags = (Map)this.getClaim(req, "feature_flags").get("value");
        if (name != null && flags != null && !flags.isEmpty()) {
            return (Map)flags.get(name);
        }
        return flags;
    }

    private Map<String, Object> getFeatureFlags(HttpServletRequest req) {
        return this.getFeatureFlags(req, null);
    }

    private Object fetchToken(HttpServletResponse resp, MultiValueMap<String, String> formParams) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.add("Kinde-SDK", "Java/1.2.0");
        HttpEntity requestEntity = new HttpEntity(formParams, (MultiValueMap)headers);
        ResponseEntity response = restTemplate.postForEntity(this.tokenEndpoint, (Object)requestEntity, Object.class, new Object[0]);
        Object token = response.getBody();
        Storage.setToken(resp, token);
        Map tokenMap = null;
        if (token instanceof Map) {
            tokenMap = (Map)token;
        } else {
            try {
                JsonNode jsonNode = new ObjectMapper().readTree((String)token);
                Iterator fields = jsonNode.fields();
                while (fields.hasNext()) {
                    Map.Entry field = (Map.Entry)fields.next();
                    tokenMap.put((String)field.getKey(), ((JsonNode)field.getValue()).asText());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Storage.removeItem(resp, StorageEnums.CODE_VERIFIER.getValue());
        Storage.removeItem(resp, StorageEnums.STATE.getValue());
        return tokenMap;
    }

    public boolean isAuthenticated(HttpServletRequest req, HttpServletResponse resp) {
        boolean authenticated;
        long timeExpired = Storage.getExpiredAt(req);
        boolean bl = authenticated = timeExpired > System.currentTimeMillis() / 1000L;
        if (authenticated) {
            return true;
        }
        try {
            String refreshToken = Storage.getRefreshToken(req);
            if (!StringUtils.isEmpty((CharSequence)refreshToken)) {
                LinkedMultiValueMap formParams = new LinkedMultiValueMap();
                formParams.add((Object)"client_id", (Object)this.clientId);
                formParams.add((Object)"client_secret", (Object)this.clientSecret);
                formParams.add((Object)"grant_type", (Object)"refresh_token");
                formParams.add((Object)"refresh_token", (Object)refreshToken);
                Map token = (Map)this.fetchToken(resp, (MultiValueMap<String, String>)formParams);
                if (token != null && (Integer)token.get("expires_in") > 0) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public Map<String, Object> getClaims(HttpServletRequest req, String tokenType) {
        String token;
        if (!tokenType.equals(TokenType.ACCESS_TOKEN.getValue()) && !tokenType.equals(TokenType.ID_TOKEN.getValue())) {
            throw new IllegalArgumentException("Please provide valid token (access_token or id_token) to get claim");
        }
        String string = tokenType.equals(TokenType.ACCESS_TOKEN.getValue()) ? Storage.getAccessToken(req) : (token = Storage.getIdToken(req));
        if (token == null || token.isEmpty()) {
            throw new RuntimeException("Request is missing required authentication credential");
        }
        return Utils.parseJWT(token);
    }

    public Map<String, Object> getClaims(HttpServletRequest req) {
        return this.getClaims(req, TokenType.ACCESS_TOKEN.getValue());
    }

    private void cleanStorage(HttpServletResponse response) {
        Storage.clear(response);
    }

    private String getProtocol(HttpServletRequest req) {
        if (this.protocol != null && !this.protocol.isEmpty()) {
            return this.protocol;
        }
        return req.isSecure() ? "https" : "http";
    }

    private void checkStateAuthentication(HttpServletRequest req, String stateServer) {
        String storageOAuthState = Storage.getState(req);
        if (storageOAuthState == null || storageOAuthState.equals("") || !stateServer.equals(storageOAuthState)) {
            throw new IllegalArgumentException("Authentication failed because it tries to validate state");
        }
    }

    private String getGrantType(String grantType) {
        switch (grantType) {
            case "authorization_code": 
            case "authorization_code_flow_pkce": {
                return "authorization_code";
            }
            case "client_credentials": {
                return "client_credentials";
            }
        }
        throw new IllegalArgumentException("Please provide correct grant_type");
    }
}

