/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.sdk.oauth2;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.openapitools.sdk.KindeClientSDK;
import org.openapitools.sdk.enums.GrantType;
import org.openapitools.sdk.storage.Storage;
import org.openapitools.sdk.utils.Utils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class AuthorizationCode {
    private final Storage storage;

    @Autowired
    public AuthorizationCode(Storage storage) {
        this.storage = storage;
    }

    public RedirectView authenticate(HttpServletResponse response, KindeClientSDK clientSDK, String startPage, Map<String, Object> additionalParameters) {
        String state = Utils.randomString();
        Storage.setState(response, state);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)clientSDK.getAuthorizationEndpoint()).queryParam("client_id", new Object[]{clientSDK.getClientId()}).queryParam("grant_type", new Object[]{GrantType.AUTHORIZATION_CODE.getValue()}).queryParam("redirect_uri", new Object[]{clientSDK.getRedirectUri()}).queryParam("response_type", new Object[]{"code"}).queryParam("scope", new Object[]{clientSDK.getScopes()}).queryParam("state", new Object[]{state}).queryParam("start_page", new Object[]{startPage});
        Map<String, Object> mergedAdditionalParameters = Utils.addAdditionalParameters(clientSDK.getAdditionalParameters(), additionalParameters);
        mergedAdditionalParameters.forEach((x$0, xva$1) -> uriBuilder.queryParam(x$0, new Object[]{xva$1}));
        String authUrl = uriBuilder.build().toUriString();
        RedirectView redirectView = new RedirectView();
        redirectView.setUrl(authUrl);
        return redirectView;
    }

    public RedirectView authenticate(HttpServletResponse response, KindeClientSDK clientSDK, String startPage) {
        return this.authenticate(response, clientSDK, startPage, new HashMap<String, Object>());
    }
}

