/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.sdk.oauth2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.openapitools.sdk.KindeClientSDK;
import org.openapitools.sdk.enums.GrantType;
import org.openapitools.sdk.storage.Storage;
import org.openapitools.sdk.utils.Utils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ClientCredentials {
    private Storage storage;

    public ClientCredentials(Storage storage) {
        this.storage = storage;
    }

    public Map<String, Object> authenticate(HttpServletResponse resp, KindeClientSDK clientSDK, Map<String, Object> additionalParameters) {
        try {
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            headers.add("Kinde-SDK", "Java/1.2.0");
            LinkedMultiValueMap formData = new LinkedMultiValueMap();
            formData.add((Object)"client_id", (Object)clientSDK.getClientId());
            formData.add((Object)"client_secret", (Object)clientSDK.getClientSecret());
            formData.add((Object)"grant_type", (Object)GrantType.CLIENT_CREDENTIALS.getValue());
            formData.add((Object)"scope", (Object)clientSDK.getScopes());
            Map<String, Object> mergedAdditionalParameters = Utils.addAdditionalParameters(clientSDK.getAdditionalParameters(), additionalParameters);
            formData.setAll(mergedAdditionalParameters);
            HttpEntity requestEntity = new HttpEntity((Object)formData, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.postForEntity(clientSDK.getTokenEndpoint(), (Object)requestEntity, Object.class, new Object[0]);
            Object token = response.getBody();
            Storage.setToken(resp, token);
            Map tokenMap = null;
            if (token instanceof Map) {
                tokenMap = (Map)token;
            } else {
                JsonNode jsonNode = new ObjectMapper().readTree((String)token);
                Iterator fields = jsonNode.fields();
                while (fields.hasNext()) {
                    Map.Entry field = (Map.Entry)fields.next();
                    tokenMap.put((String)field.getKey(), ((JsonNode)field.getValue()).asText());
                }
            }
            return tokenMap;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return new HashMap<String, Object>();
        }
    }

    public Map<String, Object> authenticate(HttpServletResponse resp, KindeClientSDK clientSDK) {
        return this.authenticate(resp, clientSDK, new HashMap<String, Object>());
    }
}

