/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.sdk.oauth2;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.openapitools.sdk.KindeClientSDK;
import org.openapitools.sdk.enums.StorageEnums;
import org.openapitools.sdk.storage.Storage;
import org.openapitools.sdk.utils.Utils;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class PKCE {
    private Storage storage;

    public PKCE(Storage storage) {
        this.storage = storage;
    }

    public RedirectView authenticate(HttpServletResponse response, KindeClientSDK clientSDK, String startPage, Map<String, Object> additionalParameters) {
        Storage.removeItem(response, StorageEnums.CODE_VERIFIER.getValue());
        Map<String, String> challenge = Utils.generateChallenge();
        String state = challenge.get("state");
        Storage.setState(response, state);
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)clientSDK.getAuthorizationEndpoint()).queryParam("redirect_uri", new Object[]{clientSDK.getRedirectUri()}).queryParam("client_id", new Object[]{clientSDK.getClientId()}).queryParam("response_type", new Object[]{"code"}).queryParam("scope", new Object[]{clientSDK.getScopes()}).queryParam("code_challenge", new Object[]{challenge.get("codeChallenge")}).queryParam("code_challenge_method", new Object[]{"S256"}).queryParam("state", new Object[]{state}).queryParam("start_page", new Object[]{startPage});
        Map<String, Object> mergedAdditionalParameters = Utils.addAdditionalParameters(clientSDK.getAdditionalParameters(), additionalParameters);
        mergedAdditionalParameters.forEach((x$0, xva$1) -> uriBuilder.queryParam(x$0, new Object[]{xva$1}));
        Storage.setCodeVerifier(response, challenge.get("codeVerifier"));
        String authorizationUrl = uriBuilder.build().toUriString();
        RedirectView redirectView = new RedirectView();
        System.out.println(authorizationUrl);
        redirectView.setUrl(authorizationUrl);
        return redirectView;
    }

    public RedirectView authenticate(HttpServletResponse response, KindeClientSDK clientSDK) {
        return this.authenticate(response, clientSDK, "login", new HashMap<String, Object>());
    }

    public RedirectView authenticate(HttpServletResponse response, KindeClientSDK clientSDK, String startPage) {
        return this.authenticate(response, clientSDK, startPage, new HashMap<String, Object>());
    }

    public RedirectView authenticate(HttpServletResponse response, KindeClientSDK clientSDK, Map<String, Object> additionalParameters) {
        return this.authenticate(response, clientSDK, "login", additionalParameters);
    }
}

