/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.sdk.storage;

import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openapitools.sdk.enums.StorageEnums;

public class BaseStorage {
    private static final String PREFIX = "kinde";
    private static Map<String, String> storage;

    public static String getItem(HttpServletRequest request, String key) {
        String cookieName = BaseStorage.getKey(key);
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie.getValue();
            }
        }
        return "";
    }

    public static void setItem(HttpServletResponse response, String key, String value, int expiresOrOptions, String path, String domain, boolean secure, boolean httpOnly) {
        String newKey = BaseStorage.getKey(key);
        Cookie cookie = new Cookie(newKey, value);
        cookie.setMaxAge(expiresOrOptions);
        cookie.setPath(path);
        cookie.setDomain(domain);
        cookie.setSecure(secure);
        cookie.setHttpOnly(httpOnly);
        response.addCookie(cookie);
    }

    public static void setItem(HttpServletResponse response, String key, String value) {
        BaseStorage.setItem(response, key, value, 0, "", "", true, false);
    }

    public static void setItem(HttpServletResponse response, String key, String value, int expiresOrOptions) {
        BaseStorage.setItem(response, key, value, expiresOrOptions, "", "", true, false);
    }

    public static void removeItem(HttpServletResponse response, String key) {
        String cookieName = BaseStorage.getKey(key);
        Cookie cookie = new Cookie(cookieName, "");
        cookie.setMaxAge(0);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    public static void clear(HttpServletResponse response) {
        BaseStorage.removeItem(response, StorageEnums.TOKEN.getValue());
        BaseStorage.removeItem(response, StorageEnums.STATE.getValue());
        BaseStorage.removeItem(response, StorageEnums.CODE_VERIFIER.getValue());
        BaseStorage.removeItem(response, StorageEnums.USER_PROFILE.getValue());
    }

    private static String getKey(String key) {
        return "kinde_" + key;
    }
}

